#ifndef __TDS_STRUCT_H__
#define __TDS_STRUCT_H__

#include <string.h>

#pragma pack(push)
#pragma pack(1)

#define TDS_VERSION "2.3.8"
	
#define TDS_MSG_NOTIFY_DISCONNECT				1           //网络断开
#define TDS_MSG_NOTIFY_DISCONNECT_NETWORKFCARD	2           //网络断开-网卡不正常
#define TDS_MSG_NOTIFY_DISCONNECT_ACTIVE		3           //网络断开-重复登录被T下线
	
#define TDS_MSG_DATACLASS_TICKINDEX		1	    //指数快照
#define	TDS_MSG_DATACLASS_TICKSTOCK		2		//证券快照：股票、基金、债券
#define TDS_MSG_DATACLASS_ORDERQUEUE	3		//委托队列
#define	TDS_MSG_DATACLASS_ORDER			4       //逐笔委托
#define	TDS_MSG_DATACLASS_TRANSACTION	5		//逐笔成交
#define	TDS_MSG_DATACLASS_SUPERSTOCK	6		//超级盘口

#define	TDS_SUBOP_TYPE_SUB		1				//该市场全新订阅数据，取消原来的所有订阅结果
#define	TDS_SUBOP_TYPE_UNSUB    2				//该市场取消所有订阅
#define	TDS_SUBOP_TYPE_ADD		3				//该市场增加订阅代码
#define	TDS_SUBOP_TYPE_DEL		4				//该市场删除订阅代码，若之前没有订阅将忽略

#define TDS_NORMAL_RETURN_VERSION_LOW		1			//版本过低，请及时更新
#define TDS_NORMAL_RETURN_ERROR				-1001		//一般错误
#define TDS_NORMAL_RETURN_NORESPONSE		-1002		//超时无响应
#define TDS_NORMAL_RETURN_IPBAN				-1003		//ip禁止访问
#define TDS_NORMAL_RETURN_USERINFOERR		-1004		//用户名密码错误
#define TDS_NORMAL_RETURN_ERRORCONNCET		-1005		//无法连接至服务器
#define TDS_NORMAL_RETURN_ERRORIP			-1006		//错误ip
#define TDS_NORMAL_RETURN_ERRORMARKET		-1007		//错误市场
#define TDS_NORMAL_RETURN_ERRORCODE			-1008		//错误代码
#define TDS_NORMAL_RETURN_ERRORHANDLE		-1009		//无效handle
#define TDS_NORMAL_RETURN_ERRORDATATYPE		-1010		//无效数据类型
#define TDS_NORMAL_RETURN_ERRORSUB			-1011		//非法订阅操作
#define TDS_NORMAL_RETURN_VARIFYFAILL		-1012       //登录认证失败（认证中心）
#define TDS_NORMAL_RETURN_TDSVARIFYFAILL	-1013       //登录验证失败（服务端）
#define TDS_NORMAL_RETURN_SOCKET_ERRORIP	-1014       //级联模式下主IP连接异常
#define TDS_NORMAL_RETURN_SOCKET_LAN_IP		-1015       //级联模式下必须是同一局域网
#define TDS_NORMAL_RETURN_DOUBLELOGIN		-1016       //重复登陆
#define TDS_NORMAL_RETURN_FAIL_TOOMUCH		-1017       //通行证校验失败次数太多
#define TDS_NORMAL_RETURN_VERSION_UPGREAD	-1018		//版本太低，请更新程序
#define TDS_NORMAL_RETURN_QUERY_TOOMUCH		-1019		//查询请求次数过多，请稍后查询(各类查询请求1分钟限20次调用)
										//!< 日志级别
#define TDS_LOG_LEV_FATAL		0		//!< 用在记录严重异常，即不能恢复的异常（该等级暂时保留）
#define TDS_LOG_LEV_ERROR		1		//!< 用在记录错误信息，即一些严重的错误
#define TDS_LOG_LEV_STATUS		2		//!< 用在记录关键信息，如程序启动信息等
#define TDS_LOG_LEV_WARNING		3		//!< 警告信息，错误但是可以继续,建议级别该打印用TL_WarnEventV接口
#define TDS_LOG_LEV_INFO		4		//!< 一般显示信息，用于查找问题（例如用户登录、登出）
#define TDS_LOG_LEV_DEBUG		5		//!< 程序调试信息，用于开发过程中查找问题（例如用户请求，返回数据）
#define TDS_LOG_LEV_TRACE		6		//!< TRACE 信息，用于查推送类的问题，打印十分频繁（例如推送数据）
#define TDS_LOG_LEV_ELK			7		//!< 启动ELK日志写本地

//TdsEnvSetting结构体m_connectmarket
#define CONNECT_MARKET_SH	"USH"			//上海市场
#define CONNECT_MARKET_SZ	"USZ"			//深圳市场
#define CONNECT_MARKET_SHSZ	"USH;USZ"		//上海和深圳市场

///离线调试函数返回值
#define TDS_OFFLINEDEBUGTYPE_STATE			-101	//离线调试状态不正常
#define TDS_OFFLINEDEBUGTYPE_PARAMETER		-102	//离线调试参数不正常。如playback_times < 1 || push_space < 0 || push_count <= 0
#define TDS_OFFLINEDEBUGTYPE_SOCKET_STATE	-103	//离线调试模式不支持从节点

#define TDS_MSG_CALLBACK_SUBSCRIBE_ASYNC		1           //调用异步订阅请求
#define TDS_MSG_CALLBACK_SUBSCRIBE_RECONNECT	2           //【断线重连成功后 或 断线重连失败后，用户再次登录】，触发之前订阅请求，请求失败返回

//订阅函数返回值
#define TDS_SUBSCRIBE_CODE_ERROR_MARKET			-10001		//市场错误
#define TDS_SUBSCRIBE_CODE_ERROR_NOAUTH			-10002		//市场没有权限
#define TDS_SUBSCRIBE_CODE_ERROR_LIMITSUB		-10003		//订阅受限

#ifndef Int64
	#if defined(_MSC_VER) || defined(__BORLANDC__)
		typedef __int64		Int64;
	#else
		typedef long long	Int64;
	#endif
#endif

#ifndef uInt64
	#if defined(_MSC_VER) || defined(__BORLANDC__)
		typedef unsigned __int64	uInt64;
	#else
		typedef unsigned long long	uInt64;
	#endif
#endif
	
typedef void* THANDLE;

struct TdsTickIndexData;
struct TdsTickStockData;
struct TdsOrderQueueData;
struct TdsOrderData;
struct TdsTransactionData;
struct TdsOptionTick;
struct TdsSuperStockData;
struct TdsStats;
struct TdsMsgNotify;

// 订阅指数快照数据的回调函数
// @param  phandler -- 句柄
// @param  ptickindex -- 指数快照的指针
// @param  count -- ptickindex指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int (*TdsCallBackTickIndex)(THANDLE phandler, TdsTickIndexData* ptickindex, int count, TdsStats* pstats);
	
// 订阅股票快照数据的回调函数
// @param  phandler -- 句柄
// @param  ptickstock -- 股票快照的指针
// @param  count -- ptickstock指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackTickStock)(THANDLE phandler, TdsTickStockData* ptickstock, int count, TdsStats* pstats);
	
// 订阅股票委托队列的回调函数
// @param  phandler -- 句柄
// @param  porderqueue -- 委托队列的指针
// @param  count -- porderqueue指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackOrederQueue)(THANDLE phandler, TdsOrderQueueData* porderqueue, int count, TdsStats* pstats);
	
// 订阅逐笔委托的回调函数
// @param  phandler -- 句柄
// @param  porderdata -- 逐笔委托的指针
// @param  count -- porderdata指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackOrderData)(THANDLE phandler, TdsOrderData* porderdata, int count, TdsStats* pstats);
	
// 订阅逐笔成交的回调函数
// @param  phandler -- 句柄
// @param  ptransaction -- 逐笔成交的指针
// @param  count -- ptransaction指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackTransaction)(THANDLE phandler, TdsTransactionData* ptransaction, int count, TdsStats* pstats);

// 订阅超级盘口的回调函数
// @param  phandler -- 句柄
// @param  psuperstock -- 超级盘口的指针
// @param  count -- porderdata指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackSuperStockData)(THANDLE phandler, TdsSuperStockData* psuperstock, int count, TdsStats* pstats);

// 订阅个股期权的回调函数
// @param  phandler -- 句柄
// @param  poption -- 逐笔成交的指针
// @param  count -- poption指向对象数组的个数
// @param  pstats -- pstats指向时间统计结构体
// @return int -- 处理成功返回0，否则返回<0
typedef int(*TdsCallBackOption)(THANDLE phandler, TdsOptionTick* poption, int count, TdsStats* pstats);

typedef int (*TdsCallBackNotify)(THANDLE phandler, TdsMsgNotify* pNotify);

//callbacktype 详看 TDS_MSG_CALLBACK_SUBSCRIBE_*
typedef int (*TdsCallBackSubScribe)(int dataclass, int suboptype, const char* market, const char* codelist, int statuscode, int callbacktype);

struct TdsEnvSetting
{
	char m_version[20];						 //版本
	char m_logpath[200];					 //日志路径
	char m_connectmarket[20];				 //连接市场
	int m_loglevel;							 //日志级别
	int m_timeout;							 //同步请求的超时时间，单位毫秒
	int m_connectsubscribe;					 //断线重新登录成功后，是否将订阅信息同步
	int m_authtype;							 

	TdsCallBackTickIndex fnctickindex;		 //指数快照回调函数
	TdsCallBackTickStock fnctickstock;		 //证券股票回调函数
	TdsCallBackNotify fncnotify;			 //回调通知（断线重连等）
	TdsCallBackTransaction fnctransacton;	 //逐笔成交回调函数
	TdsCallBackOrderData fncorderdata;		 //逐笔委托回调函数	
	TdsCallBackOrederQueue fncorderqueue;	 //买卖队列回调函数
	TdsCallBackOption fncoption;			 //个股期权回调函数
	TdsCallBackSuperStockData fncsuperstock; //超级盘口回调函数	
	TdsCallBackSubScribe fncSubScribe;

	TdsEnvSetting()
	{
		memset(m_version,0,sizeof(m_version));
		strncpy(m_version,TDS_VERSION,sizeof(m_version));
		memset(m_logpath,0,sizeof(m_logpath));
		memset(m_connectmarket, 0, sizeof(m_connectmarket));
		strncpy(m_connectmarket, CONNECT_MARKET_SHSZ, sizeof(m_connectmarket));
		m_loglevel = TDS_LOG_LEV_WARNING;
		m_timeout = 5000;
		m_connectsubscribe = 0;
		m_authtype = 0;

		fnctickindex = 0;
		fnctickstock = 0;
		fncnotify = 0;
		fnctransacton = 0;
		fncorderdata = 0;
		fncorderqueue = 0;
		fncoption = 0;
		fncsuperstock = 0;
		fncSubScribe = 0;
	}
};

struct TdsCodeInfoData
{
	char market[5];				//市场
	char code[16];				//代码
	char name[20];				//中文名称
	char enname[20];			//英文名称
	int ipodate;				//上市日期
	char currency[4];			//币种，CNY = 人民币, USD = 美元， HKD = 港币， GBP = 英镑
};

struct TdsLoginMsg
{
	int statuscode;			//错误码
	char statusmsg[70];		//输出对应文字信息
	char expire_date[70];	//到期日期
};

struct TdsOfflineDebug
{
	char path[260];		//数据路径,填写绝对路径如：D:\\datafeed\\。默认路径与动态库同级
	char subtype[100];	//"stock,index,order,orderqueue,trans,superstock"
	int	push_space;			//回放推送间隔（ms）
	int push_count;			//回放推送条数
	int playback_times;		//回访遍历次数
	TdsOfflineDebug()
	{
		memset(path, 0, sizeof(path));
		memset(subtype, 0, sizeof(subtype));
		push_space = 3000;		//推送间隔3000ms
		push_count = 200;		//每次推送数组长度200
		playback_times = 1;		//遍历一次
	}
};
	
struct TdsStats
{
	uInt64 produce_time;		//数据产生时间，unix时间戳*1000000+微秒
	uInt64 send_time;			//上级发送时间，unix时间戳*1000000+微秒
	uInt64 recv_time;           //API接收时间，unix时间戳*1000000+毫秒
};

struct TdsMsgNotify
{
	int	 code;					//问题原因，查看TDS_MSG_NOTIFY_DISCONNECT
	char msg[50];				//问题描述
};

struct TdsTickIndexData
{
	char market[5];				//市场
	char code[16];				//代码
	char codename[20];			//代码名字
	char status[20];			//当前状态，比如集合竞价、休市等
	int date;					//YYYYMMDD 行情发生的日期
	int time;					//HHMMSSsss
	double pre_price;           //昨收价
	double open_price;			//开盘价
	double high_price;			//最高价
	double low_price;			//最低价
	double new_price;			//最新价
	Int64 volume;				//成交量
	double turnover;			//成交金额
	Int64 trade_num;			//成交笔数
};

struct TdsTickStockData
{
	char market[5];				//市场
	char code[16];				//代码
	char codename[20];			//代码名字
	char status[20];			//当前状态，比如集合竞价、休市等
	int date;					//YYYYMMDD 行情发生的日期
	int time;					//HHMMSSsss
	double pre_price;           //昨收价
	double open_price;			//开盘价
	double high_price;			//最高价
	double low_price;			//最低价	
	double new_price;			//最新价
	Int64 volume;				//成交量 股票：股； 权证：份； 债券：手
	double turnover;			//成交金额
	Int64 trade_num;			//成交笔数
	double bidorder_price[10];	//申买价，从买一到买十
	Int64 bidorder_volume[10];	//申买量，从买一到买十
	Int64 bid_numorders[10];  	//委托笔数，从买一到买十
	double askorder_price[10];	//申卖价，从卖一到卖十
	Int64 askorder_volume[10];	//申卖量，从卖一到卖十
	Int64 ask_numorders[10];	//委托笔数，从卖一到卖十
	Int64 totalbid_volume;		//总委买量
	Int64 totalask_volume;		//总委卖量
	double avgbid_price;		//加权平均委买价
	double avgask_price;		//加权平均委卖价
	double uplimit_price;		//涨停价
	double downlimit_price;		//跌停价
	double pe;					//市盈率
	double iopv;				//上交所深交所LOF动态净值、深交所LOF动态净值
	int withdraw_buynum;		//买入撤单笔数
	Int64 withdraw_buyvolume;	//买入撤单数量
	double withdraw_buyturnover;//买入撤单金额
	int withdraw_sellnum;		//卖出撤单笔数
	Int64 withdraw_sellvol;		//卖出撤单量
	double withdraw_sellturnover;	//卖出撤单金额
	int totalbid_num;			//买入总笔数
	int totalask_num;			//卖出总笔数
	int bidorder_num;			//买方委托价位数
	int askorder_num ;			//卖方委托价位数
	Int64 inner_volume;			//内盘成交量
	Int64 outer_volume;			//外盘成交量
	Int64 aftermarket_volume;	//盘后成交量
	int aftermarket_volmount;	//盘后成交次数
	Int64 matching_volume;		//匹配成交量
	double matching_turnover;	//匹配成交金额
	double matching_price;		//匹配成交价
	int deal_mode;				//成交方式
	char mode_state[20];		//各交易方式状态
	Int64 etf_buy_num;			//etf申购笔数
	Int64 etf_buy_amount;		//etf申购数量
	Int64 etf_sell_num;			//etf赎回笔数
	Int64 etf_sell_amount;		//etf赎回数量
};

struct TdsOrderQueueData
{
	char market[5];				//市场
	char code[16];				//代码
	int date;					//YYYYMMDD 行情发生的日期
	int time;					//HHMMSSsss
	char side[2];				//买卖方向，B代表买、S代表卖
	double price;				//最优买入价或者卖出价
	int order_number;			//委托单笔数
	int show_number;			//揭示笔数
	int volume[50];				//委托单明细，volme的个数为show_number的值
};
	
struct TdsOrderData
{
	char market[5];				//市场
	char code[16];				//代码
	int date;					//YYYYMMDD 委托发生的日期
	int time;					//HHMMSSsss
	int index;					//委托序号-订单号
	int Bizindex;				//业务序号
	int order_index;			//委托序号
	int channel;				//通道号
	double price;				//委托价格
	int volume;					//委托量
	char side[2];				//1=买，2=卖，G=借入，F=借出
	char type[2];				//订单类别，1=市价，2=限价，U=本方最优
	int deal_mode;				//成交方式
};

struct TdsSuperStockData
{
	char market[5];				//市场
	char code[16];				//代码
	int date;					//YYYYMMDD 委托发生的日期
	int time;					//HHMMSSsss
	double new_price;			//最新价
	double bidorder_price[10];	//申买价，从买一到买十
	Int64 bidorder_volume[10];	//申买量，从买一到买十
	double askorder_price[10];	//申卖价，从卖一到卖十
	Int64 askorder_volume[10];	//申卖量，从卖一到卖十
};

struct TdsTransactionData
{
	char market[5];				//市场
	char code[16];				//代码
	int date;					//YYYYMMDD 成交的日期
	int time;					//HHMMSSsss
	int index;					//成交序号
	int Bizindex;				//业务序号
	int channel;				//通道号
	double price;				//成交价格
	int volume;					//成交量
	int buy_index;				//买方订单号
	int sell_index;				//卖方订单号
	char type[2];				//成交类型,F=成交，C=撤单
	char bsflag[2];				//买卖标志,B-外盘,主动买,；S-内盘,主动卖,；N-未知	
	int deal_mode;				//成交方式
};

struct TdsOptionTick
{
	char market[5];						//市场
	char code[16];						//代码
	char codename[30];					//代码名字
	char status[20];					//当前状态，比如集合竞价、休市等
	int date;							//YYYYMMDD 行情发生的日期
	int time;							//HHMMSSsss
	double pre_settlprice;				//昨结价
	double	settlprice;					//今结价
	double open_price;					//开盘价
	double high_price;					//最高价
	double low_price;					//最低价	
	double new_price;					//最新价
	double pre_price;					//昨收价
	double auction_price;				//波动性中断参考价格
	int	auction_qty;					//波动性中断集合竞价虚拟匹配量
	int 	pre_totallongposition;		//昨持仓量
	int	total_longposition;				//持仓量
	double bidorder_price[5];			//申买价，从买一到买五
	int bidorder_volume[5];				//申买量，从买一到买五
	double askorder_price[5];			//申卖价，从卖一到卖五
	int askorder_volume[5];				//申卖量，从卖一到卖五
	Int64 volume;						//成交量 股票：股； 权证：份； 债券：手
	double turnover;					//成交金额	
};

#pragma pack(pop)

#endif
