#ifndef __TDS_API_H__
#define __TDS_API_H__

#include "tds_struct.h"

#if defined(WIN32) || defined(WIN64) || defined(_WINDOWS)
#ifdef TDS_API_EXPORT
#define TDSAPI __declspec(dllexport) 
#else	
#define TDSAPI __declspec(dllimport)
#endif
#else
#define TDSAPI
#endif

#ifdef __cplusplus
extern "C" {
#endif

// ʵĲͨʵ
// @param  penv -- 
// @return THANDLE -- ɹʧܷ0
TDSAPI THANDLE TdsCreateInstance(const TdsEnvSetting* penv);

// ͷʵ
// @param  phandler -- 
// @return int -- ɹ0ʧܷ < 0
TDSAPI int TdsReleaseInstance(THANDLE phandler);

// ͷڴ,ͬӿڻõָͨ˺ֶͷ
// @param pdata -- Ҫͷŵָ
// @return int -- ɹ0ʧܷ<0
TDSAPI int TdsFreeMem(void *pdata);

// עӵipͶ˿
// @param  phandler -- 
// @param  pmarket -- Ĭдmaster
// @param  paddr -- ipַ
// @param  port -- ˿
// @return int -- ɹ0ʧܷ < 0
TDSAPI int TdsRegisterAddr(THANDLE phandler, const char* pmarket, const char* paddr, unsigned short port);
	
// û¼
// @param  phandler -- 
// @param  pusername -- ˻
// @param  ppasswd -- 
// @return TdsLoginMsg.statuscode -- >=0ʾɹʧܷ < 0
TDSAPI TdsLoginMsg* TdsLogin(THANDLE phandler, const char* pusername, const char* ppasswd);
	
// ȡͬ
// @param  phandler -- 
// @param  pmarket -- гUSHAUSZAȣг˵
// @param  ncodelength* [out] -- ַ
// @return char* [out] -- ɹӦַ׵ַʧܷNULL
TDSAPI char* TdsGetCodelist(THANDLE phandler, const char* pmarket, int* ncodelength);
	
// ȡϢͬ
// @param  phandler -- 
// @param  pmarket -- гUSHAUSZAȣг˵
// @param  pcode -- 룬marketĴ
// @param  codeinfo[out] -- صĴϢ
// @return int -- ɹ0ʧܷ < 0
TDSAPI int TdsGetCodeInfo(THANDLE phandler, const char* pmarket, const char* pcode, TdsCodeInfoData* codeinfo);
	
// ȡָtickݣͬ
// @param  phandler -- 
// @param  pmarket -- гUSHAUSZAȣг˵
// @param  pcodelist -- marketĴ
// @param  ntickcount[out] -- ص
// @return TickIndexData*[out] -- صָṹ׵ַָ
TDSAPI TdsTickIndexData* TdsGetTickIndex(THANDLE phandler, const char* pmarket, const char* pcodelist, int* ntickcount);
	
// ȡ֤ȯtickݣͬ
// @param  phandler -- 
// @param  pmarket -- гUSHAUSZAȣг˵
// @param  pcodelist -- marketĴ
// @param  ntickcount[out] -- ص
// @return TickStockData*[out] -- ص֤ȯṹ׵ַָ
TDSAPI TdsTickStockData* TdsGetTickStock(THANDLE phandler, const char* pmarket, const char* pcodelist, int* ntickcount);

// ȡ̿tickݣͬ
// @param  phandler -- 
// @param  pmarket -- гUSHAUSZAȣг˵
// @param  pcodelist -- marketĴ
// @param  ntickcount[out] -- ص
// @return TdsSuperStockData*[out] -- ص֤ȯṹ׵ַָ
TDSAPI TdsSuperStockData* TdsGetSuperStock(THANDLE phandler, const char* pmarket, const char* pcodelist, int* ntickcount);
	
// Ĵtickݣͬ,첽
// @param  phandler -- 
// @param  msg_dataclass -- 
// @param  subop_type -- Ĳ
// @param  market -- гUSHAUSZAȣг˵
// @param  codelist -- marketĴ
// @return int -- ɹ0ʧܷ < 0
TDSAPI int TdsSubScribe(THANDLE phandler, int msg_dataclass, int subop_type, const char* market, const char* codelist);

// Ĵtickݣ첽
// @param  phandler -- 
// @param  msg_dataclass -- 
// @param  subop_type -- Ĳ
// @param  market -- гUSHAUSZAȣг˵
// @param  codelist -- marketĴ
// @return int -- ɹ0,ʾɣǷɹȴTdsCallBackSubScribeصʧܷ < 0
TDSAPI int TdsSubScribeAsync(THANDLE phandler, int msg_dataclass, int subop_type, const char* market, const char* codelist);

//ߵģʽ
// @param  phandler -- 
// @param  Offlinne -- ߵԽṹ壬tds_struct.h
TDSAPI int TdsStartOfflineDebug(THANDLE phandler, TdsOfflineDebug Offlinne);


#ifdef __cplusplus
}
#endif

#endif
