
//et页面绘制
var height = $(window).height() - 80;
$(".table-scroll").height(height);

$(window).resize(function () {
    var screenWidth = ($(window).width()) * 0.7;//获得当前网页可视宽度
    document.getElementsByClassName("chat01").height = height;
})

var CUSTID = '';
var MOBILE = '';
var MAC = '';

var activeNewsObj = {
    activeType: '',
    activeNewsList: []
};

var msgTypeImg = new Map();
msgTypeImg['NS'] = { name: '新股提醒', image: 'new.png', logintip: '新股消息不错过', code:'100002'};
msgTypeImg['TA'] = { name: '交易提醒', image: 'jiao.png', logintip: '交易进展时刻提醒', code:'100003'};
msgTypeImg['AM'] = { name: '账户提醒', image: 'zhang.png', logintip: '时刻了解账户变动', code:'100004'};
msgTypeImg['NN'] = { name: '资讯提醒', image: 'zi.png', logintip: '优质资讯尽在掌握', code:'100001'};
msgTypeImg['FS'] = { name: '理财提醒', image: 'li.png', logintip: '理财提醒更贴心', code:'100005'};
msgTypeImg['SV'] = { name: '服务提醒', image: 'fu.png', logintip: '服务相关提醒不错过', code:'100006'};
msgTypeImg['SN'] = { name: '系统提醒', image: 'setting.png', logintip: '系统消息随时收', code:'100007'};
msgTypeImg['xtgsType'] = { name: '系统提醒', image: 'setting.png', logintip: '系统消息随时收', code:'xtgsType'};
msgTypeImg['xtszType'] = { name: '系统提醒', image: 'setting.png', logintip: '系统消息随时收' , code:'xtszType'};


//解析url里面的参数
function GetRequest() {
    var url = location.search; //获取url中"?"符后的字串
    var theRequest = new Object();
    if (url.indexOf("?") != -1) {
        var str = url.substr(1);
        if (str.indexOf('&') != -1) {
            var strs = str.split('&');
            for (var i = 0; i < strs.length; i++) {
                theRequest[strs[i].split("=")[0]] = (strs[i].split("=")[1]);
            }
        } else {
            theRequest[str.split("=")[0]] = (str.split("=")[1]);
        }
    }
    return theRequest;
}
var urlParam = GetRequest();


// 解密函数title、content
function decode_title_content(str) {
    if (str != '' && str != undefined && str != null) {
        str = str.replace(/[\r\n]/g, "");
        str = str.replace(/\s/g, "=");
        str = decode64(str);
    } else {
        str = '';
    }
    return str;
}

//消息中心时间格式处理
function xxzxTime(t, type) {
    if (type == 'day') {
        return t.substr(0, 4) + '-' + t.substr(4, 2) + '-' + t.substr(6, 2);
    } else if (type == 'second') {
        return t.substr(8, 2) + ':' + t.substr(10, 2) + ':' + t.substr(12, 2);
    } else if (type == 'minute') {
        return t.substr(8, 2) + ':' + t.substr(10, 2);
    } else if (type == 'all') {
        return t.substr(0, 4) + '-' + t.substr(4, 2) + '-' + t.substr(6, 2) + ' ' + t.substr(8, 2) + ':' + t.substr(10, 2);// + ':' + t.substr(12, 2);
    } else if (type == 'et') {
        return t.substr(0, 8) + ' ' + t.substr(8, 2) + ':' + t.substr(10, 2);
    }
}

exports.getUserInfo().then(function (userInfo) {
    var userInfo = userInfo.list[userInfo.USERCOUNT];
    var loginFlag = (userInfo.USER_CUSTID == '') ? false : true;
    var kfjid = '';
    var kfDefault = ['<div class="xyr-data"><p class="xyr-via"><img src="../infocenter/et/images/kehu_duihuakuang.png" id="xyr-via"/></p>',
        '<p class="firstSpan"><span class="left-zl">姓名：</span><span class="right-zl xyr-name">暂无数据</span></p>',
        '<p class="firstSpan"><span class="left-zl">工号：</span><span class="right-zl xyr-ehrid">' + kfjid + '</span></p>',
        '<p class="firstSpan"><span class="left-zl">证书编号：</span><span class="right-zl xyr-cretno">暂无数据</span></p>',
        '<p class="firstSpan"><span class="left-zl">联系电话：</span><span class="right-zl xyr-phone">95521</span></p>',
        '<p class="firstSpan"><span class="left-zl">营业部：</span><span class="right-zl xyr-yyb">暂无数据</span></p>',
        '<p class="lastSpan">国泰君安综合金融服务，为您提供专业的资产配置方案</p></div>'
    ].join("");
    if (loginFlag) {
        exports.uc['客户响应人查询']({
            CUST_CODE: '03' + ('000000000000000000000' + userInfo.USER_CUSTID).substr(-12)
        }).then(function (res) {
            if (res.RNUM > 0) {
                var xyr = res.list[0];
                var userHead = xyr.USER_HEAD;
                var slogans = xyr.SERVICE_SLOGANS;
                userHead = (userHead == '') ? '../infocenter/et/images/kehu_duihuakuang.png' : 'http://dl.app.gtja.com/baishitong' + userHead;
                var kf = ['<div class="xyr-data"><p class="xyr-via"><img src="' + userHead + '" id="xyr-via"/></p>',
                '<p class="firstSpan"><span class="left-zl">姓名：</span><span class="right-zl xyr-name">' + xyr.EHR_NAME + '</span></p>',
                '<p class="firstSpan"><span class="left-zl">工号：</span><span class="right-zl xyr-ehrid">' + xyr.EHR_ID + '</span></p>',
                '<p class="firstSpan"><span class="left-zl">证书编号：</span><span class="right-zl xyr-cretno">' + xyr.PREFESSION_CERT_NO + '</span></p>',
                    '<p class="firstSpan"><span class="left-zl">联系电话：</span><span class="right-zl xyr-phone">95521</span></p>',
                '<p class="firstSpan"><span class="left-zl">营业部：</span><span class="right-zl xyr-yyb">' + xyr.BRANCH_NAME + '</span></p>',
                '<p class="lastSpan">' + slogans + '</p></div>'
                ].join("");

            }
            gtjawebEtUI.getkhjlshowLayoutTemplate = function (kfjid, domEl) {
                var kfjid = kfjid.substr(0, 6);
                if (kfjid == res.list[0].EHR_ID) {
                    domEl.append($(kf));
                } else {
                    domEl.append($(kfDefault));
                }

            }
        }, function (err) {
            gtjawebEtUI.getkhjlshowLayoutTemplate = function (kfjid, domEl) {
                var kfjid = kfjid.substr(0, 6);
                domEl.append($(kfDefault));
            }
        });
    } else {
        gtjawebEtUI.getkhjlshowLayoutTemplate = function (kfjid, domEl) {
            var kfjid = kfjid.substr(0, 6);
            domEl.append($(kfDefault));
        }
    }
}, function (err) {
    $(".lx-come").append('获取客户信息失败2：' + err);
})

//本地收藏消息
function storeMsg(obj,msgid){
    var obj = $(obj);
    var tip = obj.prev();
    if(obj.hasClass("msg-collect")){
        exports.SetStoring(msgid).then(function(res){
            obj.removeClass("msg-collect").addClass("msg-cancel-collect");
            tip.html('收藏成功').css("display","block");
            setTimeout(function(){
                tip.css("display","none");
            },2000);
        });
    }else if(obj.hasClass("msg-cancel-collect")){
        exports.CancelCollect(msgid).then(function(res){
            obj.removeClass("msg-cancel-collect").addClass("msg-collect");
            tip.html('已取消收藏').css("display","block");
            setTimeout(function(){
                tip.css("display","none");
            },2000);
            setTimeout(function(){
                $activeLi = $(".xtszType .msg-list-item-active");
                if($activeLi.length != 0){
                    if(obj.closest("li").hasClass("msg-list-item-active")){
                        $nextLi = obj.closest("li").next("li");
                        if($nextLi.length != 0){
                            $nextLi.addClass("msg-list-item-active");
                            var nextMsgid = $nextLi.attr("data-msgid");
                            readMsg(nextMsgid, $(".active-msg"), 2);
                        }else{
                            $prevLi = obj.closest("li").prev("li");
                            if($prevLi.length != 0){
                                $prevLi.addClass("msg-list-item-active");
                                var nextMsgid = $prevLi.attr("data-msgid");
                                readMsg(nextMsgid, $(".active-msg"), 2);                          
                            }else{
                                $(".xxzxTypeContent").html("");
                                var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">暂无消息</span></div>';
                                $(".xxzxTypeContent").append(htmlStr);
                            }
                        }                        
                    }
                    obj.closest("li").remove(); 
                                       
                }

            }, 2500);
        });              
    }
    event.cancelBubble=true;
}


//设置消息已读,私有消息需要另外调用户中心接口
function setRead(msgid, ispublic) {
    exports.SetReading(msgid);
    if (ispublic == '0') {
        exports.getUserInfo().then(function (userinfo) {
            var userInfo = userinfo.list[userinfo.USERCOUNT];
            var requestSetRead = {
                acctType: 'cu',
                acctId: userInfo.USER_CUSTID,
                acctToken: '',
                msgId: [msgid],
                setStatus: '1',
                channelId: 'pc'
            }
            exports.uc['更新消息发送表']({
                inparam: JSON.stringify(requestSetRead)
            }).then(function (res) {

            });
        });

    }
}

//消息TAB展示某条消息
function readMsg(msgid, container, orign) {
    // if(orign == 2){
    //     $(".deletSC").remove();
    //     container.append("<div class='deletSC'><a href='###' class='cancel-collect'>取消收藏</a></div>");        
    // }
    exports.GetSingleData(msgid).then(function (res) {
        if (res.RNUM > 0) {
            var info = '';

            for (var i = 0; i < res.list.length; i++) {
                info = res.list[i];
                if (info.isread == '0') { break; }
            }

            if (info.isread == '0') {
                setRead(info.msgid, info.ispublic);
                var msgType = msgTypeImg[info.busid].code;
                var msgTypeTab = $("#change_ul li[itemjid="+msgType+"]").find(".chat_msgtip");
                var xtTypeTab = $("#change_ul li[itemjid=xtgsType]").find(".chat_msgtip");
                var newMsgNum = msgTypeTab.text();
                var totalNewNum = xtTypeTab.text();

                if (newMsgNum == '1') {
                    msgTypeTab.text(newMsgNum - 1);
                    msgTypeTab.css("display", "none");
                } else {
                    msgTypeTab.text(newMsgNum - 1);
                }
                if (totalNewNum == '1') {
                    xtTypeTab.text(totalNewNum - 1);
                    xtTypeTab.css("display", "none");
                } else {
                    xtTypeTab.text(totalNewNum - 1);
                }
            }

            var msgType = info.msgtype;
            var msgTitle = info.msgtitle;
            var msgCon = info.msgcontent;
            var msgTime = info.TopicTime;
            var msgAbstract = info.msgsummary;
            var msgTopicid = info.topicid;
            var fy_version = 'v2.2.8'; // 富易版本号
            var hrefUrl = '';
            msgTitle = decode_title_content(msgTitle);
            msgCon = decode_title_content(msgCon);
            msgAbstract = decode_title_content(msgAbstract);
            //TopicTime处理
            msgTime = msgTime.substr(0, 4) + '-' + msgTime.substr(4, 2) + '-' + msgTime.substr(6, 2) + ' ' + msgTime.substr(8, 2) + ':' + msgTime.substr(10, 2) + ':' + msgTime.substr(12, 2);

            // =============增加策略消息内容 start======================
            var topicId = info.topicid;
            function CLMonitorType(BSFLAG) {
                switch (BSFLAG) {
                    case "0": return "挂单买入";
                        break;
                    case "1": return "挂单卖出";
                        break;
                    case "2": return "止盈止损";
                        break;
                    case "3": return "反弹买入";
                        break;
                    case "4": return "回落卖出";
                        break;
                }
            }
            if (msgType == "text" || msgType == "TEXT" || msgType == "HTML") {

                $('.jsontype-box').remove('');
                $('.htmltype-box').remove('');
                $('.code-box').remove('');
                $('.collect').remove();

                // 对topicid=33的消息的处理
                var html_text_str = ''; // type为text、html类型
                var time_font = '<div class="collect-scale"><p class="time">' + msgTime + '</p><p class="right-p"><span class="scale">字号:<a href="###">大</a><a href="###">中</a><a href="###">小</a></span></p></div>';
                var tricase = '';
                if (topicId == '33') {
                    var con = JSON.parse(msgCon);
                    var data = JSON.parse(con.DATA);
                    var MSG_TYPE = con.MSG_TYPE;
                    var strategyId = data.STRATEGY_ID;
                    var strategyType = data.STRATEGY_TYPE;
                    var fundId = data.CUACCT_CODE;
                    var stockCode = data.TRADE_STOCK_CODE;
                    var stockName = data.TRADE_STOCK_NAME;
                    var traderAccount = data.TRDACCT;
                    var stockPrice = data.ORDER_PRICE;
                    var credit_Flag = data.CREDIT_TYPE;
                    var stockQty = data.ORDER_QTY;
                    var market = data.MARKET;
                    var CFTime = data.TIGGER_TIME;
                    var AutoOlder = data.AUTO_ORDER_FLAG;
                    var remark = data.REMARK;
                    var traderNo = data.STTRADE_NO;
                    // 触发条件
                    if (con.MONITOR_LIST) {
                        var monitorList = JSON.parse(con.MONITOR_LIST);
                        for (var i = 0; i < monitorList.length; i++) {
                            var udtype = monitorList[i].UP_DOWN_TYPE;
                            var moniprice = monitorList[i].MONITOR_PRICE;
                            var diftype = monitorList[i].DIFF_TYPE;
                            var difvalue = monitorList[i].DIFF_VALUE;
                            if (strategyType == '2') {
                                if (udtype == '2') {
                                    tricase = '触发条件：股价>=' + moniprice + '止盈<br>';
                                } else if (udtype == '3') {
                                    tricase = '触发条件：股价<=' + moniprice + '止损。<br>';
                                }
                            } else {
                                if (udtype == '2') {
                                    tricase = '触发条件：股价向上突破' + moniprice + '<br>';
                                } else if (udtype == '3') {
                                    tricase = '触发条件：股价向下突破' + moniprice + '<br>';
                                } else if (udtype == '5') {
                                    tricase = '触发条件：股价跌破' + moniprice + '后，从最低价反弹超' + difvalue + '%<br>';
                                } else if (udtype == '6') {
                                    tricase = '触发条件：股价突破' + moniprice + '后，从最高价回落超' + difvalue + '%<br>';
                                }
                            }
                        }
                    } else {
                        tricase = '';
                    }
                    if (MSG_TYPE == 'CF') {
                        html_text_str = '<div class="htmltype-box">' +
                            '<h3 class="htmltype-title">策略触发提醒</h3>' + time_font +
                            '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略已经触发，策略已经失效<br>' +
                            '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                            '委托价格：' + stockPrice + '<br>' +
                            '委托数量：' + stockQty + '<br>' +
                            '触发时间：' + CFTime + '</div>' +
                            // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                            '</div>';
                    } else if (MSG_TYPE == 'WTSB') {
                        html_text_str = '<div class="htmltype-box">' +
                            '<h3 class="htmltype-title">策略埋单失败提醒</h3>' + time_font +
                            '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略委托失败，策略已经失效<br>' +
                            '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                            '委托价格：' + stockPrice + '<br>' +
                            '委托数量：' + stockQty + '<br>' +
                            '失败原因：' + remark + '</div>' +
                            // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                            '</div>';
                    } else if (MSG_TYPE == 'CLSX') {
                        html_text_str = '<div class="htmltype-box">' +
                            '<h3 class="htmltype-title">策略执行失败提醒</h3>' + time_font +
                            '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略埋单失败，策略已经失效<br>' +
                            '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                            '委托价格：' + stockPrice + '<br>' +
                            '委托数量：' + stockQty + '<br>' +
                            '失败原因：' + remark + '</div>' +
                            // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                            '</div>';
                    } else if (MSG_TYPE == 'WTCG') {
                        html_text_str = '<div class="htmltype-box">' +
                            '<h3 class="htmltype-title">自动委托成功</h3>' + time_font +
                            '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略埋点委托成功<br>' +
                            '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                            '委托价格：' + stockPrice + '<br>' +
                            '委托数量：' + stockQty + 
                            '</div>' + 
                            '<p class="entrust-btn"><a href="http://www.treeid/GTJAJY_COMM=COMM_SUBFUNC|TYPE=TFyZq|EVENT=DRCX_DRWT_Click">委托查询</a></p>' +
                            '</div>';
                            msgTitle = "策略交易埋单委托成功提醒";
                    }
                } else {
                    html_text_str = '<div class="htmltype-box">' +
                        '<h3 class="htmltype-title">' + msgTitle + '</h3>' + time_font +
                        '<div class="htmltype-text">' + msgCon + '</div>' +
                        '</div>';
                }
                container.append(html_text_str);
            } else if (msgType == "URL") {

                $('.jsontype-box').remove('');
                $('.htmltype-box').remove('');
                $('.code-box').remove('');
                $('.collect').remove();

                container.append('<div class="jsontype-box"></div>');
                hrefUrl = msgCon;
                //新版富易升星提醒消息不影响旧版特殊处理
                if(hrefUrl.indexOf('fyapp') != -1){
                    var path = window.location.href;
                    var pathIndex = path.indexOf('/fyapp');
                    var pathStr = path.substr(0,pathIndex);
                    hrefUrl = pathStr+hrefUrl;
                }
            } else if (msgType == "JSON") {


                $('.jsontype-box').remove('');
                $('.htmltype-box').remove('');
                $('.code-box').remove('');
                $('.collect').remove();

                container.append('<div class="jsontype-box"></div>');
                if (msgCon.indexOf('https') != -1) {
                    hrefUrl = 'https://apicdn.app.gtja.com/public/fy/fyinfo/index.html?url=' + msgCon + '&vs=' + fy_version + '&ty=fy'
                } else if (msgCon.indexOf('http') != -1) {
                    hrefUrl = 'http://apicdn.app.gtja.com/public/fy/fyinfo/index.html?url=' + msgCon + '&vs=' + fy_version + '&ty=fy'
                }
            }

            $('.jsontype-box').append('<iframe class="iframe-box" src="' + hrefUrl + '"></iframe>');

            $('.back-collect').append('<a href="###" class="collect">收藏</a>');
            // 点击收藏(没有使用)
            $('.collect').on('click', function () {
                $('.collect').css('background', 'url("./imgs/cancel_collect.png") no-repeat left center');

                var msg = [{
                    msgID: msgid,
                    msgTitle: msgTitle,
                    msgTime: xxzxTime(info.TopicTime, 'et'),
                    msgSummary: ''
                }]
 
                gtjaWebEtLoginApi.addXXZXTypeListSC(msg);

                exports.getUserInfo().then(function (userinfo) {
                    var userInfo = userinfo.list[userinfo.USERCOUNT];
                    var requestSetRead = {
                        acctType: 'cu',
                        acctId: userInfo.USER_CUSTID,
                        acctToken: '',
                        msgId: [msgid],
                        setStatus: '3',
                        channelId: 'pc'
                    }
                    exports.uc['更新消息发送表']({
                        inparam: JSON.stringify(requestSetRead)
                    }).then(function (res) {
                        if (res.RNUM > 0) {
                            var res = JSON.parse(res.list[0].outparam);
                            if (res.errcode == '0') {

                            } else {
                                $('.collect').css('background', 'url("./imgs/collect.png") no-repeat left center');
                            }
                        }
                    });
                });
            });
            // 点击取消收藏
            $('.cancel-collect').on('click', function () {
                // gtjaWebEtLoginApi.delSCMsg(msgid);

                exports.CancelCollect(msgid).then(function (res) {
                    $('.cancel-collect').css('opacity', '0');
                    $('.deletSC').append('<span class="cancel_ok">取消成功</span>');
                    $('.cancel_ok').show();
                    $('.cancel_ok').animate({opacity:"1", top:'10px'}, 400);
                    $('.cancel_ok').animate({opacity:"0"}, 600);
                    setTimeout(function(){
                        $activeLi = $(".xtszType .msg-list-item-active");
                        $nextLi = $activeLi.next("li");
                        if($nextLi.length != 0){
                            $nextLi.addClass("msg-list-item-active");
                            var nextMsgid = $nextLi.attr("data-msgid");
                            readMsg(nextMsgid, $(".active-msg"), 2)
                        }else{
                            $(".xxzxTypeContent").html("");
                            var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">暂无消息</span></div>';
                            $(".xxzxTypeContent").append(htmlStr);
                        }
                        $activeLi.remove();                        
                    }, 1000)                    
                });

                /*exports.CancelCollect(msgid).then(function (res) {
                    if (res.RNUM > 0) {
                        // =================取消收藏 start===========================
                        var collect_status = res.list[0].msg;
                        if (collect_status == '1') {
                            // 取消收藏成功
                            $('.cancel-collect').css('opacity', '0');
                            $('.deletSC').append('<span class="cancel_ok">取消成功</span>');
                            $('.cancel_ok').show();
                            $('.cancel_ok').animate({opacity:"1", top:'10px'}, 400);
                            $('.cancel_ok').animate({opacity:"0"}, 600);
                        } else {
                            // 取消收藏失败
                            $('.cancel-collect').css('background', 'url("./imgs/cancel_collect.png") no-repeat left center');
                        }     
                        // =================增加取消收藏 end=========================== 
                    }
                });*/
            });
            // 点击变化字体大小
            $('.scale').on('click', 'a', function () {
                var aTxt = $(this).text();
                if (aTxt == '大') {
                    $('.htmltype-text').css('fontSize', '18px');
                } else if (aTxt == '中') {
                    $('.htmltype-text').css('fontSize', '16px');
                } else if (aTxt == '小') {
                    $('.htmltype-text').css('fontSize', '14px');
                }
            });

            //神策埋点
            if(typeof(sensors) != 'undefined'){
                sensor_infocent_open(msgid, msgTitle, msgType, msgAbstract, msgTopicid);
            }            
        }
    }, function (err) {
        container.append("获取消息失败：" + err);
    });
}


//收藏TAB展示具体某条消息
function readSCMsg(msgid, container, orign) {
    $(".deletSC").remove();
    container.append("<div class='deletSC'><a href='###' class='cancel-collect'>取消收藏</a></div>");

    exports.getUserInfo().then(function (userInfo) {
        var userInfo = userInfo.list[userInfo.USERCOUNT];
        var requestScMsg = {
            acctType: 'cu',
            acctId: userInfo.USER_CUSTID,
            acctToken: '',
            msgId: msgid
        }
        exports.uc['收藏消息查看']({
            inparam: JSON.stringify(requestScMsg)
        }).then(function (res) {
            // console.log("UC收藏消息查看："+JSON.stringify(res));
            if (res.RNUM > 0) {
                var info = JSON.parse(res.list[0].outparam);
                var msgType = info.msgFormat;
                var msgTitle = info.title;
                var msgCon = info.template;
                var msgTime = info.pubTime;
                var fy_version = 'v2.2.8'; // 富易版本号
                var hrefUrl = '';
                //TopicTime处理
                msgTime = msgTime.substr(0, 4) + '-' + msgTime.substr(4, 2) + '-' + msgTime.substr(6, 2) + ' ' + msgTime.substr(8, 2) + ':' + msgTime.substr(10, 2) + ':' + msgTime.substr(12, 2);

                // =============增加策略消息内容 start======================
                var topicId = info.topicId;
                function CLMonitorType(BSFLAG) {
                    switch (BSFLAG) {
                        case "0": return "挂单买入";
                            break;
                        case "1": return "挂单卖出";
                            break;
                        case "2": return "止盈止损";
                            break;
                        case "3": return "反弹买入";
                            break;
                        case "4": return "回落卖出";
                            break;
                    }
                }
                if (msgType == "text" || msgType == "TEXT" || msgType == "HTML") {
                    $('.jsontype-box').remove('');
                    $('.htmltype-box').remove('');
                    $('.code-box').remove('');
                    $('.collect').remove();

                    // 对topicid=33的消息的处理
                    var html_text_str = ''; // type为text、html类型
                    var time_font = '<div class="collect-scale"><p class="time">' + msgTime + '</p><p class="right-p"><span class="scale">字号:<a href="###">大</a><a href="###">中</a><a href="###">小</a></span></p></div>';
                    var tricase = '';
                    if (topicId == '33') {
                        var con = JSON.parse(msgCon);
                        var data = JSON.parse(con.DATA);
                        var MSG_TYPE = con.MSG_TYPE;
                        var strategyId = data.STRATEGY_ID;
                        var strategyType = data.STRATEGY_TYPE;
                        var fundId = data.CUACCT_CODE;
                        var stockCode = data.TRADE_STOCK_CODE;
                        var stockName = data.TRADE_STOCK_NAME;
                        var traderAccount = data.TRDACCT;
                        var stockPrice = data.ORDER_PRICE;
                        var credit_Flag = data.CREDIT_TYPE;
                        var stockQty = data.ORDER_QTY;
                        var market = data.MARKET;
                        var CFTime = data.TIGGER_TIME;
                        var AutoOlder = data.AUTO_ORDER_FLAG;
                        var remark = data.REMARK;
                        var traderNo = data.STTRADE_NO;
                        // 触发条件
                        if (con.MONITOR_LIST) {
                            var monitorList = JSON.parse(con.MONITOR_LIST);
                            for (var i = 0; i < monitorList.length; i++) {
                                var udtype = monitorList[i].UP_DOWN_TYPE;
                                var moniprice = monitorList[i].MONITOR_PRICE;
                                var diftype = monitorList[i].DIFF_TYPE;
                                var difvalue = monitorList[i].DIFF_VALUE;
                                if (strategyType == '2') {
                                    if (udtype == '2') {
                                        tricase = '触发条件：股价>=' + moniprice + '止盈<br>';
                                    } else if (udtype == '3') {
                                        tricase = '触发条件：股价<=' + moniprice + '止损。<br>';
                                    }
                                } else {
                                    if (udtype == '2') {
                                        tricase = '触发条件：股价向上突破' + moniprice + '<br>';
                                    } else if (udtype == '3') {
                                        tricase = '触发条件：股价向下突破' + moniprice + '<br>';
                                    } else if (udtype == '5') {
                                        tricase = '触发条件：股价跌破' + moniprice + '后，从最低价反弹超' + difvalue + '%<br>';
                                    } else if (udtype == '6') {
                                        tricase = '触发条件：股价突破' + moniprice + '后，从最高价回落超' + difvalue + '%<br>';
                                    }
                                }
                            }
                        } else {
                            tricase = '';
                        }
                        if (MSG_TYPE == 'CF') {
                            html_text_str = '<div class="htmltype-box">' +
                                '<h3 class="htmltype-title">策略触发提醒</h3>' + time_font +
                                '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略已经触发，策略已经失效<br>' +
                                '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                                '委托价格：' + stockPrice + '<br>' +
                                '委托数量：' + stockQty + '<br>' +
                                '触发时间：' + CFTime + '</div>' +
                                // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                                '</div>';
                        } else if (MSG_TYPE == 'WTSB') {
                            html_text_str = '<div class="htmltype-box">' +
                                '<h3 class="htmltype-title">策略埋单失败提醒</h3>' + time_font +
                                '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略委托失败，策略已经失效<br>' +
                                '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                                '委托价格：' + stockPrice + '<br>' +
                                '委托数量：' + stockQty + '<br>' +
                                '失败原因：' + remark + '</div>' +
                                // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                                '</div>';
                        } else if (MSG_TYPE == 'CLSX') {
                            html_text_str = '<div class="htmltype-box">' +
                                '<h3 class="htmltype-title">策略执行失败提醒</h3>' + time_font +
                                '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略埋单失败，策略已经失效<br>' +
                                '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                                '委托价格：' + stockPrice + '<br>' +
                                '委托数量：' + stockQty + '<br>' +
                                '失败原因：' + remark + '</div>' +
                                // '<p class="entrust-btn"><a href="###">重新埋单</a></p>' +
                                '</div>';
                        } else if (MSG_TYPE == 'WTCG') {
                            html_text_str = '<div class="htmltype-box">' +
                                '<h3 class="htmltype-title">自动委托成功</h3>' + time_font +
                                '<div class="htmltype-text">您的' + strategyId + '号<strong style="color: red;">' + CLMonitorType(strategyType) + '</strong>策略埋点委托成功<br>' +
                                '证券名称：' + stockName + '&nbsp(&nbsp' + stockCode + '&nbsp)<br>' + tricase +
                                '委托价格：' + stockPrice + '<br>' +
                                '委托数量：' + stockQty + '</div>' +
                                '<p class="entrust-btn"><a href="http://www.treeid/GTJAJY_COMM=COMM_SUBFUNC|TYPE=TFyZq|EVENT=DRCX_DRWT_Click">委托查询</a></p>' +
                                '</div>';
                        }
                    } else {
                        html_text_str = '<div class="htmltype-box">' +
                            '<h3 class="htmltype-title">' + msgTitle + '</h3>' + time_font +
                            '<div class="htmltype-text">' + msgCon + '</div>' +
                            '</div>';
                    }
                    container.append(html_text_str);
                } else if (msgType == "URL") {
                    $('.jsontype-box').remove('');
                    $('.htmltype-box').remove('');
                    $('.code-box').remove('');
                    $('.collect').remove();

                    container.append('<div class="jsontype-box"></div>');
                    hrefUrl = msgCon;
                } else if (msgType == "JSON") {
                    $('.jsontype-box').remove('');
                    $('.htmltype-box').remove('');
                    $('.code-box').remove('');
                    $('.collect').remove();

                    container.append('<div class="jsontype-box"></div>');
                    if (msgCon.indexOf('https') != -1) {
                        hrefUrl = 'https://apicdn.app.gtja.com/public/fy/fyinfo/index.html?url=' + msgCon + '&vs=' + fy_version + '&ty=fy'
                    } else if (msgCon.indexOf('http') != -1) {
                        hrefUrl = 'http://apicdn.app.gtja.com/public/fy/fyinfo/index.html?url=' + msgCon + '&vs=' + fy_version + '&ty=fy'
                    }
                }
                $('.jsontype-box').append('<iframe class="iframe-box" src="' + hrefUrl + '"></iframe>');

                $('.back-collect').append('<a href="###" class="collect">收藏</a>');

                // 点击取消收藏
                $('.cancel-collect').on('click', function () {
                    gtjaWebEtLoginApi.delSCMsg(msgid);

                    exports.CancelCollect(msgid).then(function (res) {
                        $('.cancel-collect').css('opacity', '0');
                        $('.deletSC').append('<span class="cancel_ok">取消成功</span>');
                        $('.cancel_ok').show();
                        $('.cancel_ok').animate({opacity:"1", top:'10px'}, 400);
                        $('.cancel_ok').animate({opacity:"0"}, 600);                        
                        if (res.RNUM > 0) {
                            var collect_status = res.list[0].msg;
                            if (collect_status == '1') {
                                // 取消收藏成功
                                $('.cancel-collect').css('opacity', '0');
                                $('.deletSC').append('<span class="cancel_ok">取消成功</span>');
                                $('.cancel_ok').show();
                                $('.cancel_ok').animate({opacity:"1", top:'10px'}, 400);
                                $('.cancel_ok').animate({opacity:"0"}, 600); 
                            } else {
                                // 取消收藏失败
                                $('.cancel-collect').css('background', 'url("./imgs/cancel_collect.png") no-repeat left center');
                            }
                        }
                    });

                });
                // 点击变化字体大小
                $('.scale').on('click', 'a', function () {
                    var aTxt = $(this).text();
                    if (aTxt == '大') {
                        $('.htmltype-text').css('fontSize', '16px');
                    } else if (aTxt == '中') {
                        $('.htmltype-text').css('fontSize', '14px');
                    } else if (aTxt == '小') {
                        $('.htmltype-text').css('fontSize', '12px');
                    }
                })
            }
        }, function (err) {
            container.append('获取收藏消息失败：' + err);
        })
    })
}


//点击查看某条消息
function clickListMsg(obj, orign) {
    var obj = $(obj);
    obj.parent().find(".msg-list-item-active").removeClass("msg-list-item-active");
    obj.addClass("msg-list-item-active");
    if (obj.find(".msg-list-item-name")) {
        obj.find(".msg-list-item-name").removeClass("msg-list-item-name").addClass("msg-list-item-name2");
    }
    var msgid = obj.attr("data-msgid");
    var msgContainer = $(".active-msg");
    msgContainer.html('');
    readMsg(msgid, msgContainer, orign);
    // if(orign == 1){
    //     readMsg(msgid, msgContainer, 'xx');
    // }
    // if(orign == 2){
    //     readSCMsg(msgid, msgContainer, 'xx');
    // }
}



var msgListHtml = function(newsList, orign, type){
    var htmlStr = '';
    
    for(var i=0; i<newsList.length; i++){
        if(newsList[i].isread == '1' || i==0){
            var titleClass = 'msg-list-item-name2';
        }else{
            var titleClass = 'msg-list-item-name';
        }
        htmlStr += '<li class="msg-list-item" onclick="clickListMsg(this,'+orign+')" data-msgid="'+newsList[i].msgid+'"><div class="'+titleClass+'">'
                +newsList[i].msgTitle+'</div><div class="msg-list-item-info"><span class="msg-class">【'
                +newsList[i].msgClass+'】</span><span class="msg-time">'
                +newsList[i].msgTime+'</span></div></li>';
    }
    return htmlStr;
}

//加载更多函数
function loadMoreMsg(type, pos) {
    exports.getUserInfo().then(function (userinfo) {
        var userInfo = userinfo.list[userinfo.USERCOUNT];
        if(type == 'xtgsType'){
            var moreMsgPromise = exports.GetInfocentNewsData(userInfo.USER_CUSTID, pos);
        }else{
            var moreMsgPromise = exports.GetInfocentClassData(userInfo.USER_CUSTID, type, pos);
        }
        moreMsgPromise.then(function(res){
            var newsList = res.list;
            activeNewsObj.activeNewsList = activeNewsList.concat(newsList);

            for(var i=0; i<newsList.length; i++){
                newsList[i].msgTitle = decode_title_content(newsList[i].msgtitle);
                newsList[i].msgTime = xxzxTime(newsList[i].TopicTime, 'all');
                newsList[i].msgCon = decode_title_content(newsList[i].msgcontent);
                newsList[i].msgClass = newsList[i].busname;
                if (newsList[i].topicid == '33') {
                    var con = JSON.parse(newsList[i].msgCon);
                    var MSG_TYPE = con.MSG_TYPE;
                    if (MSG_TYPE == 'WTCG') {
                        newsList[i].msgTitle = '策略交易埋单委托成功提醒';
                    }
                }
            }
            var htmlStr = msgListHtml(newsList, 1, type);
            $("."+type).append(htmlStr);
        })

    })
}


//某类消息全部设置为已读
function setAllRead() {
    // TDAPP.onEvent("消息中心", "全部标记为已读按钮点击");
    var setMsgidList = [];

    var typeCode = msgTypeImg[activeNewsObj.activeType].code;
    var msgTypeTab = $("#change_ul li[itemjid="+typeCode+"]").find(".chat_msgtip");
    var xtTypeTab = $("#change_ul li[itemjid=xtgsType]").find(".chat_msgtip");
    var newMsgNum = msgTypeTab.text();
    var totalNewNum = xtTypeTab.text();

    exports.getUserInfo().then(function(userinfo){
        var userInfo = userinfo.list[userinfo.USERCOUNT];
        if(activeNewsObj.activeType != 'xtgsType'){
            exports.setAllMsgRead(userInfo.USER_CUSTID, activeNewsObj.activeType);
            msgTypeTab.text('0');
            msgTypeTab.css("display", "none"); 
            xtTypeTab.text(totalNewNum - newMsgNum);
            if((totalNewNum - newMsgNum) == 0){
                xtTypeTab.css("display", "none"); 
            }    
        };
        if(activeNewsObj.activeType == 'xtgsType'){
            var typeList = ['NS','TA','AM','NN','FS','SV','SN'];
            typeList.forEach(function(type){
                exports.setAllMsgRead(userInfo.USER_CUSTID, type); 
            });
            $(".chat_msgtip").text('0');
            $(".chat_msgtip").css("display", "none");
        };
        for (var i = 0; i < activeNewsObj.activeNewsList.length; i++) {
            var news = activeNewsObj.activeNewsList[i];
            if (news.isread == '0') {
                // exports.SetReading(news.msgid);
                if (news.ispublic == '0') {
                    setMsgidList.push(news.msgid);
                }
            }
        };
        if (setMsgidList.length > 0) {
            var requestSetRead = {
                acctType: 'cu',
                acctId: userInfo.USER_CUSTID,
                acctToken: '',
                msgId: setMsgidList,
                setStatus: '1',
                channelId: 'pc'
            }
            exports.uc['更新消息发送表']({
                inparam: JSON.stringify(requestSetRead)
            }).then(function (res) {

            });
        }
    });
    $(".msg-list-item-name").removeClass("msg-list-item-name").addClass("msg-list-item-name2");
    
}


var activeNewsHtml = function(news){
    var htmlStr = '<div class="active-msg"><div class="active-msg-title">'+ news.msgTitle +'</div>'
                + '<div class="active-msg-info"><span class="active-msg-topic">'+news.topicname+'</span><span class="active-msg-time">时间：'+news.msgTime+'</span><span class="active-msg-font">字体：<span>大</span><span>中</span><span class="active-font">小</span></span></div>'
                + '<div class="active-msg-content">'+news.msgCon+'</div>'
                + '<div class="active-msg-declaration"><span>i</span>重要声明'
                + '<br>本公司提供的任何信息仅供参考，并不构成所述证券买卖的出家或询价，投资者使用前请予以核实，风险自负。本公司所提供的公司公告、个股资料、投资咨询建议等信息，力求但不保证数据的准确性和完整性，请以上市公司公告信息为准。对非因我司重大过失而产生的信息内容错漏，以及投资者因依赖上述资料进行投资决策而导致的财产损失，不承担法律责任。</div>'
                + '</div>';
    return htmlStr;
}


//点击查看某类消息,返回最多50条;
gtjawebEtUI.getXXZXLayoutTemplate = function (type, domEl) {
    domEl.html('');
    // var htmlStr = '<div class="msg-list"><ul class="type-msg-content"><li class="msg-list-item"><div class="msg-list-item-name">美联储继续升息 未来数月不会让特朗普高兴新浪财经美联储</div><div class="msg-list-item-info"><span class="msg-class">【资讯提醒】</span><span class="msg-time">2018-08-22 13:59</span></div></li>'
    //             + '<li class="msg-list-item"><div class="msg-list-item-name2">美联储继续升息 未来数月不会让特朗普高兴新浪财经美联储</div><div class="msg-list-item-info"><span class="msg-class">【资讯提醒】</span><span class="msg-time">2018-08-22 13:59</span></div></li>'
    //             + '<li class="msg-list-item"><div class="msg-list-item-name2">美联储继续升息 未来数月不会让特朗普高兴新浪财经美联储</div><div class="msg-list-item-info"><span class="msg-class">【资讯提醒】</span><span class="msg-time">2018-08-22 13:59</span></div></li>'
    //             + '<li class="msg-list-item"><div class="msg-list-item-name2">美联储继续升息 未来数月不会让特朗普高兴新浪财经美联储</div><div class="msg-list-item-info"><span class="msg-class">【资讯提醒】</span><span class="msg-time">2018-08-22 13:59</span></div></li>';
    // htmlStr += '</ul><div class="msg-list-bottom"><div class="set-all-read">全部已读</div></div></div>';
    // domEl.append(htmlStr);    

    switch (type) {
        case '100001':
            type = 'NN'; 
            break;
        case '100002':
            type = 'NS';
            break;
        case '100003':
            type = 'TA';
            break;
        case '100004':
            type = 'AM';
            break;
        case '100005':
            type = 'FS';
            break;
        case '100006':
            type = 'SV';
            break;
        case '100007':
            type = 'SN';
            break;
    }

    exports.getUserInfo().then(function (userinfo) {
        if (userinfo.USERCOUNT <= 0 && type != 'npsType') {
            var htmlStr = '<div class="xxzx-wrap NS-no-msg">' +
                '<img src="./imgs/login.png">' +
                '<span class="NS_nodata_text">' + msgTypeImg[type].logintip + '</span>' +
                '<p class="NS-login">' +
                '<button type="button" class="login-btn"><a href="http://fyadduser.com">登录</a></button>' +
                '</p></div>';
            var s = $(htmlStr);
            domEl.append(s);
            return;
        }
        var userInfo = userinfo.list[userinfo.USERCOUNT];
        var typeName = '';
        var activeNews = {};

        //点击问卷导航
        if(type == 'npsType'){
            var htmlStr = '<iframe src="https://gm.gtja.com/surveyNew/index.html#/home/5ef9cdf6d3237b9f76c8b4dc?userCode='+userInfo.MUSERCODE+'" frameborder="0" style="width:100%; height:100%"></iframe>';
            domEl.append(htmlStr);
            return;
        }        

        if(type != 'xtszType'){
            var getMsgList = '';
            if(type == 'xtgsType'){
                getMsgList = exports.GetInfocentNewsData(userInfo.USER_CUSTID, '0');                
            }else{
                getMsgList = exports.GetInfocentClassData(userInfo.USER_CUSTID, type, '0');
            }
            getMsgList.then(function(res){
                if(res.RNUM < 1){
                    var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">暂无消息</span></div>';
                }else{
                    var newsList = res.list;
                    activeNewsObj.activeNewsList = newsList;
                    activeNewsObj.activeType = type;
                    var unreadNum = 0;
                    var pos = 30;

                    for(var i=0; i<newsList.length; i++){
                        newsList[i].msgTitle = decode_title_content(newsList[i].msgtitle);
                        newsList[i].msgTime = xxzxTime(newsList[i].TopicTime, 'all');
                        newsList[i].msgCon = decode_title_content(newsList[i].msgcontent);
                        newsList[i].msgClass = newsList[i].busname;
                        if (newsList[i].topicid == '33') {
                            var con = JSON.parse(newsList[i].msgCon);
                            var MSG_TYPE = con.MSG_TYPE;
                            if (MSG_TYPE == 'WTCG') {
                                newsList[i].msgTitle = '策略交易埋单委托成功提醒';
                            }
                        }
                    }
                    activeNews = newsList[0];

                    var htmlStr = '<div class="msg-list"><ul class="type-msg-content '+type+'">';
                    for(var i=0; i<newsList.length; i++){
                        var titleClass = 'msg-list-item-name';
                        if(newsList[i].isread == '1' || i==0){
                            titleClass = 'msg-list-item-name2';
                        }
                        var collectClass = 'msg-collect';
                        if(newsList[i].collect == '1'){
                            collectClass = 'msg-cancel-collect';
                        }
                        htmlStr += '<li class="msg-list-item '+(i==0?'msg-list-item-active':'')+'" onclick="clickListMsg(this,1)" data-msgid="'+newsList[i].msgid+'"><div class="'+titleClass+'">'
                                +newsList[i].msgTitle+'</div><div class="msg-list-item-info"><span class="msg-class">【'
                                +newsList[i].msgClass+'】</span><span class="msg-time">'
                                +'<div class="msg-collect-tip">收藏成功</div>'
                                +'<span class="msg-collect-img '+collectClass+'" onclick="storeMsg(this,'+"'"+newsList[i].msgid+"'"+')"></span>'
                                +newsList[i].msgTime+'</span>'
                                +'</div></li>';
                    }
                    htmlStr += '</ul><div class="msg-list-bottom"><div class="set-all-read" onclick="setAllRead()">全部已读</div></div></div><div class="active-msg"></div>';
                                   
                }
                var s = $(htmlStr);
                domEl.append(s);
                if(res.RNUM > 1){
                    var activeNewsContainer = $(".active-msg");
                    readMsg(activeNews.msgid, activeNewsContainer);
                }
                 

                $("."+type)[0].onscroll = function(){
                    var wholeHeight = $("."+type)[0].scrollHeight;
                    var scrollTop = $("."+type)[0].scrollTop;
                    var divHeight = $("."+type)[0].clientHeight;                
                    if (divHeight +　scrollTop >= wholeHeight && res.RNUM == '30'){
                        loadMoreMsg(type, pos);
                        pos += 30;
                    }
                }
            });
            return;        
        }

        //使用本地收藏消息
        if(type == 'xtszType'){
            exports.GetStoreData(userInfo.USER_CUSTID, 0).then(function(res){
                var storeList = [];
                if (res.RNUM > 0) {
                    storeList.RNUM = res.RNUM;
                    storeList.list = [];
                    for (var i = 0; i < res.list.length; i++) {
                        item = res.list[i];
                        var info = {};
                        info.msgid = item.msgid;
                        info.msgTitle = decode_title_content(item.msgtitle);
                        info.msgTime = xxzxTime(item.TopicTime, 'all');
                        info.msgClass = item.busname;
                        info.msgSummary = decode_title_content(item.msgsummary);
                        info.topicid = item.topicid;
                        storeList.list.push(info);
                    }
                    var htmlStr = '<div class="msg-list"><ul class="type-msg-content '+type+'">';
                    for(var i=0; i<storeList.list.length; i++){
                        if(storeList.list[i].isread == '1' || i==0){
                            var titleClass = 'msg-list-item-name2';
                        }else{
                            var titleClass = 'msg-list-item-name';
                        }
                        htmlStr += '<li class="msg-list-item '+(i==0?'msg-list-item-active':'')+'" onclick="clickListMsg(this,2)" data-msgid="'+storeList.list[i].msgid+'"><div class="'+titleClass+'">'
                                +storeList.list[i].msgTitle+'</div><div class="msg-list-item-info"><span class="msg-class">【'
                                +storeList.list[i].msgClass+'】</span><span class="msg-time">'
                                +'<div class="msg-collect-tip">收藏成功</div>'
                                +'<span class="msg-collect-img msg-cancel-collect" onclick="storeMsg(this,'+"'"+storeList.list[i].msgid+"'"+')"></span>'
                                +storeList.list[i].msgTime+'</span></div></li>';
                    }
                    htmlStr += '</ul></div><div class="active-msg"></div>';
                    domEl.append(htmlStr);

                    var activeNews = storeList.list[0];
                    var activeNewsContainer = $(".active-msg");
                    readMsg(activeNews.msgid, activeNewsContainer, 2);

                }else{
                    var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">暂无消息</span></div>';
                    domEl.append(htmlStr);
                }
            },function(err){
                var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">获取收藏消息失败</span></div>';
                domEl.append(htmlStr);
            })
            return
        }


        /*******************
        if(type == 'xtszType'){
            var requestScList = {
                acctType: 'cu',
                acctId: userInfo.USER_CUSTID,
                acctToken: '',
                number: '50',
                start: '0'
            }

            exports.uc['消息收藏列表查询']({
                inparam: JSON.stringify(requestScList)
            }).then(function (res) {
                var storeList = [];
                if (res.RNUM > 0) {
                    storeList.RNUM = res.RNUM;
                    storeList.list = [];
                    for (var i = 0; i < res.list.length; i++) {
                        item = JSON.parse(res.list[i].outparam);
                        var info = {};
                        info.msgid = item.msgId;
                        info.msgTitle = item.title;
                        info.msgTime = xxzxTime(item.pubTime, 'all');
                        info.msgClass = item.busName;
                        info.msgSummary = item.msgsummary;
                        info.topicid = item.topicId;
                        storeList.list.push(info);
                    }
                    var htmlStr = '<div class="msg-list"><ul class="type-msg-content '+type+'">';
                    for(var i=0; i<storeList.list.length; i++){
                        if(storeList.list[i].isread == '1' || i==0){
                            var titleClass = 'msg-list-item-name2';
                        }else{
                            var titleClass = 'msg-list-item-name';
                        }
                        htmlStr += '<li class="msg-list-item '+(i==0?'msg-list-item-active':'')+'" onclick="clickListMsg(this,2)" data-msgid="'+storeList.list[i].msgid+'"><div class="'+titleClass+'">'
                                +storeList.list[i].msgTitle+'</div><div class="msg-list-item-info"><span class="msg-class">【'
                                +storeList.list[i].msgClass+'】</span><span class="msg-time">'
                                +storeList.list[i].msgTime+'</span></div></li>';
                    }
                    htmlStr += '</ul></div><div class="active-msg"></div>';
                    domEl.append(htmlStr);

                    var activeNews = storeList.list[0];
                    var activeNewsContainer = $(".active-msg");
                    readSCMsg(activeNews.msgid, activeNewsContainer);

                }else{
                    var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">暂无消息</span></div>';
                    domEl.append(htmlStr);
                }
            }, function (err) {
                var htmlStr = '<div class="xxzx-wrap no-msg"><img src="./imgs/nodata_pic.png"><span class="nodata_text">获取收藏消息失败</span></div>';
                domEl.append(htmlStr);
            })            
        }
        *********************/

    });
}

//获取终端信息
function getTerminal(){
    $.ajax({
        async:false,
        url: "../_common/pc.dat",
        type: "GET",
    })
    .done(function(data) {
        // console.log("success:"+data);
        var myUrlParams = data.split('\n');
        var param = myUrlParams[1];
        MAC = param.split("|")[0];
    })
    .fail(function() {
        console.log("error");
    });
};
getTerminal();

$(function () {

    exports.getUserInfo().then(function (userInfo) {
        // console.log("客户信息："+JSON.stringify(userInfo));
        //登录et
        var userInfo = userInfo.list[userInfo.USERCOUNT];
        var loginFlag = (userInfo.USER_CUSTID == '') ? false : true;
        CUSTID = userInfo.USER_CUSTID;
        if(userInfo.MOBILENO){
            MOBILE = userInfo.MOBILENO
        }
        // var msgTypeList = ['NS', 'TA', 'AM', 'NN', 'FS', 'SV', 'SN'];
        // var typeArray = [];

        if (loginFlag) {
            gtjaWebEtLoginApi.custId = userInfo.USER_CUSTID;
            gtjaWebEtLoginApi.custType = '3';
            gtjaWebEtLoginApi.ettoken = userInfo.USER_OLDTOKEN;
        } else {
            var min = 1000, max = 10000000;
            gtjaWebEtLoginApi.custId = Math.floor(Math.random() * (max - min - 1) + min);
            gtjaWebEtLoginApi.custType = '-1';
        }
        gtjaWebEtLoginApi.checkLogin();


        exports.GetInfocentData(userInfo.USER_CUSTID, '0').then(function(res){
            // console.log('最新消息列表:'+JSON.stringify(res));
            var unreadAll = 0;
            var typeList = [];
            for(var i=0; i<res.RNUM; i++){
                var item = res.list[i];
                var type = msgTypeImg[item.busid].code;
                var num = res.list[i].count;
                if(typeList.indexOf(type)==-1){
                    typeList.push(type);
                    unreadAll += Number(num);
                }
                gtjawebEtUI.setXXZXUnreadNum(type, num);
            }
            gtjawebEtUI.setXXZXUnreadNum('xtgsType', unreadAll);

            if(res.RNUM > 0){
                var newest = res.list[res.RNUM-1]
                var title = decode_title_content(newest.msgtitle);
                var time = xxzxTime(newest.TopicTime, 'minute');
                gtjawebEtUI.setXXZXRecentTips('xtgsType', time, title);
            }
        });

        //通过不同url参数，定位至不同会话
        if (urlParam["kfjid"]) {
            if (urlParam["kfjid"] == 'lx') {
                gtjaWebEtLoginApi.openChatWin('', '');
            } else {
                if (urlParam["kfname"]) {
                    gtjaWebEtLoginApi.openChatWin(urlParam["kfjid"], urlParam["kfname"]);
                } else {
                    gtjaWebEtLoginApi.openChatWin(urlParam["kfjid"], '');
                }
            }
        } else if (urlParam["msgtype"]) {
            var type = urlParam["msgtype"];
            var code = msgTypeImg[type].code;
            gtjaWebEtLoginApi.viewType(code);
        } else if (urlParam["xxzx"]) {
            gtjaWebEtLoginApi.viewType("100001");
        } else {
            gtjaWebEtLoginApi.openChatWin('', '');
        }

        /***********报错转译**************/
        Date.prototype.Format = function(fmt)   
        {  
          var o = {   
            "M+" : this.getMonth()+1,                 //月份   
            "d+" : this.getDate(),                    //日   
            "h+" : this.getHours(),                   //小时   
            "m+" : this.getMinutes(),                 //分   
            "s+" : this.getSeconds(),                 //秒   
            "q+" : Math.floor((this.getMonth()+3)/3), //季度   
            "S"  : this.getMilliseconds()             //毫秒   
          };   
          if(/(y+)/.test(fmt))   
            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));   
          for(var k in o)   
            if(new RegExp("("+ k +")").test(fmt))   
          fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));   
          return fmt;   
        }

        
        let autoErr = urlParam["error"]
        let errCode = urlParam["errcode"]
        //if(autoErr && autoErr != '')
        if(autoErr!='' && autoErr!=undefined && autoErr!=null){
            let autoAsk = function(){
                var receiverId = $chatMain.attr("id");
                autoErr = decodeURI(autoErr)
                gtjawebEtUI.writeReceiveMessage('me', autoErr, receiverId);
                let errorTime = new Date().Format("yyyy-MM-dd hh:mm:ss");
                let data = JSON.stringify({
                    APPVERSION: '',
                    DEVICEINFO: '',
                    PLATFORM: 'et_fyerror',
                    ERROR: autoErr,
                    ERRORTIME: autoErr,
                    ERRORCODE: errCode,
                    CUST_CODE: userInfo.USER_CUSTID,
                    CUACCT_CODE: userInfo.USER_FUNDID,
                    PHONE: userInfo.USERCODE,
                    CHANNELCODE: '',
                    FUNC: ''        
                })

                exports.h5uc['报错转译服务']({
                    data:data
                }).then(function(res){
                    console.log("报错答案："+JSON.stringify(res))
                    if(res.RNUM != '1'){
                        return
                    }
                    let result = JSON.parse(res.list[0].rts_data)
                    let answer = result.data.FUNCTION_RESULT_LIST[0].ERRORANSWER
                    gtjawebEtUI.writeReceiveMessage('znkf', answer, receiverId);
                })
            }            
            setTimeout(()=>{
                autoAsk();
            },3000)
        }

    }, function (err) {
        $(".lx-come").append('获取客户信息失败：' + err);
    });
})