/*global window, angular, app*/


/**
 * FQL的接口导出
 */
app.factory('fql', ['fyCallbackWrap', function(fyCallbackWrap) {

    var wrap = fyCallbackWrap;

    var exports = {
        getUserInfo: function() {
            return wrap('用户信息获取', {
                fytype: 'innercmd',
                method: 'getuserinfo',
                mname: '用户信息获取'
            })
        },
        getOptInfo: function() {
            return wrap('期权基础信息', {
                fytype: 'innercmd',
                method: 'getoptinfo',
                mname: '期权基础信息'
            })
        },
        //1、消息中心接口
        GetInfocentData: function(ipos) {
            return wrap('获取消息中心内容', {
                fytype: 'innercmd',
                method: 'getinfodata',
                mname: '获取消息中心内容',
                sql: 'SELECT * FROM MqttTopicTable where ClientID="' + encode64("18805082") + '" ORDER BY TopicTime DESC limit ' + ipos + ', 50'
            })
        },
        //2、分类获取消息内容
        GetInfocentClassData: function(busid, ipos) {
            return wrap('分类获取消息内容', {
                fytype: 'innercmd',
                method: 'infocentdefgetdata',
                mname: 'SQLLITE调用',
                sql: 'SELECT * FROM MqttTopicTable where ClientID="' + encode64("18805082") + '" and busid="' + busid + '" ORDER BY TopicTime DESC limit ' + ipos + ', 50'
            })
        },
        //3、获取单个消息内容
        GetSingleData: function(msgid) {
            return wrap('获取单个消息内容', {
                fytype: 'innercmd',
                method: 'infocentdefgetdata',
                mname: 'SQLLITE调用',
                sql: 'SELECT * FROM MqttTopicTable where msgid=' + msgid
            })
        },
        //4、定制化接口
        GetInfocentDefData: function(in_sql) {
            return wrap('定制化查询数据', {
                fytype: 'innercmd',
                method: 'infocentdefgetdata',
                mname: 'SQLLITE调用',
                sql: in_sql
            })
        },
        //5-1、获取收藏信息列表
        GetStoreData: function(msgpos) {
            return wrap('获取收藏信息列表', {
                fytype: 'innercmd',
                method: 'infocentgetstore',
                mname: '获取收藏信息列表',
                msgpos: msgpos
            })
        },
        //5-2、获取消息内容
        GetStoreDataContext: function(msgpos) {
            return wrap('获取消息内容', {
                fytype: 'innercmd',
                method: 'infocentgetinfocontent',
                mname: '获取消息内容',
                msgpos: msgpos
            })
        },
        //6、标记消息内容已读
        SetReading: function(msgid) {
            return wrap('标记消息内容已读', {
                fytype: 'innercmd',
                method: 'infocentsetreading',
                mname: '标记消息内容已读',
                mmsgid: msgid
            })
        },
        //7、收藏消息
        SetStoring: function(msgid) {
            return wrap('收藏消息', {
                fytype: 'innercmd',
                method: 'storeinfo',
                mname: '收藏消息',
                mmsgid: msgid
            })
        }
    };

    var isObject = function(data) {
        return Object.prototype.toString.call(data) === '[object Object]';
    };

    var extObject = function(obj1, obj2) {
        for (var key in obj2) {
            if (obj1.hasOwnProperty(key)) continue;
            obj1[key] = obj2[key];
        }
        return obj1;
    }

    /*发送KCXP集中交易普通核心请求 fql.homepage[持仓查询]*/
    var reg = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                //$scope.userinfo = raw.list[1];//JSON.parse(JSON.stringify(raw)).list[1]; //用户信息结构，Ret为当前用户
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'jzjy'
                }
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP集中交易融资融券核心请求 fql.homepage[持仓查询]*/
    var reg2 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'rzjzjy'
                }
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP用户中心请求 */
    var reg3 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'uc'
                }
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP用户中心游客请求 */
    var reg4 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'ucvistor'
                }
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP综合理财请求 */
    var reg5 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'zhlc'
                }
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP期权相关请求 */
    var reg6 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'opt'
                };
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP信用风险指标请求 */
    var reg7 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 'rzjzjy'
                };
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送KCXP 综合理财T2请求 */
    var reg8 = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'kcxpcmd',
                    funcid: fnId,
                    rtsname: 't2'
                };
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());

    /*发送LTS 低延时环境 */
    var reghLTS = (function() {
        return function(namespace, fnId, key) {
            exports[namespace] = exports[namespace] || {};
            exports[namespace][key] = function(reqs) {
                var request = {
                    fytype: 'ltscmd',
                    funcid: fnId,
                    rtsname: 'ltscmd'
                };
                request = extObject(request, reqs);
                return fyCallbackWrap(key, request);
            };
        };
    }());


    reg('homepage', '410538', '深圳LOF分红查询'); //深圳LOF基金分红方式查询
    reg('homepage', '410503', '持仓查询'); //集中交易功能示例
    reg('homepage', '410427', '担保物转信用'); //担保物转信用
    reg2('homepage', '420503', '信用持仓查询'); //信用持仓查询
    reg2('homepage', '420415', '担保物转普通'); //担保物转普通
    reg('homepage', '410411', '股票买卖委托'); //集中交易功能示例
    reg2('homepage', '410503', '用户');
    reg('homepage', '410593', '普通投票议案'); //普通投票议案
    reg('homepage', '410595', '投票结果查询'); //投票结果查询
    reg('homepage', '410596', '沪深网络投票'); //沪深网络投票
    reg('homepage', '410597', '沪深投票数量'); //沪深投票数量
    reg('homepage', '410598', '投票委托查询'); //投票委托查询
    reg('homepage', '410786', '普通投票回报查询'); //普通投票回报查询
    reg7('homepage', '410741', '信用持仓集中度查询'); //信用持仓集中度查询
    reg7('homepage', '410742', '交易风险预警线查询'); //交易风险预警线查询
    reg2('homepage', '420416', '客户投票'); //客户投票
    reg2('homepage', '420430', '信用投票查询'); //信用投票查询
    reg2('homepage', '420431', '信用投票数量'); //信用投票数量
    reg2('homepage', '410786', '信用投票回报查询'); //信用投票回报查询

    reg('homepage', '400400', '查询指定组合证券'); //查询指定组合证券
    reg6('homepage', 'L2934027', '临近到期合约查询'); //临近到期合约查询
    reg6('homepage', 'L2912005', '合约变更查询'); //合约变更查询
    reg6('homepage', 'L2912002', '行权指派查询'); //行权指派查询
    reg6('homepage', 'L2934002', '合约持仓查询'); //合约持仓查询

    // 账户分析
    reg8('account', '13100007', '大数据我的账户');
    reg8('account', '13100008', '大数据转账分析');
    reg8('account', '13100009', '大数据收益能力');
    reg8('account', '13100010', '大数据我的收益率');
    reg8('account', '13100011', '大数据沪深300收益率');
    reg8('account', '13100012', '大数据盈利TOP');
    reg8('account', '13100013', '大数据亏损TOP');
    reg8('account', '13100014', '大数据选股能力');
    reg8('account', '13100015', '大数据盘面感知总结');
    reg8('account', '13100016', '大数据证券交易成交');
    reg8('account', '13100017', '大数据基金交易查询');
    reg8('account', '13100018', '大数据融资融券成交');
    reg8('account', '13100019', '大数据我的帐户评级');
    reg8('account', '13100020', '大数据仓位控制');
    reg8('account', '13100021', '大数据仓位控制我的仓位');
    reg8('account', '13100022', '大数据仓位控制沪深指数');
    reg8('account', '13100023', '大数据盘面感知买入分布');
    reg8('account', '13100024', '大数据盘面感知卖出分布');
    reg8('account', '13100025', '大数据风险控制');
    reg8('account', '13100026', '大数据评级替代行情');
    reg8('account', '13100027', '大数据评级替代股票');
    reg8('account', '13100028', '大数据收益top股票');
    reg8('account', '13100029', '大数据收益top理财');
    reg8('account', '13100030', '大数据收益top收益走势');
    reg8('account', '13100031', '大数据账户分析时间段');
    reg8('account', '13100036', '大数据客户累计收益查询');
    reg8('account', '10201009', '资金账号查询');

    reg3('account', '12005020', '登录客户推荐产品查询');

    // 个股诊断
    reg3('gegu', '12003101', '个股诊断-技术面');
    reg3('gegu', '12003102', '个股基本面查询');
    reg3('gegu', '12003103', '个股基本面明细查询');
    reg3('gegu', '12003104', '个股诊断-资金面');
    reg3('gegu', '12003105', '个股诊断-资金面-资金流向');
    reg3('gegu', '12003106', '个股诊断-消息面');
    reg3('gegu', '12003107', '个股诊断-消息面-利好利空消息');
    reg3('gegu', '12003108', '个股诊断-消息面-股民关注度');
    reg3('gegu', '12003109', '个股诊断-诊股结论');
    reg3('gegu', '12003110', '个股诊断-操作策略');
    reg3('gegu', '12003111', '个股诊断-股民预测');
    reg3('gegu', '12003114', '个股诊断-个股基本交易数据');
    reg3('gegu', '12003115', '个股诊断-个股龙虎榜列表');
    reg3('gegu', '12003116', '个股诊断-个股大宗交易列表');
    reg3('gegu', '12003117', '个股诊断-个股融资余额列表');
    reg3('gegu', '12003118', '个股诊断-所有得分');
    reg3('gegu', '12003119', '个股诊断-申万二级行业走势');

    //资讯页面
    reg3('news', '12005203', '资讯主题最新列表查询');


    //债券质押式协议回购
    reg('homepage', '412101', '权限开通查询'); //权限开通查询
    reg('homepage', '412102', '债券协议回购报价行情查询'); //债券协议回购报价行情查询
    reg('homepage', '412109', '持仓合约查询'); //持仓合约查询
    reg('homepage', '412104', '委托查询'); //委托查询
    reg('homepage', '412107', '委托撤单'); //委托撤单
    reg('homepage', '412105', '交易员信息查询'); //交易员信息查询

    //债券质押
    reg('homepage', '412110', '回购指标查询'); //回购指标查询

    // ------------------------------ 低延时 -----------------------------
    reghLTS('ltscmd', '7300707', '网络投票议案公告查询') //410593
    reghLTS('ltscmd', '7390707', '信用投票可投票数') //420431
    reghLTS('ltscmd', '7107701', '信用客户投票') //420416
    reghLTS('ltscmd', '7390706', '信用投票委托查询') //420430

    return exports;

}]);