﻿var app = angular.module("app", ['ui.router']);

app.factory('fyCallbackWrap', ['$q', function ($q) {

	var fyCallbackWrap = {};
	var totalCallTimes = 0;
	var utils = {};

/**
 * 将 url 的附带参数转化成 JSON 对象
 * @param  {String} str 类似于`"name=abc&age=12"`
 * @return {JSON}     JSON键值对
 */
utils.queryToJson = function (str) {
  return str.split('&').reduce(function (prev, curr) {
    var val=curr.substring(curr.indexOf("=")+1,curr.length);
    curr = curr.split('=');
    prev[curr[0]] = val;
    return prev;
  }, {});
};

/**
 * 将 JSON 对象转换成 url 查询字符串
 * @param  {JSON} obj JSON键值对
 * @return {String}     查询串
 */
utils.jsonToQuery = function (obj) {
  var ret = [];
  var key;
  for (key in obj) {
    if (obj.hasOwnProperty(key)) {
      ret.push(key + '=' + obj[key]);
    }
  }
  return ret.join('&');
};

utils.RetToJson = function (str) {
	var obj = {};
	var arr = str.split('$');
	var acurr ="";

	acurr = arr[0].split('=');
	obj[acurr[0]] = acurr[1];

	var str2 = arr[1].split(';');
	var retArr = [];
	for (var i in str2)
	{
		if(str2[i]=='') continue;
		var objItem = {};
		objItem = utils.queryToJson(str2[i]);
		retArr.push(objItem);
	}
    obj["list"] = retArr;
	return obj;
};

 function GetUserInfo($scope)
{
    var request = {
            fytype:'innercmd',
            method:'getuserinfo',
            mname:'用户信息获取'    
          };

    return fyCallbackWrap.FY_KCXPQuery('用户信息获取',request).then(function(raw)
    {
       userInfo = JSON.parse(JSON.stringify(raw)).list[1]; //用户信息结构，Ret为当前用户
       $scope.userInfo = userInfo;
       $scope.$apply();
    });
}

return function FY_KCXPQuery(funcname,req)
{
		var sReq = "";
		var log = true;
		var emun = {
			'innercmd': '内部请求',
			'kcxpcmd' : '外部请求',
			'jzjy'    : '集中交易',
			'zhlc'    : '综合理财',
			'ucenter'      : '用户中心',
			'opt'      : '期权相关',
			'rzjzjy'      : '信用风险指标',
			't2'      : '账户分析',
			'ltscmd': '低延时'
		}

		return $q(function (resolve, reject) {
		var callTimes = totalCallTimes++;
        var callBegin = +new Date();
    
		sReq += utils.jsonToQuery(req);

		//console.log(req);

		function onReject(err) {
          var content = '%cauto-error-log: %c[' + [funcname,  err].join('] %c[') + ']';
          console.info(content, 'color: #C30062', 'color: #4A4A4A', 'color: #4A4A4A', 'color: red');
          console.info('\t\tdetail:', data);
          reject(err);
        }

        //function resolve(raw)
        //{}

		function fyCallback(err, raw) {
          var callEnd = +new Date();
          var vret = "";
          if (raw == null)
          {
             vret = '';
          }
          else
          {
            vret = utils.RetToJson(raw);
          }
          var retde = function(eq)
          {
          	if(emun[req.fytype] =='内部请求')
          	{
          		return emun[req.fytype] +':' + req.method;
          	}
          	else
          	{
				return emun[req.rtsname] +':' + req.funcid;
          	}
          }
          
		console.log([
              '%c请求地址：'+FConfig._FYURL,
              '%c\nFYQRY(' + callTimes + ') 请求详情, [' + retde(req) + '][' + funcname + ']',
              '%c请求结构：',
              '%c' + JSON.stringify(req, null, '  '),
              '%c应答结果：',
              '%c' + JSON.stringify(vret, null, '  '),
              '%c耗时：%c' + (callEnd - callBegin) + 'ms',
              ''
            ].join('\n'), 'color: green', 'color: blue', 'color: gray', 'color: blue', 'color: gray', 'color: blue', 'color: gray');
          try {
            raw = vret;
          } catch (ex) {
            err = raw;
          }

          if (err) {
            onReject(err);
            }
             else {
              resolve(raw);
            }
        }

		var options = {
          fytype : req.fytype,
		      path: FYServer,
		      data: sReq,
		      callback: fyCallback
		};
  		CallFYEX(options);
  		});
}


}]);