var wrap = fyCallbackWrap();
var exports = {
    getUserInfo: function () {
        return wrap('用户信息获取', {
            fytype: 'innercmd',
            method: 'getuserinfo',
            mname: '用户信息获取'
        })
    },
    // getLocalUserInfo: function () {
    //     return wrap('用户信息获取', {
    //         fytype: 'innercmd',
    //         method: 'getLocalUserInfo',
    //         mname: '用户信息获取'
    //     })
    // },
    getOptInfo: function () {
        return wrap('期权基础信息', {
            fytype: 'innercmd',
            method: 'getoptinfo',
            mname: '期权基础信息'
        })
    },
    //1、消息中心接口
    GetInfocentData: function (clientId, ipos) {
        return wrap('获取消息中心内容', {
            fytype: 'innercmd',
            method: 'getinfodata',
            mname: '获取消息中心内容',
            sql: 'SELECT * FROM MqttTopicTable where (ClientID="' + encode64(clientId) + '" OR ClientID="' + encode64('PUB') + '") ORDER BY TopicTime DESC limit ' + ipos + ', 50'
        })
    },
    //2、分类获取消息内容
    GetInfocentClassData: function (clientId, busid, ipos) {
        return wrap('分类获取消息内容', {
            fytype: 'innercmd',
            method: 'infocentdefgetdata',
            mname: 'SQLLITE调用',
            sql: 'SELECT * FROM MqttTopicTable where (ClientID="' + encode64(clientId) + '" OR ClientID="' + encode64('PUB') + '") and busid="' + busid + '" and topicid<>"159"' + ' GROUP BY msgid ORDER BY TopicTime DESC limit ' + ipos + ', 50'
        })
    },
    //3、获取单个消息内容
    GetSingleData: function (msgid) {
        return wrap('获取单个消息内容', {
            fytype: 'innercmd',
            method: 'infocentdefgetdata',
            mname: 'SQLLITE调用',
            sql: 'SELECT * FROM MqttTopicTable where msgid=' + msgid
        })
    },
//获取消息中心最新消息（不区分消息类别）
    GetInfocentNewsData : function (clientId, ipos) {
        return wrap('分类获取消息内容',{
            fytype: 'innercmd',
            method: 'infocentdefgetdata',
            mname: 'SQLLITE调用',
            sql: 'SELECT * FROM MqttTopicTable where (ClientID="' + encode64(clientId) + '" OR ClientID="' + encode64('PUB')  + '") and topicid<>"159"' + ' ORDER BY TopicTime DESC limit ' + ipos + ', 30' 
        })
    },    //4、定制化接口
    GetInfocentDefData: function (in_sql) {
        return wrap('定制化查询数据', {
            fytype: 'innercmd',
            method: 'infocentdefgetdata',
            mname: 'SQLLITE调用',
            sql: in_sql
        })
    },
    //5-1、获取收藏信息列表
    GetStoreData: function (clientId, ipos) {
        return wrap('获取收藏信息列表', {
            fytype: 'innercmd',
            method: 'infocentdefgetdata',
            mname: 'SQLLITE调用',
            sql:  'SELECT * FROM MqttTopicTable where (ClientID="' + encode64(clientId) + '" OR ClientID="' + encode64('PUB') + '" ) and collect=1  ORDER BY TopicTime DESC limit ' + ipos + ', 50'
        })
    },
    //5-2、获取消息内容
    GetStoreDataContext: function (msgid) {
        return wrap('获取消息内容', {
            fytype: 'innercmd',
            method: 'getinfocontent',
            mname: '获取消息内容',
            mmsgid: msgid
        })
    },
    //6、标记消息内容已读
    SetReading: function (msgid) {
        return wrap('标记消息内容已读', {
            fytype: 'innercmd',
            method: 'infocentsetreading',
            mname: '标记消息内容已读',
            mmsgid: msgid
        })
    },
    //7、收藏消息
    SetStoring: function (msgid) {
        return wrap('收藏消息', {
            fytype: 'innercmd',
            method: 'WriteQueryData',
            mname: 'SQLLITE调用',
            sql: 'Update MqttTopicTable set collect=1 where msgid=' + msgid
        })
    },
    //8、取消订阅
    UnsubscribeSubTopic: function (topicid) {
        return wrap('取消订阅', {
            fytype: 'innercmd',
            method: 'unsubscribe',
            mname: '取消订阅',
            subtopic: topicid
        })
    },
    //9、删除消息
    DeleteMsg: function (msgid) {
        return wrap('删除消息', {
            fytype: 'innercmd',
            method: 'deletemsg',
            mname: '删除消息',
            mmsgid: msgid
        })
    },
    //10、取消收藏
    CancelCollect: function (msgid) {
        return wrap('取消收藏', {
            fytype: 'innercmd',
            method: 'WriteQueryData',
            mname: 'SQLLITE调用',
            sql: 'Update MqttTopicTable set collect=0 where msgid=' + msgid
        })
    },
    //11、获取离线响应人消息数
    getUnReadEhrId: function () {
        return wrap('读取未读响应人消息', {
            fytype: 'innercmd',
            method: 'getUnReadEhrId',
            mname: '读取未读响应人消息'
        })
    },
    //12、设置离线响应人消息已读
    setUnReadEhrId: function (ehrid) {
        return wrap('设置响应人消息已读', {
            fytype: 'innercmd',
            method: 'setUnReadEhrId',
            mname: '设置响应人消息已读',
            content: ehrid
        })
	},
    //13、设置全部已读
    setAllMsgRead: function (clientId, busid) {
        return wrap('写操作',{
          fytype: 'innercmd',
          method: 'WriteQueryData',
          mname: 'SQLLITE调用',
          sql: 'Update MqttTopicTable set isread=1 where (ClientID="' + encode64(clientId) + '" OR ClientID="' + encode64('PUB')  + '") and busid="' + busid + '"'
        })
    },
	/*****富易客户端数据存储****/
    /*mname: 
    savekey: 分用户内存KV保存 
    getkey: 分用户内存获取，KEY为空时返回所有
    savefkey: 全局文件KV保存 
    getfkey: 全局文件KV获取
    */
    fyDataHelp: function(key,val,mname){
        return wrap('设置缓存', {
            fytype: 'openinfo',
            method: 'sharestore',
            key: key,
            value: val,
            mname: mname
        })      
    }
};

var isObject = function (data) {
    return Object.prototype.toString.call(data) === '[object Object]';
};

var extObject = function (obj1, obj2) {
    for (var key in obj2) {
        if (obj1.hasOwnProperty(key)) continue;
        obj1[key] = obj2[key];
    }
    return obj1;
}

/*发送KCXP集中交易普通核心请求 fql.homepage[持仓查询]*/
var reg = (function () {
    // 使用闭包创建一个获取用户信息结构
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            //$scope.userinfo = raw.list[1];//JSON.parse(JSON.stringify(raw)).list[1]; //用户信息结构，Ret为当前用户
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 'jzjy'
            }
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP集中交易融资融券核心请求 fql.homepage[持仓查询]*/
var reg2 = (function () {
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 'rzjzjy'
            }
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP用户中心请求 */
var reg3 = (function () {
    // 使用闭包创建一个获取用户信息结构
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 'uc'
            }
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP用户中心游客请求 */
var reg4 = (function () {
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 'ucvistor'
            }
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP 综合理财T2请求 */
var reg5 = (function () {
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 't2'
            };
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP 综合理财T2透传 */
var reg6 = (function () {
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 't2jzjy'
            };
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

/*发送KCXP 用户中心移动 */
var reg7 = (function () {
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: 'ucmobile'
            };
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

var regH = (function () {
    return function (namespace, fnId, key) {
        var getUserInfo = exports.getUserInfo;
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function (reqs, log) {
            return getUserInfo().then(function (res) {
                var infoObj = res.list[res.USERCOUNT];
                var branch_no = '';
                if (infoObj.USER_BRANCHID == '') {
                    branch_no = infoObj.USER_ORGID;
                } else {
                    branch_no = infoObj.USER_BRANCHID;
                }
                var request = {
                    OP_CODE: '',
                    OP_BRANCH_NO: '',
                    OP_SITE: '',
                    OP_WAY: 'F',
                    OP_PROGRAM: '',
                    OP_LANGUAGE: '',
                    USER_CODE: infoObj.USERCODE,
                    CIF_ACCOUNT: infoObj.USER_CIFACCOUNT,
                    CUST_CODE: '03' + ('000000000000' + infoObj.USER_CUSTID).substr(-12),
                    BRANCH_NO: branch_no,
                    FUNC_ID: fnId,
                    PASSWORD: '0',
                    USER_TOKEN: infoObj.USER_TOKEN,
                    TOKEN_SERIAL_NO: '0',
                    TERMINAL_INFO: ''
                };
                request = extObject(request, reqs);
                return new Promise(function (resolve, reject) {
                    $.ajax({
                        url: 'https://yhzx.gtja.com/' + namespace + '/' + fnId,
                        type: 'POST',
                        dataType: 'json',   
                        headers: {
                            'Accept': 'application/json',
                            'Content-Type': 'text/plain'
                        },
                        data: JSON.stringify(request)
                    }).done(function (res) {
                        if (log) {
                            console.log([
                                '%c\nFYQRY(' + 0 + ') 请求详情, [用户中心H接口][' + fnId + ']',
                                '%c请求结构：',
                                '%c' + JSON.stringify(request, null, '  '),
                                '%c应答结果：',
                                '%c' + JSON.stringify(res, null, '  '),
                                '%c耗时：%c' + 0 + 'ms',
                                ''
                            ].join('\n'), 'color: green', 'color: blue', 'color: gray', 'color: blue', 'color: gray', 'color: blue', 'color: gray');
                        }
                        resolve(res);
                    })
                });
            });
        };
    };
}());

/*发送KCXP 综合理财T2请求 */
var regh5uc= (function () {
    var getUserInfo = exports.getUserInfo;
    return function (namespace, fnId, key) {
    exports[namespace] = exports[namespace] || {};
    exports[namespace][key] = function (reqs) {
        var request = {
        fytype:'kcxpcmd',
        funcid:fnId,
        rtsname:'h5uc'
        };
        request = extObject(request,reqs);
        return wrap(key, request);
    };
    };
}());

/*发送LTS 低延时环境 */
var reghLTS = (function() {
    return function(namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function(reqs) {
            var request = {
                fytype: 'ltscmd',
                funcid: fnId,
                rtsname: 'ltscmd'
            };
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());
//========消息中心===========
reg3('uc', '12007217', '客户响应人查询');
reg3('uc', '12006003', '总资产查询');
reg3('uc', '17400005', '更新消息发送表'); //包括已读设置和收藏设置
reg3('uc', '17400007', '消息收藏列表查询');
reg3('uc', '17400010', '收藏消息查看');



//========篮子交易==========
reg('basket', '410503', '持仓股查询');
reg('basket', '410530', '资金查询');

reg6('basket', '15970021', '用户篮子名称查询'); //830600 => 730600
reg6('basket', '15970022', '篮子明细查询'); //830602 => 730602
reg6('basket', '15970012', '客户持仓头寸查询'); //820762 => 720762
reg6('basket', '15970020', '当日策略委托查询'); //810510 => 710510
reg6('basket', '15970001', '获得批号'); //820606
reg6('basket', '15970002', '添加组合'); //820810
reg6('basket', '15970003', '删除组合'); //820811
reg6('basket', '15970004', '组合批量下单'); //810412
reg6('basket', '15970005', '批量委托撤单'); //810414
reg6('basket', '15970024', '用户登陆'); //810305
// reg6('basket', '15970007', '虚拟组合移仓'); //830614


reg7('ucmobile', '12008111', '自选股查询');

reg('ctrl', '410742', '交易风险预警线查询');
// reg2('ctrl', '410741', '信用查询集中度查询');
// reg2('ctrl', '420626', '信用持仓集中度类型判定');
reg2('ctrl', '420657', '股票集中度查询');
reg2('ctrl', '420658', '板块集中度查询');
reg2('ctrl', '420656', '总体集中度查询');
reg2('ctrl', '420659', '板块所属证券查询');

//新股申购详情
regH('asset', 'H12000107', '新股申购详情');
