function ltsResult(raw) {
    var resData
    if (raw.RNUM >= 0) {
        var data = raw.list[0]
        if (data.data == "timeout") {
            resData = {
                list: [],
                errorinfo: data.data //timeout
            }
        } else {
            var list = JSON.parse(data.data)
            if (list.ord_rej_reason) {
                if (list.msg_type) {
                    resData = {
                        list: [],
                        errorinfo: list.msg_type + ':' + list.ord_rej_reason
                    }
                } else {
                    resData = {
                        list: [],
                        errorinfo: list.ord_rej_reason
                    }
                }
            } else {
                if (list.key_error_msg === '') {
                    resData = {
                        list: list,
                        errorinfo: ''
                    }
                } else {
                    if (list.msg_type) {
                        resData = {
                            list: list,
                            errorinfo: list.msg_type + ':' + list.key_error_msg
                        }
                    } else {
                        resData = {
                            list: list,
                            errorinfo: list.key_error_msg
                        }
                    }
                }
            }
        }
    } else {
        resData = {
            list: [],
            errorinfo: raw.list[0].ERRMSG
        }
    }
    return resData
}

function rzrqSecuidList(userinfo, market) {
    var obj = {},
        account_arr = [],
        secuidlist = JSON.parse(userinfo.SECUIDLIST),
        market_id = '',
        account_id = ''
    for (item in secuidlist) {
        if (item.indexOf('R') >= 0) {
            account_arr.push({ account_id: secuidlist[item] })
        }
    }
    if (market) {
        market_id = market == '101' ? '1' : '2'
        account_id = secuidlist['R' + market_id]
    } else {
        account_id = account_arr[Math.floor(Math.random() * account_arr.length)].account_id
    }
    obj = {
        account_id: account_id,
        secuid_arr: secuidlist,
        fundId: '03' + userinfo.USER_ORGID + ('0000000000' + userinfo.USER_CREDITFUNDID).substr(-10),
        client_id: '03' + ('000000000000' + userinfo.USER_CUSTID).substr(-12),
        ftime: userinfo.FTIME.replace(/\-|\:|\s+/g, ''),
        orderWay: 'F'
    }
    return obj
}


function decimalDigit(stkcode, market, price) {
    let codeArr = ['900', '18', '50', '42', '202', '16', '510', '58', '03', '51', '15', '204', '100', '101', '109', '111', '112', '115', '125', '131'],
        priceval = parseFloat(price)
    if (stkcode.length == 5) { //沪港通
        val = priceval.toFixed(3)
    } else {
        if (stkcode.length == 8) {
            val = priceval.toFixed(4)
        } else {
            if (parseInt(stkcode) > 100000 && parseInt(stkcode) < 199999) { //债券
                val = priceval.toFixed(3)
            } else {
                val = priceval.toFixed(2)
                if (market == 'D') { //上海B
                    val = priceval.toFixed(3)
                } else {
                    codeArr.forEach((item, index) => {
                        if (stkcode.startsWith(item)) {
                            val = priceval.toFixed(3)
                        }
                    })
                }
            }
        }
    }
    return val
}

function decimalFormat(val) {
    if (val != '') {
        let dotArr = val.toString().split('.'),
            dotNext = dotArr[1],
            res
        if (dotNext.length == 4 && dotNext.substr(dotNext.length - 2, 2) != '00') {
            res = parseFloat(val).toFixed(4)
        } else {
            res = parseFloat(val).toFixed(2)
        }
        return res
    }
}