/*** 客户端fql接口调用，慎改！***/
/*  注册接口需确认namespace
    jzjy：集中交易普通核心请求
    rzjzjy：集中交易融资融券核心请求
    uc：用户中心请求
    ucvistor：用户中心游客请求
    t2：综合理财T2请求
    t2jzjy：综合理财T2透传
    ucmobile：用户中心移动请求
*/

var wrap = fyCallbackWrap();
var exports = {
    getLocalUserInfo: function(){
        return wrap('用户信息获取', {
            fytype: 'innercmd',
            method: 'getuserinfo',
            mname: '用户信息获取'
        })       
    },
    getPcInfo: function(){
      return new Promise(function(resolve, reject){
        $.ajax({
          url: FYServer+"/?fytype=openinfo&method=pcinfo&mname=ipmac&fyAuthkey="+FConfig._FYTOKEN,
          type: 'GET',
          dataType: 'json',
          success: function(res){
            console.log("PCINFO:"+JSON.stringify(res))
            resolve(res)
          },
          error: function(err){
            reject(err)
          }
        })        
      });       
    },
    /*****富易客户端数据存储****/
    /*mname: 
    savekey: 分用户内存KV保存 
    getkey: 分用户内存获取，KEY为空时返回所有
    savefkey: 全局文件KV保存 
    getfkey: 全局文件KV获取
    */
    fyDataHelp: function(key,val,mname){
        return wrap('设置缓存', {
            fytype: 'openinfo',
            method: 'sharestore',
            key: key,
            value: val,
            mname: mname
        })      
    },
    /***富易客户端操作(自选股操作和获取交易设置)***/
    fyMethod: function(method, val){
        return wrap('客户端接口', {
            fytype: 'innercmd',
            method: method,
            value: val,
            mname: '客户端接口'
        })
    },
    /***富易客户端加密方法（入参依次为"加密内容"，"密钥","加密方法(AES)"）***/
    fyEncryptHelp: function(key,val,mname){
        return wrap('内容加密', {
            fytype: 'openinfo',
            method: 'mencrypt',
            key: key,
            value: val,
            mname: mname
        })
    },
};

var isObject = function(data) {
    return Object.prototype.toString.call(data) === '[object Object]';
};

var extObject = function(obj1, obj2) {
    for (var key in obj2) {
        if (obj1.hasOwnProperty(key)) continue;
        obj1[key] = obj2[key];
    }
    return obj1;
}


/* 统一接口注册 */
var reg = (function(){
    return function(namespace, fnId, key){
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function(reqs,log) {
            var request = {
                fytype: 'kcxpcmd',
                funcid: fnId,
                rtsname: namespace
            }
            request = extObject(request, reqs);
            return wrap(key, request, log)
        };
    }
}());

/* 微服务接口注册 */
//uc_pwd_service UC密码修改
//jzqs_adapter_service 集中清算
//sfcg_adapter_service 三方
//uc_order_service UC订单服务
var regw = (function(){
    return function(namespace, fnId, key){
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function(reqs,log) {
            var request = {
                fytype: 'wfwcmd',
                funcid: fnId,
                servicename: namespace
            }
            request = extObject(request, wfwServices.setWfw(request.servicename)); //扩展详细服务URL
            request = extObject(request, {data:JSON.stringify(reqs)});
            
            return wrap(key, request, log)
        };
    }
}());

/*发送LTS 低延时环境 */
var reghLTS = (function() {
    return function(namespace, fnId, key) {
        exports[namespace] = exports[namespace] || {};
        exports[namespace][key] = function(reqs) {
            var request = {
                fytype: 'ltscmd',
                funcid: fnId,
                rtsname: 'ltscmd'
            };
            request = extObject(request, reqs);
            return wrap(key, request);
        };
    };
}());

var fql = exports;

