import React, { Component } from 'react';
import { Switch, Route } from 'react-router-dom';
import QuotationChart from 'pages/quotation-chart/View';
import FirmTradeIndex from 'pages/trade/FirmTradeIndex';
import FirmOrderIndex from 'pages/order/FirmOrderIndex';
import QueryIndex from 'pages/query/QueryIndex';
import QueryFirmTrade from 'pages/query/firmTrade/QueryFirmTrade';
import QueryFirmOrder from 'pages/query/firmOrder/QueryFirmOrder';
import QueryFirmTradeDetail from 'pages/query/firmTrade/QueryFirmTradeDetail';
import QueryFirmOrderDetail from 'pages/query/firmOrder/QueryFirmOrderDetail';
import QueryTradeList from 'pages/query/tradeListLog/QueryTradeList';
import QueryOrderList from 'pages/query/orderListLog/QueryOrderList';
import FilterSearch from 'components/FilterSearch/FilterSearch';
import CapitalAccountsDetail from 'pages/query/capitalAccounts/CapitalAccountsDetail';


class QuotesDetailRoute extends Component {
  componentDidMount() {

  }
  render() {
    return (
      <Switch>
        <Route path="/QuotationChart/:instrument/:pid" component={QuotationChart} />
        <Route path="/FirmTradeIndex/:pid" component={FirmTradeIndex} />
        <Route path="/FirmOrderIndex/:pid" component={FirmOrderIndex} />
        <Route path="/QueryIndex" component={QueryIndex} />
        <Route path="/QueryFirmTrade" component={QueryFirmTrade} />
        <Route path="/QueryFirmOrder" component={QueryFirmOrder} />
        <Route path="/QueryFirmTradeDetail" component={QueryFirmTradeDetail} />
        <Route path="/QueryFirmOrderDetail" component={QueryFirmOrderDetail} />
        <Route path="/QueryTradeList" component={QueryTradeList} />
        <Route path="/QueryOrderList" component={QueryOrderList} />
        <Route path="/FilterSearch" component={FilterSearch} />
        <Route path="/CapitalAccountsDetail" component={CapitalAccountsDetail} />
      </Switch>
    );
  }
}

export default QuotesDetailRoute;
