import React, { Component } from 'react';
import { connect } from 'react-redux';
import { HashRouter as Router } from 'react-router-dom';
import { Toast } from 'antd-mobile';
import { fetchQuotation, updateQuotation,fetchQuotationFY } from 'store/firmQuotationAction';
import { fetchLogin, nativeLogin, setUserInfo} from 'store/loginLogoutAction';
import ActionConfig from 'config/actionConfig.js';
import plusReady from 'plugins/plusReady';
import Webnet from 'utils/webnet.js';
import AppRouter from './AppRouter';
import { Storage } from 'storage';
import Ajax from 'ajax';
//富易PC
import interfaceList from '../dataFile/interfaceList.js';
import { getInterface, getLocalUserInfo, createInterface} from '../dataFile/interface.js';

class Main extends Component {
  constructor(props) {
    super(props);
    this.state = {
      paramsReady: true,
      failLoad: false,
      customerType: 'personal',
    };
  }
  componentWillReceiveProps (nextProps){
    if(nextProps.userInfo){
      const { dispatch } = this.props;
      // dispatch(fetchQuotationFY('firm', nextProps.userInfo));
    }
  }
  componentWillMount() {
    const { dispatch } = this.props;
    //-------------富易PC--------------//
    // dispatch(setUserInfo(dispatch));
    
  }
  componentDidMount() {
    const { dispatch } = this.props;
    // dispatch(fetchQuotation('firm', this.props.loginState));

    //-------------富易PC--------------//

    this.initInterface();  //初始化接口列表

    //-------------富易PC--------------//

    // this.queryCurrpairInfo();
    // this.nativeWebnet();
    // this.chromeWebnet();
    // this.registerBackEvent();
  }
  //------------富易PC-初始化接口列表--------------//
  initInterface(){
    var list = interfaceList.interfaceList;
    createInterface(list);
  }
  //------------富易PC-初始化接口列表--------------//
  chromeWebnet() {
    const self = this;
    const webnet = new Webnet();
    webnet.connectWebnet((spotArray) => {
      const { dispatch } = self.props;
      const obj = {
        data: {
          result: {
            datals: spotArray,
          },
        },
      };
      dispatch(updateQuotation('firm', obj));
    });
  }
  nativeWebnet() {
    const self = this;
    plusReady(() => {
      const webnetObj = new Webnet(['Interface.Fx.Price', 'P']);
      webnetObj.connect((spotArray) => {
        const { dispatch } = self.props;
        const obj = {
          data: {
            result: {
              datals: spotArray,
            },
          },
        };
        dispatch(updateQuotation('firm', obj));
      });
    });
  }
  queryCurrpairInfo() {
    const param = {
      CURRENCY_PAIR: '',
      INSTRUMENT_ID: Storage.getItem('customerType') === 'personal' ? 'FIRM_FOREX' : '1',
    };
    const ctype = this.state.customerType;
    const url = ActionConfig[ctype][0].queryCurrpairInfo;
    Ajax(url, param).then((res) => {
      if (res.success) {
        console.log(res);
      }
    });
  }
  registerBackEvent() {
    plusReady(() => {
      window.plus.OnBackPressPlugin && window.plus.OnBackPressPlugin.setBackPress(() => {
        Toast.hide();
        const hashArr = ['#/', '#/home'];
        const needDealBack = [
          '#/FirmTradeIndex',
          '#/FirmOrderIndex',
          '#/TransferAccounts',
          '#/quotationChart',
          '#/quotationSort',
          '#/QueryIndex',
          '#/QueryTradeList',
          '#/QueryOrderList',
          '#/CapitalAccountsToday',
        ];
        const windowHash = window.location.hash.split('/');
        const hash = `#/${windowHash[1]}`;
        if (hashArr.indexOf(hash) >= 0) {
          window.location.href = 'gtjanormal://goback';
        } else if (needDealBack.indexOf(hash) >= 0) {
          // 执行自定义返回事件
          window.backFunc && window.backFunc();
        } else {
          history.back();
        }
      });
    });
  }
  render() {
    // console.log(this.props);
    return (
      <Router>
        {this.state.paramsReady ?
          <AppRouter />
          :
          (this.state.failLoad ? <ReLoad /> : <ParamsNotReady />)
        }
      </Router>
    );
  }
}

const mapStateToProps = (state,ownProps) => {
  const { firmQuotation, loginLogout } = state;
  const selectedInstrument = 'firm';
  const { loginState, userInfo,priceObj } = loginLogout;
  const {
    isFetching,
    items: posts,
    priceObject,
  } = firmQuotation[selectedInstrument] || {
    isFetching: true,
    items: [],
    priceObject: {},
  };
  return {
    selectedInstrument,
    posts,
    priceObject,
    isFetching,
    loginState,
    userInfo,
    priceObj
  };
};

export default connect(mapStateToProps)(Main);
