import React, { Component } from 'react';
import { Switch, Route, Redirect } from 'react-router-dom';

import Menu from './../components/Menu/Menu' //pc富易左侧菜单
//-------------pc富易----------------//
import Index from 'pages/index/View'; //首页，挂单查询
import MarketTrends from 'pages/marketTrends/MarketTrends';//行情
import MarketTrade from 'pages/marketTrade/MarketTrade';//市场交易
import TransferAccountsPC from 'pages/transferAccountsPC/TransferAccounts';//转账
import QueryEntrust from 'pages/queryEntrust/QueryEntrust';//委托单查询
import QueryIndexPC from 'pages/queryPC/QueryIndex';
import QueryTradeListPC from 'pages/queryPC/tradeListLog/QueryTradeList';
import QueryOrderListPC from 'pages/queryPC/orderListLog/QueryOrderList';
import CapitalAccountsTodayPC from 'pages/queryPC/capitalAccountsToday/CapitalAccountsToday';
//-------------pc富易----------------//

import FirmQuotation from 'pages/quotation/View';
import QuotationChart from 'pages/quotation-chart/View';
import FirmTradeIndex from 'pages/trade/FirmTradeIndex';
import FirmOrderIndex from 'pages/order/FirmOrderIndex';
import Setting from 'pages/setting/Setting';
import ModifyPassword from 'pages/setting/ModifyPassword';
import EditInterestCode from 'pages/interestCode/EditInterestCode';
import QueryAccountAmt from 'pages/query-account/View';
import QueryIndex from 'pages/query/QueryIndex';
import QueryFirmTrade from 'pages/query/firmTrade/QueryFirmTrade';
import QueryFirmOrder from 'pages/query/firmOrder/QueryFirmOrder';
import QueryFirmTradeDetail from 'pages/query/firmTrade/QueryFirmTradeDetail';
import QueryFirmOrderDetail from 'pages/query/firmOrder/QueryFirmOrderDetail';
import QueryTradeList from 'pages/query/tradeListLog/QueryTradeList';
import QueryOrderList from 'pages/query/orderListLog/QueryOrderList';
import FilterSearch from 'components/FilterSearch/FilterSearch';
import TransferAccounts from 'pages/transferAccounts/TransferAccounts';
import DisClaimerText from 'pages/transferAccounts/DisclaimerText';
import CapitalAccountsToday from 'pages/query/capitalAccountsToday/CapitalAccountsToday';
import CapitalAccountsDetail from 'pages/query/capitalAccounts/CapitalAccountsDetail';

class HomeRoute extends Component {
  render() {
    return (
        <div>
            <Menu />
            <div className='list'>
                <Switch>
                    <Route path="/" exact component={Index} />
                    <Route path="/home" exact component={Index} />
                    <Route path='/markettrade' component={MarketTrade} />{/* 市场交易*/}
                    <Route path='/markettrends' component={MarketTrends} />{/* 市场交易*/}
                    <Route path='/queryentrust/:queryText' component={QueryEntrust} />{/* 委托单查询*/}
                    <Route path="/transferaccountsPC" component={TransferAccountsPC} />{/* 转账*/}
                    <Route path="/QueryIndexPC" component={QueryIndexPC} />{/* 历史查询*/}
                    <Route path="/QueryTradeListPC" component={QueryTradeListPC} /> {/* 当日交易*/}
                    <Route path="/QueryOrderListPC" component={QueryOrderListPC} />{/* 挂单查询*/}
                    <Route path="/CapitalAccountsTodayPC" component={CapitalAccountsTodayPC} />{/* 当日资金流水*/}

                    <Route path="/FirmQuotation" component={FirmQuotation} />
                    <Route path="/QuotationChart/:instrument/:pid" component={QuotationChart} />
                    <Route path="/FirmTradeIndex/:pid" component={FirmTradeIndex} />
                    <Route path="/FirmOrderIndex/:pid" component={FirmOrderIndex} />
                    <Route path="/Setting" component={Setting} />
                    <Route path="/ModifyPassword" component={ModifyPassword} />
                    <Route path="/EditInterestCode" component={EditInterestCode} />
                    <Route path="/QueryAccountAmt" component={QueryAccountAmt} />
                    <Route path="/QueryIndex" component={QueryIndex} />
                    <Route path="/QueryFirmTrade" component={QueryFirmTrade} />
                    <Route path="/QueryFirmOrder" component={QueryFirmOrder} />
                    <Route path="/QueryFirmTradeDetail" component={QueryFirmTradeDetail} />
                    <Route path="/QueryFirmOrderDetail" component={QueryFirmOrderDetail} />
                    <Route path="/QueryTradeList" component={QueryTradeList} />
                    <Route path="/QueryOrderList" component={QueryOrderList} />
                    <Route path="/FilterSearch" component={FilterSearch} />
                    <Route path="/TransferAccounts" component={TransferAccounts} />
                    <Route path="/DisClaimerText" component={DisClaimerText} />
                    <Route path="/CapitalAccountsToday" component={CapitalAccountsToday} />
                    <Route path="/CapitalAccountsDetail" component={CapitalAccountsDetail} />
                    <Redirect to="/" />
                </Switch>
            </div>
        </div>
    );
  }
}

export default HomeRoute;
