import React, { Component } from 'react';
import queryString from 'query-string';
import { withRouter } from 'react-router-dom';
import HomeRoute from './HomeRoute';
import QuotesDetailRoute from './QuotesDetailRoute';
import QuotesSortRoute from './QuotesSortRoute';
import NoDataRoute from './NoDataRoute';
import entryFromNative from './entryFromNative.js';
import HorizontalChartRoute from './HorizontalChartRoute';
import SingleViewIndex from 'pages/singleView/SingleViewIndex';

class AppRouter extends Component {
  componentDidMount() {
    const { history } = this.props;
    let parsed = queryString.parse(location.search);
    let pathname = parsed.pageId;
    sessionStorage.setItem('forexPageId', pathname);
    if (parsed.productId && parsed.instrument) {
      pathname += `/${parsed.instrument}/${parsed.productId}`;
    }
    history.replace({
      pathname,
    });
  }

  queryCurrpairInfo() {
    const param = {
      CURRENCY_PAIR: '',
      INSTRUMENT_ID: 'FIRM_FOREX',
    };
    const url = ActionConfig[Storage.getItem('customerType')][0].queryCurrpairInfo;
    Ajax(url, param).then((res) => {
      if (res.success) {
        console.error(res);
      }
    });
  }

  render() {
    let navRoute;
    const parsed = queryString.parse(location.search);
    const page = entryFromNative[parsed.pageId];
    const { history } = this.props;
    switch (page) {
      case 0:
        navRoute = <HomeRoute history={history} />;
        break;
      case 1:
        navRoute = <QuotesDetailRoute history={history} />;
        break;
      case 2:
        navRoute = <QuotesSortRoute history={history} />;
        break;
      case 3:
        navRoute = <HorizontalChartRoute history={history} />;
        break;
      case 4:
        navRoute = <SingleViewIndex history={history} />;
        break;
      default:
        navRoute = <HomeRoute history={history} />;
        break;
    }
    return navRoute;
  }
}

export default withRouter(AppRouter);
