import React, { Component } from 'react';
import { connect } from 'react-redux';
import Tool from 'components/Tool/Tool';
import OrderTabel from 'components/Tabel/Tabel';
import { Radio,DatePicker,Select,Checkbox,Modal,Icon} from 'antd';
import moment from 'moment';
import 'moment/locale/zh-cn';
import keyboard from 'style/images/keyboard.png';
import { requestInterface } from 'utils/dom.js';
import commonTool from 'utils/commonTool.js';
import SelectOption from 'components/selectOption/selectOption';
import $ from  'jquery';

moment.locale('zh-cn');
const RadioGroup = Radio.Group;

import './view.scss';

class TransferAccounts extends Component {
  constructor(props) {
    super(props);
    const edate = new Date(new Date() - 86400000);
    const sdate = new Date(new Date() - (86400000 * 30));
    this.state = {
      account: '0123456789123456', //付款账户
      accountNumber: '美元',       //转出币种数组
      currencyValue: 1,            //转出币种默认勾选值
      currency: 'USD',             //币种单位
      tradeAccountBalance: '',       //可取资金
      currArray:[],                        //银行卡币种
      bankCardsList: {},           //银行卡列表
      transferValue:'',            //转账金额
      poundageTotal:'',            //转账费用
      disclaimerFlag:false,         //是否展示免责声明
      checkFlag: false,            //是否勾选已阅读免责声明
      passwordPanel:false,         //密码软键盘是否展示
      passwordValue:'',            //交易密码数据
      userInfo:'',
      accountType: '',            //资金类型
      beginDate:new Date(sdate),               //开始日期
      endDate:edate,                 //结束日期

      productIdIndex:false,       //货币对标识
      tradeTypeIndex:false,       //交易类型标识
      tradeStateIndex:false,      //交易状态标识
      orderStatusIndex:false,     //挂单状态标识
      accountTypeIndex:true,     //资金类型标识
      timeSelectFlag:false,   // 是否展示时间选择标识
      queryResultNum:'',     //查询结果条数
      queryResultArr:[],     //查询结果数组
      loading:false,          //加载中
      noResult:false,        //无搜索结果
      tableHeight:window.innerHeight-28-29-31-20,//表单高度:title,date,th,margin
    };
    this.startCount=1;          //起始查询条数
    this.queryCount=200;        //每次查询条数
    //银行卡币种
    this.currArray = [];       
    //银行卡列表     
    this.bankCardsList = {};
    //账户余额列表数组
    this.tradeAccountList=[];
    
    //软键盘数组
    this.randomNum = [0,1,2,3,4,5,6,7,8,9,'退格','删除'];
    //查询表盘
    this.orderTable = ['资金账号','资金类型','账号货币','金额','操作时间','清算日期'];
    this.teReg1 = /^(([1-9]\d*)|0)(\.\d{0,2}?)?$/;
    this.teReg2 = /^(([1-9]\d*)|0)?$/;

    //表单事件绑定this
    this.changeTransferValue = this.changeTransferValue.bind(this);
    this.checkCurrency = this.checkCurrency.bind(this);
  }
  componentWillReceiveProps (nextProps) {
    let userInfo = nextProps.userInfo;
    if(userInfo && nextProps.priceObj){
      this.bankCardsQuery(userInfo);
      this.queryAccount(userInfo);
      //查询前，将其实查询条数置为0 ,查询数组置为空
      this.startCount = 1;
      this.setState({queryResultArr:[]});
      this.CapitalAccountsToday(userInfo);
    }
  }
  componentWillMount(){
    let userInfo = this.props.userInfo;
    if(userInfo && this.props.priceObj){
      this.bankCardsQuery(userInfo);
      this.queryAccount(userInfo);
      //查询前，将其实查询条数置为0 ,查询数组置为空
      this.startCount = 1;
      this.setState({queryResultArr:[]});
      this.CapitalAccountsToday(userInfo);
    }
    window.addEventListener('scroll', this.onScrollHasmore.bind(this),true);
  }
  componentDidMount(){
    //打乱0-9的顺序
    this.randomNum = this.shuffle(this.randomNum);
    //查询菜单点击
    // $('.order-list .title span').click(function(){
    //   if($(this).index() < $('.order-list .title span').length-1 ){
    //     $('.order-list .title').find('.orders-type').removeClass('orders-type');
    //     $(this).addClass('orders-type');
    //   }
    // })
  }
  //滚动下拉加载
  onScrollHasmore(event) {
    const clientHeight = event.target.clientHeight;
    const scrollHeight = event.target.scrollHeight;
    const scrollTop = event.target.scrollTop;
    if(clientHeight + scrollTop === scrollHeight){
      if(this.startCount+this.queryCount-1 < this.state.queryResultNum){
        this.setState({
          loading:true,          //加载中
          noResult:false,        //无搜索结果
          tableHeight:window.innerHeight-28-29-31-20-30,//title,date,th,margin,loadingmore
        })
        this.startCount = this.startCount+this.queryCount;
        this.CapitalAccountsToday(this.props.userInfo);
      } 
    }
  }
  //-------------------接口调取-----------------------//
  //银行卡列表查询
  bankCardsQuery(userInfo){
    var reqInfo = {
      name:'银行卡列表查询',
      data:{
        inparam:{ 
                  'param.CUSTOMER_ID':'#{{longCustId}}',
                  'param.TRADE_ACCOUNT':userInfo.longBusiId,
                  'terminalinfo': '[terminalinfo]',
                }
      }
    };
    let _this = this;    
    requestInterface(reqInfo,userInfo).then(function(res){
      if(res.RNUM == '1'){
        let resList = res.list[0].outparam;
        resList = JSON.parse(resList);
        if(resList.success){
          let currArray = [];//-----------------------------
          resList.data.result.datals.map((i, index) => {
              i.currency = i.BANKCARD_CURRENCYS;
              currArray.unshift(_this.transEngToChin(i.currency));
              _this.bankCardsList[i.currency] = i;
            });
            // console.log(_this.bankCardsList);
          _this.setState({
            currArray: currArray,
            bankCardsList:_this.bankCardsList,
          });
        }else{
          //数据返回异常
          console.log(commonTool.transformErrMsg(resList.message));
          Modal.warning({
            okText:'知道了',
            title: '接口返回错误',
            content: commonTool.transformErrMsg(resList.message)
          });
        }
      }else{
        //接口错误
        let resList = res.list[0];
        Modal.warning({
          okText:'知道了',
          title: '接口返回错误',
          content: resList.ERRMSG
        });
      }
      
    });
  }
  //账户余额查询
  queryAccount(userInfo){
    var reqInfo = {
      name:'资金账号余额查询',
      data:{
        inparam:{ 
                  'param.CUSTOMER_ID':'#{{longCustId}}',
                  'param.TRADE_ACCOUNT':userInfo.longBusiId,
                  "param.BOOKING_ID":"ENT00002",
                  'terminalinfo': '[terminalinfo]',
                }
      }
    };
    let _this = this;
    requestInterface(reqInfo,userInfo).then(function(res){
      if(res.RNUM == '1'){
        let resList = res.list[0].outparam;
        resList = JSON.parse(resList);
        if(resList.success){
          let tradeAccountList = resList.data.result.datals;
          _this.tradeAccountList = tradeAccountList;
          // console.log(tradeAccountList);
          let currencyAccount;
          tradeAccountList && tradeAccountList.map((i, index) => {
            if (i.CURRENCY === _this.state.currency) {
              currencyAccount = i;
            }
          });
          // console.log(currencyAccount);
          _this.setState({ tradeAccountBalance: currencyAccount.EXTRACT_AMT });
        }else{
          //数据返回异常
          Modal.warning({
            okText:'知道了',
            title: '接口返回错误',
            content: commonTool.transformErrMsg(resList.message)
          });
        }
      }else{
        //接口错误
        let resList = res.list[0];
        Modal.warning({
          okText:'知道了',
          title: '接口返回错误',
          content: resList.ERRMSG
        });
      }
      
    });
  }
  //转账费用查询
  caculateCharge(userInfo,transferValue){
    var reqInfo = {
      name:'手续费查询接口',
      data:{
        inparam:{ 
                  'param.CUSTOMER_ID':'#{{longCustId}}',
                  'param.CUSTOMER_TYPE':'0',   //客户类型均按个人用户来处理
                  'param.FUND_ACCOUNT': transferValue,
                  'param.FUND_CURRENCY': this.state.currency,
                  'param.SCENE': '2',
                  'terminalinfo': '[terminalinfo]',
                }
      }
    };
    console.log(transferValue,this.state.currency);
    let _this = this;
    requestInterface(reqInfo,userInfo).then(function(res){
      if(res.RNUM == '1'){
        let resList = res.list[0].outparam;
        resList = JSON.parse(resList);
        if(resList.success){
          //数据返回正常
          console.log('查询成功！',resList);
          _this.setState({ poundageTotal: resList.data.result.POUNDAGE_TOTAL });
        }else{
          //数据返回异常
          Modal.warning({
            okText:'知道了',
            title: '接口返回错误',
            content: commonTool.transformErrMsg(resList.message)
          });
        }
      }else{
        //接口错误
        let resList = res.list[0];
        Modal.warning({
          okText:'知道了',
          title: '接口返回错误',
          content: resList.ERRMSG
        });
      }
      
    });
  }
  //转账
  ajaxTransferAccount(userInfo){
    var shajs = require('sha.js');
    var reqInfo = {
      name:'出金',
      data:{
        inparam:{ 
                  'param.CUSTOMER_ID':'#{{longCustId}}',
                  'param.TRADE_ACCOUNT':userInfo.longBusiId,
                  'param.TRADE_AMT': this.state.transferValue,                          //转出资金金额
                  'param.CURRENCY_INFO': `${this.state.currency}:2`,              //资金账号币种信息,格式：GBP:2 
                  'param.BANK_CARD': this.state.bankCardsList[this.state.currency].BANKCAR_CODE, //出金银行卡号
                  'param.TRANSFER_PWD': shajs('sha512').update(this.state.passwordValue).digest('hex'),                   //资金账号转账密码
                  'param.FEE': this.state.poundageTotal,                          //预计手续费
                  'terminalinfo': '[terminalinfo]',
                }
      }
    };
    let _this = this;
    requestInterface(reqInfo,userInfo).then(function(res){
      if(res.RNUM == '1'){
        let resList = res.list[0].outparam;
        console.log(resList);
        resList = JSON.parse(resList);
        if(resList.success){
          //数据返回正常
          console.log('查询成功！',resList);
          Modal.success({
            okText:'知道了',
            title: '转账成功',
            content: '本次转账已成功转出！',
            onOk() {window.location.reload()},
          });
          // window.location.reload();
        }else{
          //数据返回异常
          Modal.warning({
            okText:'知道了',
            title: '接口返回错误',
            content: commonTool.transformErrMsg(resList.message)
          });
        }
      }else{
        //接口错误
        let resList = res.list[0];
        Modal.warning({
          okText:'知道了',
          title: '接口返回错误',
          content: resList.ERRMSG
        });
      }
      
    });
  }
  //当日资金流水查询
  CapitalAccountsToday(userInfo){
    const self = this;
    const beginDate = self.dateFormat(this.state.beginDate, 'yyyy-mm-dd');
    const endDate = self.dateFormat(this.state.endDate, 'yyyy-mm-dd');
    var reqInfo = {
      name:'资金账号流水当日查询',
      data:{
        inparam:{
          'param.CUSTOMER_ID':'#{{longCustId}}',
          'param.TRADE_ACCOUNT':userInfo.longBusiId,
          "param.BOOKING_ID":"ENT00002",
          'param.ACCOUNT_TYPE': this.state.accountType,  //资金类型
          'param.QUERY_COUNT': this.queryCount,
          'param.START_COUNT': this.startCount,
          'param.START_DATE': commonTool.getFormateDate().replace(/-/g, '') * 1,
          'param.END_DATE': commonTool.getFormateDate().replace(/-/g, '') * 1,
          'terminalinfo': '[terminalinfo]',
        }
      }
    };
    self.setState({loading:true})//-------------------------
    requestInterface(reqInfo,userInfo).then(function(res){
      if(res.RNUM !== '-1'){
        console.log(res);
        let resData=''
        res.list.map((item,index)=>{
          resData+=item.outparam;
        })
        resData = JSON.parse(resData);
        console.log(resData);
        if(resData.success){
          //数据返回有结果
          if(resData.data.result.total>0){ //搜索总结果多于0
            let queryResultArr=[];
            if(resData.data.result.datals.length>0){//本次搜索结果
              resData.data.result.datals.map((item,index)=>{
                let dataItem=[];
                dataItem=[
                        item.TRADE_ACCOUNT,                                           //资金账号
                        commonTool.transAccountTypeToChinese(item.ACCOUNT_IN_TYPE),   //资金类型
                        item.CURRENCY,                                                //币种
                        commonTool.formatFloatAmount(item.AMOUNT, (item.CURRENCY === 'JPY' ? 0 : 2)), //金额
                        commonTool.formatDate(item.TRADE_DATE) +' ' +commonTool.formatTime(item.TRADE_TIME),//操作时间
                        commonTool.formatDate(item.CLEAR_DATE),                                             //清算日期
                      ];
                queryResultArr.push(dataItem);
              })
              queryResultArr = self.state.queryResultArr.concat(queryResultArr);
              self.setState({
                queryResultNum:resData.data.result.total,
                queryResultArr:queryResultArr,
                loading:false,
                noResult:false,
              });
            }
          }else{
            self.setState({
              queryResultNum:resData.data.result.total,
              queryResultArr:[],
              loading:false,
              noResult:true,
            });
          }
        }
        else{
          //数据返回异常
          //console.log(commonTool.transformErrMsg(resData.message));
          self.setState({//-------------------------------
            queryResultNum:0,
            queryResultArr:[],
            loading:false,
            noResult:true
          })
          Modal.warning({
            okText:'知道了',
            title: '接口返回错误',
            content: commonTool.transformErrMsg(resData.message)
          });
        }
      }else{
        //接口错误
        self.setState({
          queryResultNum:0,
          queryResultArr:[],
          loading:false,
          noResult:true
        })
        let resList = res.list[0];
        Modal.warning({
          okText:'知道了',
          title: '接口返回错误',
          content: resList.ERRMSG
        });
      }  
    });
  }
  //-------------------接口调取-----------------------//

  //-------------------转账功能函数-----------------------//
  //转出币种checkbox
  checkCurrency(e){
    let checkedCurrency = this.currArray[e.target.value-1];//根据checkbox所选值取到转出币种中文名
    let transferValueInput = this.refs.transferValueInp;
    transferValueInput.value = '';
    this.setState({
      currencyValue:e.target.value,//更换checkbox所选项
      currency:this.transChinToEng(checkedCurrency),//将转出币种中文名转化为英文名，然后刷新币种单位状态
      transferValue: transferValueInput.value,      //转账金额置为空
      poundageTotal:'',                             // 转账费用置为空
    })
    //更换该币种下账户余额
    let currencyAccount;
    this.tradeAccountList && this.tradeAccountList.map((i, index) => {
      if (i.CURRENCY === this.transChinToEng(checkedCurrency)) {
        currencyAccount = i;
      }
    });
    this.setState({ tradeAccountBalance: currencyAccount.EXTRACT_AMT });
  }
  //全部转出
  transferAll(){
    let transferValueInput = this.refs.transferValueInp;
    transferValueInput.value = this.state.tradeAccountBalance;
    //修改转账金额输入框数额
    this.setState({transferValue: transferValueInput.value});
    //计算转账金额
    this.caculateCharge(this.props.userInfo,this.state.tradeAccountBalance);
  }
  //修改转出金额
  changeTransferValue(event){
    var inAmount = event.target.value;
    event.target.value = inAmount.replace('\\.(\\d?)\\.+', '$1');
    const reg =  this.teReg1 ;
    if (/^0[1-9]$/.test(inAmount)) {
      inAmount = Number(inAmount);
    }
    if (inAmount && !reg.test(inAmount)) {
      if (inAmount === '.') {
        inAmount = '0.';
        console.log(inAmount);
      } else {
        inAmount = this.state.transferValue;
      }
    }
    this.setState({transferValue: inAmount});
  }
  //转出金额输入框失去焦点时
  caculateChargeBlur(event){
    console.log(event.target.value);
    this.setState({transferValue: event.target.value});
    //计算转账费用
    if(event.target.value){
      this.caculateCharge(this.props.userInfo,event.target.value);
    }
  }
  //免责声明点击
  readDisclaimer(e){
    e.stopPropagation();
    let disclaimerFlag = this.state.disclaimerFlag;
    if(!disclaimerFlag){
      this.setState({
        disclaimerFlag:!disclaimerFlag,
      })
    }
  }
  //关闭免责声明提示框
  hasRead(){
    this.setState({
      disclaimerFlag:false,
    })
  }
  //是否已阅免责声明
  changeCheck(){
    if(!this.state.disclaimerFlag){
      let checkFlag = this.state.checkFlag;
      this.setState({
        checkFlag:!checkFlag,
      })
    }
  }
  
  //币种英文转化为中文
  transEngToChin(chi) {
    let str;
    switch (chi) {
      case 'USD':
        str = '美元';
        break;
      case 'HKD':
        str = '港币';
        break;
      case 'EUR':
        str = '欧元';
        break;
      case 'JPY':
        str = '日元';
        break;
      case 'GBP':
        str = '英镑';
        break;
      case 'AUD':
        str = '澳大利亚元';
        break;
      case 'CHF':
        str = '瑞士法郎';
        break;
      default:
        str = '';
        break;
    }
    return str;
  }
  //币种中文转化为英文
  transChinToEng(chi) {
    let str;
    switch (chi) {
      case '美元':
        str = 'USD';
        break;
      case '港币':
        str = 'HKD';
        break;
      case '欧元':
        str = 'EUR';
        break;
      case '日元':
        str = 'JPY';
        break;
      case '英镑':
        str = 'GBP';
        break;
      case '澳大利亚元':
        str = 'AUD';
        break;
      case '瑞士法郎':
        str = 'CHF';
        break;
      default:
        str = '';
        break;
    }
    return str;
  }
  
  //---------密码盘------------//
  //点击键盘图标
  openDispanel(){
    let passwordPanel = this.state.passwordPanel;
    if(!passwordPanel){
      //打乱0-9的顺序
      this.randomNum = this.shuffle(this.randomNum);
    }
    this.setState({
      passwordPanel:!passwordPanel,
    })
  }
  //点击关闭按钮
  closePanel(){
    this.setState({
      passwordPanel:false,
    })
  }
  //软键盘十位数字顺序随意
  shuffle(arr) {
    var length = arr.length-2,
      randomIndex,
      temp;
    while (length) {
      randomIndex = Math.floor(Math.random() * (length--));
      temp = arr[randomIndex];
      arr[randomIndex] = arr[length];
      arr[length] = temp
    }
    return arr;
  }
  //通过软键盘的点击，自动显示软键盘中输入框的密码
  getPassWord(v,index){
    if(this.state.passwordPanel){
      let passwordIpt = this.refs.passwordIpt;
      if(index < 10){
        passwordIpt.value = passwordIpt.value + v;
      }
      if(index == 10){
        let value = passwordIpt.value;
        passwordIpt.value =  value.substring(0, value.length-1);
      }
      if(index == 11){
        passwordIpt.value = '';
      }
    }
  }

  //软键盘关闭后显示最后的密码
  getFinalPassword(){
    let passwordIpt = this.refs.passwordIpt;
    let finalPassword = this.refs.finalPassword;
    finalPassword.value = passwordIpt.value;
    this.setState({
      passwordPanel:false,
      passwordValue:finalPassword.value,
    });
  }
  //密码输入框
  passwordValue(event){
    this.setState({passwordValue: event.target.value});
    console.log(event.target.value);
  }
  //转账确认提交
  doTransferAccount(){
    if(!this.state.bankCardsList[this.state.currency]){
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '您还未填写银行账户信息，需临柜补充后方可申请资金转出！'
      });
      return false;
    }
    if (!this.state.currency) {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '请选择转出币种！'
      });
      return false;
    }
    if (this.state.transferValue == '') {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '转账金额不能为空！'
      });
      return false;
    }
    if (this.state.transferValue === '0') {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '转账金额不能为零！'
      });
      return false;
    }
    if ((this.state.tradeAccountBalance * 1) < this.state.transferValue) {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '您的余额不足，无法出金！'
      });
      return false;
    }
    if (this.state.passwordValue == '') {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '请输入交易密码，才能继续交易！'
      });
      return false;
    }
    if (!this.state.checkFlag) {
      Modal.warning({
        okText:'知道了',
        title: '信息填写不完整',
        content: '您还未同意国泰君安转账费用相关说明！'
      });
      return false;
    }
    
    //进行转账
    this.ajaxTransferAccount(this.props.userInfo);
  }
  //-------------------转账功能函数-----------------------//
  //-------------------查询函数-----------------------//
  dateFormat(date, fmt) {
    const o = {
      'm+': date.getMonth() + 1,
      'd+': date.getDate(),
      'h+': date.getHours(),
      'i+': date.getMinutes(),
      's+': date.getSeconds(),
      'q+': Math.floor((date.getMonth() + 3) / 3),
      // 't': date.getMilliseconds(),
    };
    if (/(y+)/.test(fmt)) {
      fmt = fmt.replace(RegExp.$1, (date.getFullYear().toString()).substr(4 - RegExp.$1.length));
    }
    for (const k in o) {
      if (new RegExp(`(${k})`).test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : ((`00${o[k]}`).substr((`${o[k]}`).length)));
      }
    }
    return fmt;
  }
  okBtnHandle(filterObj) {
    console.log(filterObj);
    this.setState({
      beginDate:filterObj.beginDate,            //开始日期
      endDate:filterObj.endDate,                //结束日期
      accountType: filterObj.accountTypeValue,       //资金类型选择框值
    },() => {
      this.startCount = 1;
      this.setState({queryResultArr:[]});
      this.CapitalAccountsToday(this.props.userInfo);
    });
    // this.conditionChangeQuery();
    
  }
  render() {
    let {account, currency,currArray, bankCardsList, poundageTotal, tradeAccountBalance,disclaimerFlag,passwordPanel,queryResultNum,queryResultArr,loading,noResult} = this.state;
    let {productIdIndex,tradeTypeIndex,tradeStateIndex,orderStatusIndex,accountTypeIndex,timeSelectFlag} = this.state;
    return (
      <div className="transfer-accounts">
        {/* <Menu checked='4'></Menu> */}
        <aside className='aside'>
          <ul>
            <li className='title'>
              转出
            </li>
            <li>
              <span>付款账户</span>
              <div>
                <span className='fright'>{this.props.userInfo?this.props.userInfo.longBusiId:account}</span>
              </div>
            </li>
            <li>
              <span>转出币种</span>
              <div>
                <RadioGroup size='small' onChange={this.checkCurrency} value={this.state.currencyValue}>
                  {currArray.map((v,index)=>
                    <Radio value={parseInt(index)+1} key={index}>{v}</Radio>
                  )}
                </RadioGroup>
              </div>
            </li>
            <li>
              <span>银行账号</span>
              <div><span className='fright'>{bankCardsList[currency] && this.bankCardsList[this.state.currency].BANKCAR_CODE}</span></div>
            </li>
            <li>
              <span>可取资金</span>
              <div>
                <p className='fright'><i>{tradeAccountBalance}</i> {currency}</p>
              </div>
            </li>
            <li>
              <span>转出金额</span>
              <div>
                  <input ref='transferValueInp' type='number' min="0" step="0.01" value={this.state.transferValue}  onChange={this.changeTransferValue} onBlur={this.caculateChargeBlur.bind(this)}/> 
                  <div className='fright' onClick={() => this.transferAll()} >全部转出</div>                   
              </div>
            </li>
            <li>
              <span>转账费用</span>
              <div>
                <p className='fright'><i>{poundageTotal}</i> {currency}</p>
              </div>
            </li>
            <li>
              <span>交易密码</span>
              <div className="passwordContainer">
                <input ref="finalPassword"  type='password' onBlur={this.passwordValue.bind(this)}/>
                <img src={keyboard} onClick={()=>this.openDispanel()} />
                {passwordPanel
                  ?<div className="keyboardContainer">
                      <div className="header">输入密码
                        <Icon type="close" style={{ paddingLeft: '80px', color: '#C0C0C0' }} onClick={()=>this.closePanel()} />
                      </div>
                      <div className="box">
                        <input type="password" ref="passwordIpt" value=""/>
                        <div className="panel">
                          {this.randomNum.map((v,index)=>
                            <div className={"panelBtn"+(index%3 == 2?" hasBorder":'')} key={index} onClick={this.getPassWord.bind(this,v,parseInt(index))} >{v}</div>
                          )}
                        </div>
                      </div>
                      <div className="footer">
                        <div className="btn close" onClick={()=>this.closePanel()}>关闭</div>
                        <div className="btn confirm" onClick={()=>this.getFinalPassword()}>确认</div>
                      </div>
                    </div>
                  :''
                }
              </div>
            </li>
            <li>
              <Checkbox checked={this.state.checkFlag} onClick={()=> this.changeCheck()}>我已阅读并同意<a onClick={(e) => this.readDisclaimer(e)}>《国泰君安出入金免责声明》</a></Checkbox>
            </li>            
            <li>
              <span className='confirmbtn' onClick={()=> this.doTransferAccount()}>提交</span>
            </li>
          </ul>
        </aside>
        <div className='order-list'>
          <div className='right-top'>
            {/* <p className='title'>
              <span className='orders-type'>当日资金流水查询</span>
              <span className='queryResult'>查询结果: 共[{queryResultNum}]笔 记录</span>     
            </p> */}
            <Tool refresh={()=>this.setState({queryResultArr:[]},this.CapitalAccountsToday(this.props.userInfo))} data={queryResultArr} title='当日资金流水查询' list = {this.orderTable} userInfo={this.props.userInfo} queryResultNum={queryResultNum}/>         
            <div className='choose'>
              <SelectOption okBtnHandle={this.okBtnHandle.bind(this)} selectIndexArr = {[productIdIndex,tradeTypeIndex,tradeStateIndex,orderStatusIndex,accountTypeIndex,timeSelectFlag]}></SelectOption> 
            </div>
          </div>
          <OrderTabel list = {this.orderTable} data={queryResultArr} loading={loading} noResult={noResult} height={this.state.tableHeight}></OrderTabel>
        </div>
        <div className={"alertBg " +(disclaimerFlag ? '':'none')}></div>
        <div className={"disclaimer " +(disclaimerFlag ? '':'none')}>
          <div className="disclaimer-content">
            <h3>尊敬的客户：</h3>
            <p>
                &emsp;一、请您知晓您申请转出的金额需扣减国泰君安的转账费用（费用标准详见公司网站）及收款银行所收取的相关费用，实际到账金额可能小于您申请转出的金额。申请转账时，请您仔细核对收款账号、户名及开户行等信息，如因账号信息有误等原因造成转账失败，由此产生的费用和相应后果由您自行承担。
            </p>
            <p>
                &emsp;二、外币划转到账时间存在一定不确定性，具体到账时间以收款银行收到外币转账资金为准。
            </p>
            <div className="readBtn" onClick={()=>this.hasRead()}>我知道了</div>
          </div>
        </div> 
      </div>
    );
  }
}
const mapStateToProps = (state,ownProps) => {
  const { loginLogout } = state;
  return {
    loginState: loginLogout.loginState,
    userInfo: loginLogout.userInfo,
    priceObj:loginLogout.priceObj,
  };
};
export default connect(mapStateToProps)(TransferAccounts);
