/**
 * 用于嵌入君弘行情模块下
 */

import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { fetchQuotation } from 'store/firmQuotationAction';
import commonTool from 'utils/commonTool.js';
import PriceFormat from 'components/PriceFormat/PriceFormat';
import FirmQuotation from 'pages/quotation/View';
import { Storage } from 'storage';
import singleUpImg from 'style/iconImage/singleUp.png';
import singleDownImg from 'style/iconImage/singleDown.png';
import singleMoreImg from 'style/iconImage/singleMore.png';
import style from './view.scss';


class SingleViewIndex extends Component {
  constructor(props) {
    super(props);
    console.log(this.props);
    this.state = {
      priceExtendsFlag: true,
    };
    this.handleExtendsFlag = this.handleExtendsFlag.bind(this);
    const eraytRateCode = Storage.getItem('eraytRateCode', true);
    this.interestCode = eraytRateCode && eraytRateCode.interestCode ? eraytRateCode.interestCode : '';
    window.addEventListener('storage', () => {
      const eraytRateCode = Storage.getItem('eraytRateCode', true);
      const interestCode = eraytRateCode && eraytRateCode.interestCode ? eraytRateCode.interestCode : '';
      if (this.interestCode !== interestCode) {
        this.interestCode = interestCode;
        this.forceUpdate();
      }
    });
  }
  handleExtendsFlag() {
    this.setState({
      priceExtendsFlag: !this.state.priceExtendsFlag,
    });
  }
  // 经过君弘跳转至另外一个webview的详情页面
  toQuotationChart(pid) {
    commonTool.gtjaBurialPoint('138001');
    window.location.href = `gtjayyz://jumpfunc?funid=30046&pageId=quotationChart&instrument=firm&productId=${pid}`;
  }
  // 经过君弘跳转至另外一个webview的排序页面
  toQuotationSort() {
    window.location.href = 'gtjayyz://jumpfunc?funid=30046&pageId=quotationSort';
  }
  render() {
    const ratecode = Storage.getItem('eraytRateCode', true) != null ? Storage.getItem('eraytRateCode', true).interestCode.split(',') : Object.keys(this.props.priceObject);
    const ratecodeObj = [];
    for (const i in ratecode) {
      if (ratecode.hasOwnProperty(i)) {
        const productId = ratecode[i];
        this.props.priceObject[productId] && ratecodeObj.push(this.props.priceObject[productId]);
      }
    }
    const instrestArr = ratecodeObj.length > 0 ? ratecodeObj : this.props.posts;
    return (
      <div id="SingleViewIndex">
        <div to="/FirmQuotation" className="extend-header">
          {this.state.priceExtendsFlag === true ?
            <img onClick={this.handleExtendsFlag} src={singleUpImg} alt="" /> :
            <img onClick={this.handleExtendsFlag} src={singleDownImg} alt="" />
          }
          <label>外汇买卖</label>
          <img className="more-icon" src={singleMoreImg} onClick={this.toQuotationSort.bind(this)} alt="" />
        </div>
        {this.state.priceExtendsFlag === true ?
          <ul id="PriceList" className="price-list">
            {instrestArr.map((post, i) =>
              (
                <div>
                  {post.PRICE_SHOW_STATE === '1' && <li key={post.CURRENCY_PAIR} className="li-border">
                    <div onClick={this.toQuotationChart.bind(this, post.productIdWithoutSlash)}>
                      <div className="coin-cp">
                        <span className="chineseName">{commonTool.formateLanguage(post.CURRENCY_PAIR)}</span>
                        <span className="englishName">{post.CURRENCY_PAIR}</span>
                        {/* <TimeFormat time={post.PRICE_TIME} /> */}
                      </div>
                      <div className={commonTool.priceColorByStatus(post, 'sell')}>
                        <span className="big">{post.MID_RATE}</span>
                      </div>
                      <div className={commonTool.priceColorByStatus(post, 'buy')}>
                        <span className="big">{post.PREC}%</span>
                      </div>
                    </div>
                  </li>}
                </div>
              ))
            }
          </ul>
          : ''}
      </div>
    );
  }
}

const mapStateToProps = (state) => {
  console.log(state);
  const { firmQuotation } = state;
  const selectedInstrument = 'firm';
  const {
    isFetching,
    items: posts,
    priceObject,
  } = firmQuotation[selectedInstrument] || {
    isFetching: true,
    items: [],
    priceObject: {},
  };
  return {
    selectedInstrument,
    posts,
    priceObject,
    isFetching,
  };
};

export default withRouter(connect(mapStateToProps)(SingleViewIndex));
