import React, { Component } from 'react';
import { Router, Route, Link } from 'react-router-dom';
import Header from 'components/Header/Header';
import commonTool from 'utils/commonTool.js';
import { Button, Icon } from 'antd-mobile';
import { Storage } from 'storage';
import style from './view.scss';

export default class Setting extends Component {
  constructor(props) {
    super(props);
    this.state = {
      curLanguage: Storage.getItem('languageType') || '1',
    };
  }
  handleLanguage(type) {
    this.setState({
      curLanguage: type,
    }, this.storageLanguageType);
  }
  storageLanguageType() {
    Storage.setItem('languageType', this.state.curLanguage);
  }
  render() {
    return (
      <div id="Setting">
        <Header>设置</Header>
        <ul>
          <li onClick={() => {
            commonTool.gtjaBurialPoint('293030');
          }}
          >
            <Link to={{
              pathname: '/ModifyPassword',
              state: '登录密码',
            }}
            >
            修改登录密码  <Icon type="right" color="#dddddd" size="md" />
            </Link>
          </li>
          <li onClick={() => {
            commonTool.gtjaBurialPoint('293031');
          }}
          >
            <Link to={{
              pathname: '/ModifyPassword',
              state: '资金密码',
            }}
            >
            修改资金密码  <Icon type="right" color="#dddddd" size="md" />
            </Link>
          </li>
          {/* <li>产品名称中英文切换
            <Button className={this.state.curLanguage !== '1' ? 'language-inactive' : ''} type="primary" size="small" inline onClick={this.handleLanguage.bind(this, '1')}>英文</Button>
            <Button className={this.state.curLanguage !== '0' ? 'language-inactive' : ''} type="primary" size="small" inline onClick={this.handleLanguage.bind(this, '0')}>中文</Button>
          </li> */}
        </ul>
      </div>
    );
  }
}
