import React, { Component } from 'react';
import { Router, Route, Link } from 'react-router-dom';
import commonTool from 'utils/commonTool.js';
import PwdKeyboard from './PwdKeyboard';
import ModalDiaLog from 'components/ModalDiaLog/ModalDiaLog';
import Header from 'components/Header/Header';
import ActionConfig from 'config/actionConfig.js';
import Ajax from 'ajax';
import errorMsg from 'config/errorConfig.js';
import { Button, Toast } from 'antd-mobile';
import { Storage } from 'storage';
import style from './view.scss';

let pwd1;
let pwd2;
let pwd3;
let pwd1Str;
let pwd2Str;
let pwd3Str;
export default class ModifyPassword extends Component {
  constructor(props) {
    super(props);
    this.state = {
      errorFlag: false,
    };
    this.modifyStr = this.props.location.state;
    this.getValue = this.getValue.bind(this);
  }

  componentDidMount() {
    const self = this;
    plusReady(() => {
      self.testPwdOne();
      self.testPwdTwo();
      self.testPwdThree();
    });
  }

  componentWillUnmount() {
    pwd1.removePassword();
    pwd2.removePassword();
    pwd3.removePassword();
  }
  getValue() {
    const promise1 = new Promise((resolve, reject) => {
      pwd1.getPassword((pwd) => {
        pwd1Str = JSON
          .parse(pwd);
        resolve(pwd1Str);
      });
    });
    const promise2 = new Promise((resolve, reject) => {
      pwd2.getPassword((pwd) => {
        pwd2Str = JSON
          .parse(pwd);
        resolve(pwd2Str);
      });
    });
    const promise3 = new Promise((resolve, reject) => {
      pwd3.getPassword((pwd) => {
        pwd3Str = JSON
          .parse(pwd);
        resolve(pwd3Str);
      });
    });
    Promise
      .all([promise1, promise2, promise3])
      .then((value) => {
        if (value[0].length * 1 !== 6 || value[1].length * 1 !== 6 || value[2].length * 1 !== 6) {
          Toast.info('输入的密码长度有误，请重新输入！', 1);
          return false;
        }
        if (value[0].password === value[1].password) {
          Toast.info('原密码与新密码不能相同，请重新输入！', 1);
          return false;
        }
        if (value[1].password !== value[2].password) {
          Toast.info('两次输入的新密码与确认密码不一致，请重新输入！', 1);
          return false;
        }
        Toast.loading('修改中...', 0);
        const param = {
          CUSTOMER_ID: Storage.getItem('customerId'),
          TRADE_ACCOUNT: Storage.getItem('tradeAccount'),
          ORIGIN_PASSWORD: value[0].password,
          NEW_PASSWORD: value[1].password,
          MEMO1: '',
        };
        let url;
        if (this.modifyStr === '登录密码') {
          url = ActionConfig[Storage.getItem('customerType')][0].updateLoginPwd;
        } else {
          url = ActionConfig[Storage.getItem('customerType')][0].updateFxtradePwd;
        }
        Ajax(url, param).then((res) => {
          Toast.hide();
          if (res.success) {
            Toast.info('修改成功！', 1, () => {
              window.history.go(-1);
            });
          } else {
            this.setState({
              errorFlag: true,
              errorMsg: commonTool.transformErrMsg(res.message),
            });
          }
        }, (err) => {
          console.log(err);
          Toast.hide();
        });
      });
  }
  testPwdOne() {
    const box1 = document.getElementsByClassName('pwd1')[0];
    pwd1 = new PwdKeyboard({
      'left': box1.offsetLeft,
      'top': box1.offsetTop + box1.clientHeight,
      'width': box1.clientWidth,
      'height': box1.clientHeight,
    });
  }
  testPwdTwo() {
    const box2 = document.getElementsByClassName('pwd2')[0];
    pwd2 = new PwdKeyboard({
      'left': box2.offsetLeft,
      'top': box2.offsetTop + box2.clientHeight,
      'width': box2.clientWidth,
      'height': box2.clientHeight,
    });
  }
  testPwdThree() {
    const box3 = document.getElementsByClassName('pwd3')[0];
    pwd3 = new PwdKeyboard({
      'left': box3.offsetLeft,
      'top': box3.offsetTop + box3.clientHeight,
      'width': box3.clientWidth,
      'height': box3.clientHeight,
    });
  }
  render() {
    return (
      <div>
        <Header>修改信息</Header>
        <div id="ModifyPassword">
          <div className="modify-header">您当前正在办理修改<span>{this.modifyStr}</span>业务</div>
          <div className="item">
            <label>原密码</label>
            <div className="password-content pwd1" />
          </div>
          <div className="item">
            <label>新密码</label>
            <div className="password-content pwd2" />
          </div>
          <div className="item">
            <label>确认新密码</label>
            <div className="password-content pwd3" />
          </div>
        </div>
        <Button
          type="primary"
          inline
          activeClassName="default-btn-active"
          className="default"
          onClick={this.getValue}
        >确定
        </Button>
        <ModalDiaLog
          visible={this.state.errorFlag}
          onClose={() => {
          this.setState({ errorFlag: false });
        }}
          errMsg={this.state.errorMsg}
        />
      </div>
    );
  }
}
