import React, { Component } from 'react';
import { connect } from 'react-redux';
import { Router, Route, Link, withRouter } from 'react-router-dom';
import commonTool from 'utils/commonTool.js';
import PriceList from 'components/PriceList/PriceList';
import sortEditImg from 'style/iconImage/sortEdit.png';
import { Storage } from 'storage';
import Header from 'components/Header/Header';

class FirmQuotation extends Component {
  // constructor(props) {
  //   super(props);
  // }

  componentDidMount() {
    console.log(111);
  }

  render() {
    const ratecode = Storage.getItem('eraytRateCode', true) != null ? Storage.getItem('eraytRateCode', true).interestCode.split(',') : Object.keys(this.props.priceObject);
    const ratecodeObj = [];
    for (const i in ratecode) {
      if (ratecode.hasOwnProperty(i)) {
        const productId = ratecode[i];
        this.props.priceObject[productId] && ratecodeObj.push(this.props.priceObject[productId]);
      }
    }
    return (
      <div>
        <Header back="gtja">
          实盘行情
          <Link to="/EditInterestCode">
            <img className="more-icon" src={sortEditImg} onClick={() => {
              commonTool.gtjaBurialPoint('293024');
            }} />
          </Link>
        </Header>
        <PriceList
          posts={Object.values(ratecodeObj)[0] === undefined ? this.props.posts : ratecodeObj}
          instrument="firm"
          customerClass="li-border"
        />
      </div>
    );
  }
}

const mapStateToProps = (state) => {
  const { firmQuotation } = state;
  const selectedInstrument = 'firm';
  const {
    isFetching,
    items: posts,
    priceObject,
  } = firmQuotation[selectedInstrument] || {
    isFetching: true,
    items: [],
    priceObject: {},
  };
  return {
    selectedInstrument,
    posts,
    priceObject,
    isFetching,
  };
};

export default withRouter(connect(mapStateToProps)(FirmQuotation));
