import React, { Component } from 'react';
import ClassName from 'classnames';
import plusReady from 'plugins/plusReady';
import { Icon } from 'antd-mobile';
import { getDom, getDomHeight } from 'utils/dom';
import commonTool from 'utils/commonTool.js';
import { Storage } from 'storage';
import KChart from './k-chart';
import extendDownImg from 'style/iconImage/extendDown.png';
import Style from './_Kchart.scss';

class Kchart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      kType: 6,
      productId: this.props.id,
      isShowHchart: false,
      proName: props.name,
      quote: props.quote,
    };
    this.horDataObj = {};
    const bindArr = ['createChart', 'backVkchart', 'backVkchart', 'initChart'];
    bindArr.forEach(x => this[x] = this[x].bind(this));
  }
  componentDidMount() {
    this.totalHeight = document.body.clientHeight;
    this.totalWidth = document.body.clientWidth;
    this.baseStyle = {
      increasePillarColor: '#ff4a5a',
      reducePillarColor: '#5ac23b',
      primaryIndicatrixStyle: {
        ma5Color: '#2e8ae6',
        ma10Color: '#ffa622',
        ma20Color: '#CC2996',
      },
      indicatrixStyle: {
        indicMACD_increaseColor: '#ff4a5a',
        indicMACD_decreaseColor: '#5ac23b',
      },
    };
    this.chartBoxHeight = `${this.totalHeight - 45 - getDomHeight('.btn-box') - getDomHeight('.chart-info') - getDomHeight('.quote-box') - 20}px`;
    getDom('#chart-box').style.height = this.chartBoxHeight;
    const self = this;
    plusReady(() => {
      self.initChart();
    });
  }
  componentWillReceiveProps(nextProps) {
    const idbool = nextProps.id !== this.state.productId;
    if (idbool || nextProps.quote !== this.state.quote) {
      this.setState({
        productId: nextProps.id,
        quote: nextProps.quote,
        proName: nextProps.name,
      }, () => {
        plusReady(() => {
          this.initChart();
        });
      });
    }
    // } else if (window.plus && this.kchart) {
    //   nextProps.show ? this.kchart.show('', () => {}) : this.kchart.hide();
    // }
  }
  // shouldComponentUpdate(nextProps, nextState) {
  //   const state = this.state;
  //   return state.kType !== nextState.kType || state.productId !== nextProps.id || state.isShowHchart !== nextState.isShowHchart;
  // }
  componentWillUnmount() {
    this.kchart && this.kchart.disMiss();
  }
  setVStyle() {
    this.vtop = 45 + getDomHeight('.quote-box') + getDomHeight('.chart-info') + 10,
    this.vheight = this.totalHeight - this.vtop - getDomHeight('.btn-box') - 10;
    this.KchartStyle = Object.assign({
      left: 10,
      top: this.vtop,
      width: this.totalWidth - 20,
      height: this.vheight,
    }, this.baseStyle);
  }
  setHStyle() {
    const screenHeight = this.screenHeight;
    this.KchartStyle = Object.assign({
      left: 10,
      top: 75,
      width: (screenHeight !== 812 ? screenHeight : (this.totalHeight - 10)) - 20,
      height: this.totalWidth - (screenHeight !== 812 ? 80 : 100),
    }, this.baseStyle);
  }
  initChart() {
    this.kchart && this.kchart.disMiss();
    const state = this.state;
    this.setVStyle();
    this.kchart = new KChart(this.KchartStyle, this.state.quote);
    this.kchart.create(state.productId, state.kType);
    this.horDataObj = {
      objectId: this.state.productId,
      quoteData: this.state.quote,
      kType: this.state.kType,
    };
    localStorage.setItem('horizontalDataObj', JSON.stringify(this.horDataObj));
  }
  createChart() {
    const state = this.state;
    this.kchart.create(state.productId, state.kType);
  }
  backVkchart() {
    this.changeChart(99);
  }
  changeChart() {
    const kType = this.state.kType;
    if (kType !== 99) {
      if (kType) {
        this.setState({
          kType: kType * 1,
        }, this.createChart);
      } else {
        // 初始化为日线
        this.setState({
		  kType: 6,

        }, this.createChart);
      }
    } else {
      const Hchart = this.state.isShowHchart;
      this.setState({ isShowHchart: !Hchart }, () => {
        if (Hchart) {
          window.backFn = window.reLocal.back;
          getDom('#quote-head').style.display = 'block';
          getDom('#chart-box').style.height = this.chartBoxHeight;
        } else {
          window.backFn = this.backVkchart;
          this.setHStyle();
          getDom('#quote-head').style.display = 'none';
        }
      });
      if (window.plus) {
        this.kchart && this.kchart.disMiss();
        if (Hchart) {
          window.plus.screen.lockOrientation('portrait-primary');
          this.setVStyle();
        } else {
          window.plus.screen.lockOrientation('landscape-primary');
          this.setHStyle();
        }
        // !window.isIOS && window.plus.navigator.setFullscreen(!Hchart);
        this.kchart = new KChart(this.KchartStyle);
        this.createChart();
      }
    }
  }
  handleChartType(chartType, imgId) {
    commonTool.gtjaBurialPoint('138010', this.state.productId, imgId);
    this.setState({
	  kType: chartType,
	  selectValue: '',
    }, this.changeChart);
  }
  handleSelectChartType(e) {
    const imgId = e.target.querySelectorAll('option')[e.target.selectedIndex].getAttribute('imgid');
    commonTool.gtjaBurialPoint('138010', this.state.productId, imgId);
    const type = e.target.value;
    if (type === '0' || type === '1' || type === '2' || type === '3' || type === '4') {
      this.setState({
        selectActiveFlag: 'active-chart-info',
        selectValue: e.target.value,
        kType: e.target.value,
      }, this.changeChart);
    } else {
      this.setState({
        selectActiveFlag: '',
        selectValue: e.target.value,
        kType: e.target.value,
      }, this.changeChart);
    }
  }
  render() {
    const state = this.state;
    const quote = state.quote;
    return (
      !state.isShowHchart ?
        <div id="chart-content">
          <div className="chart-info">
            <span className={this.state.kType !== 6 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 6, 1)}>日K</span>
            <span className={this.state.kType !== 7 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 7, 2)}>周K</span>
            <span className={this.state.kType !== 8 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 8, 3)}>月K</span>
            <select value={this.state.selectValue} onChange={this.handleSelectChartType.bind(this)}>
              <option value="">分钟</option>
              <option value="0" imgid="4">1分钟</option>
              <option value="1" imgid="5">5分钟</option>
              <option value="2" imgid="6">15分钟</option>
              <option value="3" imgid="7">30分钟</option>
              <option value="4" imgid="8">1小时</option>
            </select>
            <span className="select-down" />
          </div>
          <div id="chart-box" />
        </div> :
        <div id="h-chart-content">
          <div className="h-chart-head">
            <div className="h-quote-info">
              <span className="pro-name">{state.proName}</span>
              <span className="up-o-down">
                <span>{quote ? quote.point : '-'}</span>
                <span>({quote ? quote.prec : '-'}%)</span>
              </span>
              <span className="pro-price">
                <span>最高 {quote ? quote.maxRate : '-'}</span>
                <span>最低 {quote ? quote.minRate : '-'}</span>
                <span>今开 {quote ? quote.openRate : '-'}</span>
                <span>昨开 {quote ? quote.openRate : '-'}</span>
              </span>
              <span className="iconfont icon-contract" onClick={this.backVkchart} />
            </div>
          </div>
        </div>
    );
  }
}

export default Kchart;
