import React, { Component } from 'react';
import { Icon } from 'antd-mobile';
// import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import Header from 'components/Header/Header';
import commonTool from 'utils/commonTool.js';
import './detail.scss';


class QueryFirmTradeDetail extends Component {
  constructor(props) {
    super(props);
    this.state = this.props.tradeLogData;
    console.error(this.props.tradeLogData);
  }
  back() {
    this.props.backToList();
  }
  render() {
    return (
      <div>
        <div className="app_menu">
          <Icon type="left" color="#309fea" size="lg" onClick={this.back.bind(this)} />
          实盘成交明细
        </div>
        <div id="content" className="detail-content">
          <ul>
            <li>
              <label>交易流水号</label><span>{this.state.SERIAL_NO}</span>
            </li>
            <li>
              <label>交易状态</label><span>{commonTool.transTradeStateToChinese(this.state.TRADE_STATE)}</span>
            </li>
            <li>
              <label>交易货币对</label><span>{this.state.CURRENCY_PAIR}</span>
            </li>
            <li>
              <label>买卖方向</label><span>{this.state.BUY_OR_SELL === 'B' ? '买入' : '卖出'}</span>
            </li>
            <li>
              <label>成交汇率</label><span>{this.state.TRADE_RATE.toFixed(this.state.AVAIL_POINT)}</span>
            </li>
            {
              this.state.PREF_POINT ?
                <li>
                  <label>优惠点数</label><span>{this.state.PREF_POINT}</span>
                </li> : ''
            }
            <li>
              <label>交易方式</label><span>{commonTool.transTradeModeToChinese(this.state.TRADE_MODE)}</span>
            </li>
            <li>
              <label>{this.state.TRADE_CCY}金额</label><span>{this.state.TRADE_AMT}</span>
            </li>
            <li>
              <label>交易日期</label><span>{commonTool.formatDate(this.state.TRADE_DATE)}</span>
            </li>
            <li>
              <label>交易时间</label><span>{commonTool.formatTime(this.state.TRADE_TIME)}</span>
            </li>
            <li>
              <label>交付日期</label><span>{commonTool.formatDate(this.state.VALUE_DATE)}</span>
            </li>
            {this.state.TRADE_MODE === '4' &&
            <li>
              <label>审核状态</label><span>{commonTool.transCheckStateToChinese(this.state.CHECK_STATUS)}</span>
            </li>}
            {this.state.CHECK_STATUS === '2' &&
            <li>
              <label>审核意见</label><span>{this.state.REFUSE_REASON}</span>
            </li>}
          </ul>
        </div>
      </div>
    );
  }
}

export default withRouter(QueryFirmTradeDetail);
