import React, { Component } from 'react';
import { withRouter } from 'react-router-dom';
import skipConfig from 'config/config.js';
import ActionConfig from 'config/actionConfig.js';
import ModalDiaLog from 'components/ModalDiaLog/ModalDiaLog';
import errorMsg from 'config/errorConfig.js';
import { Storage } from 'storage';
import Ajax from 'ajax';
import commonTool from 'utils/commonTool.js';
import IScroll from 'components/Iscroll/Iscroll';
import FilterSearch from 'components/FilterSearch/FilterSearch';
import extendDownImg from 'style/iconImage/extendDown.png';
import noDataBgImg from 'style/iconImage/noDataBg.png';
import './QueryFirmTrade.scss';
import QueryFirmTradeDetail from './QueryFirmTradeDetail';

class QueryFirmTrade extends Component {
  constructor(props) {
    super(props);
    const edate = new Date(new Date() - 86400000);
    const sdate = new Date(new Date() - (86400000 * 30));
    this.state = {
      upFinish: false,
      isInit: true,
      wrapper: {
        overflow: 'auto',
      },
      hisList: [],
      filterFlag: false,
      beginDate: new Date(sdate),
      endDate: edate,
      currencyPair: '',
      tradeType: '',
      tradeState: '',
      showQueryList: true,
    };
    this.beginCount = 1;
    this.queryCount = 10;
    this.jumpTrade = this.jumpTrade.bind(this);
    this.filter = this.filter.bind(this);
    const bindFnArr = ['getHisList', 'okBtnHandle', 'cancelBtnHandle'];
    bindFnArr.forEach((x) => {
      this[x] = this[x].bind(this);
    });
    window.backFunc = () => {
      if (this.state.showQueryList) {
        history.back();
      } else {
        this.backToList();
      }
    };
  }
  componentDidMount() {
    this.getHisList();
  }
  getHisList(isload) {
    isload && (this.beginCount += 10);
    this.queryData();
  }
  dateFormat(date, fmt) {
    const o = {
      'm+': date.getMonth() + 1,
      'd+': date.getDate(),
      'h+': date.getHours(),
      'i+': date.getMinutes(),
      's+': date.getSeconds(),
      'q+': Math.floor((date.getMonth() + 3) / 3),
      // 't': date.getMilliseconds(),
    };
    if (/(y+)/.test(fmt)) {
      fmt = fmt.replace(RegExp.$1, (date.getFullYear().toString()).substr(4 - RegExp.$1.length));
    }
    for (const k in o) {
      if (new RegExp(`(${k})`).test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : ((`00${o[k]}`).substr((`${o[k]}`).length)));
      }
    }
    return fmt;
  }
  filter() {
    commonTool.gtjaBurialPoint('293023');
    if (this.state.filterFlag === true) {
      this.setState({
        filterFlag: false,
      }, () => {
        this.props.refreshBackIcon(this.state.filterFlag);
      });
    } else {
      this.setState({
        filterFlag: true,
      }, () => {
        this.props.refreshBackIcon(this.state.filterFlag);
      });
    }
  }
  okBtnHandle(filterObj) {
    this.setState({
      filterFlag: false,
      beginDate: filterObj.beginDate,
      endDate: filterObj.endDate,
      tradeType: filterObj.tradeType,
      currencyPair: filterObj.currencyPair,
      tradeState: filterObj.tradeState,
      hisList: [],
    }, () => {
      this.props.refreshBackIcon(this.state.filterFlag);
      this.conditionChangeQuery();
    });
  }
  cancelBtnHandle() {
    this.setState({
      filterFlag: false,
    }, () => {
      this.props.refreshBackIcon(this.state.filterFlag);
    });
  }
  conditionChangeQuery() {
    this.beginCount = 1;
    this.queryCount = 10;
    const self = this;
    setTimeout(() => {
      self.queryData();
    }, 0);
  }
  jumpTrade(tradeLogData) {
    commonTool.gtjaBurialPoint('293034');
    this.setState({
      tradeLogData,
      showQueryList: false,
    });
    this.props.hideTitle();
  }
  queryData() {
    const self = this;
    const beginDate = self.dateFormat(this.state.beginDate, 'yyyy-mm-dd');
    const endDate = self.dateFormat(this.state.endDate, 'yyyy-mm-dd');
    const param = {
      CUSTOMER_ID: Storage.getItem('customerId'),
      TRADE_ACCOUNT: Storage.getItem('tradeAccount'),
      START_DATE: beginDate.replace(/-/g, '') * 1,
      END_DATE: endDate.replace(/-/g, '') * 1,
      CURRENCY_PAIR: this.state.currencyPair || '',
      QUERY_COUNT: this.queryCount,
      START_COUNT: this.beginCount,
      TRADE_MODE: this.state.tradeType,
      TRADE_STATE: this.state.tradeState,
      CHANNEL: ActionConfig[Storage.getItem('customerType')][0].channel,
      BOOKING_ID: skipConfig.bookingId,
    };
    const url = ActionConfig[Storage.getItem('customerType')][0].queryFxTradeHistoryLog;
    Ajax(url, param).then((res) => {
      if (res.success) {
        this.querySuccess(res.data.result);
      } else {
        this.setState({
          errorFlag: true,
          errorMsg: commonTool.transformErrMsg(res.message),
        });
      }
    });
  }

  querySuccess(res) {
    const hisList = [...this.state.hisList, ...res.datals];
    const upFinish = res.total < this.beginCount + 10;
    this.setState({ hisList, upFinish, isInit: false });
  }

  backToList() {
    this.setState({
      showQueryList: true,
    });
    this.props.showTitle();
  }

  renderHistoryList() {
    const state = this.state;
    const hasMore = !this.state.upFinish;
    // 手工录入失败不展示
    // const showPremise = ({ TRADE_MODE, TRADE_STATE }) => !(TRADE_MODE === '5' && TRADE_STATE === '2');
    const priceObj = Storage.getItem('firmSpotRateData', true);
    return (
      <IScroll pageStart={0} loadMore={this.getHisList} hasMore={hasMore}>
        <ul className="firm-trade-list">
          {
            state.hisList.map(i => (
              <li key={i.SERIAL_NO} className="trade-content content" onClick={() => { this.jumpTrade({ ...i, AVAIL_POINT: priceObj[i.CURRENCY_PAIR].AVAIL_POINT }); }}>
                <div className="content-header">
                  <div className="currencyPairs">{i.CURRENCY_PAIR}</div>
                  <div
                    className={/1|4|5/.test(i.TRADE_MODE) ? 'fc309fea trade-mode' : 'fcfe8320 trade-mode'}
                  >&emsp;{commonTool.transTradeModeToChinese(i.TRADE_MODE)}
                  </div>
                  <div
                    className="date"
                  >{commonTool.formatDate(i.TRADE_DATE)}&emsp;{commonTool.formatTime(i.TRADE_TIME)}
                  </div>
                </div>
                <div className="content-info">
                  <div className="coin-type">
                    <div className="label">交易币种&emsp;</div>
                    <div className="type">{i.TRADE_CCY}</div>
                  </div>
                  <div className="sell-or-buy">
                    <div className="label">买卖方向&emsp;</div>
                    <div className="sell-buy">{i.BUY_OR_SELL === 'B' ? '买入' : '卖出'}</div>
                  </div>
                  <div className="order-amount">
                    <div className="label">交易金额&emsp;</div>
                    <div className="amout">{i.TRADE_AMT}</div>
                  </div>
                  <div className="coin-flag">
                    <div className="label">成交价格&emsp;</div>
                    <div className="flag">{i.TRADE_RATE.toFixed(priceObj[i.CURRENCY_PAIR].AVAIL_POINT)}</div>
                  </div>
                  {/* {
                    i.TRADE_MODE === '4' && i.TRADE_STATE !== 1 && */}
                  <div className="coin-flag">
                    <div className="label">交易状态&emsp;</div>
                    <div className="flag">{commonTool.transTradeStateToChinese(i.TRADE_STATE)}</div>
                  </div>
                  {/* } */}
                </div>
              </li>
            ))
          }
        </ul>
        <div className="loading">{hasMore ? '正在加载数据...' : '已显示全部数据'}</div>
      </IScroll>
    );
  }

  render() {
    return (
      <div>
        {
          this.state.showQueryList ?
            <div id="firmTradeQuery">
              <div className="right-icon" onClick={this.filter}>筛选</div>
              <div id="wrapper">
                {
                  this.state.hisList.length > 0 ?
                    this.renderHistoryList()
                    :
                    <div className="default-nodata-content">
                      <img src={noDataBgImg} />
                      <div>暂时没有相关数据...</div>
                    </div>
                }
              </div>
              {this.state.filterFlag ? <div id="mask" className="wrapperShadow" /> : ''}
              {this.state.filterFlag ?
                <FilterSearch
                  okBtnHandle={this.okBtnHandle}
                  cancelBtnHandle={this.cancelBtnHandle}
                  beginDate={this.state.beginDate}
                  endDate={this.state.endDate}
                  currencyPair={this.state.currencyPair}
                  tradeStateFlag
                  orderStatusFlag={false}
                  accountTypeFlag={false}
                /> : ''
              }
              <ModalDiaLog
                visible={this.state.errorFlag}
                onClose={() => {
                  this.setState({ errorFlag: false });
                }}
                errMsg={this.state.errorMsg}
              />
            </div>
            :
            <QueryFirmTradeDetail
              tradeLogData={this.state.tradeLogData}
              backToList={this.backToList.bind(this)}
            />
        }
      </div>

    );
  }
}

export default withRouter(QueryFirmTrade);
