import React, { Component } from 'react';
import { withRouter } from 'react-router-dom';
import IScroll from 'components/Iscroll/Iscroll';
import FilterSearch from 'components/FilterSearch/FilterSearch';
import skipConfig from 'config/config.js';
import ActionConfig from 'config/actionConfig.js';
import ModalDiaLog from 'components/ModalDiaLog/ModalDiaLog';
import errorMsg from 'config/errorConfig.js';
import commonTool from 'utils/commonTool.js';
import noDataBgImg from 'style/iconImage/noDataBg.png';
import extendDownImg from 'style/iconImage/extendDown.png';
import { Storage } from 'storage';
import Ajax from 'ajax';
import './QueryFirmOrder.scss';
import QueryFirmOrderDetail from './QueryFirmOrderDetail';

class QueryFirmOrder extends Component {
  constructor(props) {
    super(props);
    const edate = new Date(new Date() - 86400000);
    const sdate = new Date(new Date() - (86400000 * 30));
    this.state = {
      upFinish: false,
      isInit: true,
      wrapper: {
        overflow: 'auto',
      },
      hisList: [],
      filterFlag: false,
      beginDate: new Date(sdate),
      endDate: edate,
      currencyPair: '',
      orderStatus: '',
      showQueryList: true,
    };
    this.beginCount = 1;
    this.queryCount = 10;
    this.needReload = true;
    this.jumpOrder = this.jumpOrder.bind(this);
    this.filter = this.filter.bind(this);
    const bindFnArr = ['getHisList', 'okBtnHandle', 'cancelBtnHandle', 'backToList'];
    bindFnArr.forEach((x) => {
      this[x] = this[x].bind(this);
    });
    window.backFunc = () => {
      if (this.state.showQueryList) {
        history.back();
      } else {
        this.backToList();
      }
    };
  }
  componentDidMount() {
    this.getHisList();
  }
  getHisList(isload) {
    isload && (this.beginCount += 10);
    this.queryData();
  }
  dateFormat(date, fmt) {
    const o = {
      'm+': date.getMonth() + 1,
      'd+': date.getDate(),
      'h+': date.getHours(),
      'i+': date.getMinutes(),
      's+': date.getSeconds(),
      'q+': Math.floor((date.getMonth() + 3) / 3),
      // 't': date.getMilliseconds(),
    };
    if (/(y+)/.test(fmt)) {
      fmt = fmt.replace(RegExp.$1, (date.getFullYear().toString()).substr(4 - RegExp.$1.length));
    }
    for (const k in o) {
      if (new RegExp(`(${k})`).test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : ((`00${o[k]}`).substr((`${o[k]}`).length)));
      }
    }
    return fmt;
  }
  filter() {
    commonTool.gtjaBurialPoint('293023');
    if (this.state.filterFlag === true) {
      this.setState({
        filterFlag: false,
      }, () => {
        this.props.refreshBackIcon(this.state.filterFlag);
      });
    } else {
      this.setState({
        filterFlag: true,
      }, () => {
        this.props.refreshBackIcon(this.state.filterFlag);
      });
    }
  }
  okBtnHandle(filterObj) {
    this.setState({
      filterFlag: false,
      beginDate: filterObj.beginDate,
      endDate: filterObj.endDate,
      orderStatus: filterObj.orderStatus,
      currencyPair: filterObj.currencyPair,
      hisList: [],
    }, () => {
      this.props.refreshBackIcon(this.state.filterFlag);
      this.conditionChangeQuery();
    });
  }
  cancelBtnHandle() {
    this.setState({
      filterFlag: false,
    }, () => {
      this.props.refreshBackIcon(this.state.filterFlag);
    });
  }
  conditionChangeQuery() {
    this.beginCount = 1;
    this.queryCount = 10;
    const self = this;
    setTimeout(() => {
      self.queryData();
    }, 0);
  }
  jumpOrder(orderLogData) {
    commonTool.gtjaBurialPoint('293020');
    this.setState({
      orderLogData,
      showQueryList: false,
    });
    this.props.hideTitle();
  }
  queryData() {
    const self = this;
    const beginDate = self.dateFormat(this.state.beginDate, 'yyyy-mm-dd');
    const endDate = self.dateFormat(this.state.endDate, 'yyyy-mm-dd');
    const param = {
      CUSTOMER_ID: Storage.getItem('customerId'),
      TRADE_ACCOUNT: Storage.getItem('tradeAccount'),
      ORDER_STATUS: this.state.orderStatus,
      START_DATE: beginDate.replace(/-/g, '') * 1,
      END_DATE: endDate.replace(/-/g, '') * 1,
      CURRENCY_PAIR: this.state.currencyPair || '',
      QUERY_COUNT: this.queryCount,
      START_COUNT: this.beginCount,
      CHANNEL: ActionConfig[Storage.getItem('customerType')][0].channel,
      BOOKING_ID: skipConfig.bookingId,
    };
    const url = ActionConfig[Storage.getItem('customerType')][0].queryFxOrderHistoryLog;
    Ajax(url, param).then((res) => {
      if (res.success) {
        self.querySuccess(res.data.result);
      } else {
        this.setState({
          errorFlag: true,
          errorMsg: commonTool.transformErrMsg(res.message),
        });
      }
    });
  }
  querySuccess(res) {
    const hisList = this.needReload ? [...res.datals] : [...this.state.hisList, ...res.datals];
    this.needReload = false;
    const upFinish = res.total < this.beginCount + 10;
    this.setState({ hisList, upFinish, isInit: false });
  }
  colorByStatus(status) {
    let color;
    switch (status) {
      case '1':
        color = 'fc309fea';
        break;
      case '2':
        color = 'fcfe8320';
        break;
      case '3':
        color = 'fc6e87a0';
        break;
      case '4':
        color = 'fc999999';
        break;
      case '5':
        color = 'fceb333b';
        break;
      default:
        color = '';
        break;
    }
    return color;
  }

  backToList(needReload) {
    this.setState({
      showQueryList: true,
    }, () => {
      if (needReload) {
        this.beginCount = 1;
        this.needReload = true;
        this.getHisList();
      }
    });
    this.props.showTitle();
  }

  renderHistoryList() {
    const state = this.state;
    const hasMore = !this.state.upFinish;
    const priceObj = Storage.getItem('firmSpotRateData', true);
    return (
      <IScroll pageStart={0} loadMore={this.getHisList} hasMore={hasMore}>
        <ul className="firm-order-list">
          {
            state.hisList.map((i, index) => (
              <li key={i.SERIAL_NO} className="order-content orderContent" onClick={() => { this.jumpOrder({ ...i, AVAIL_POINT: priceObj[i.CURRENCY_PAIR].AVAIL_POINT }); }}>
                <div className="orderContent-header">
                  <div className="currencyPairs">{i.CURRENCY_PAIR}</div>
                  <div className="date">{commonTool.formatDate(i.ORDER_DATE)}&emsp;
                    <span className={this.colorByStatus(i.ORDER_STATUS)}>
                      {commonTool.transOrdStateToChinese(i.ORDER_STATUS)}
                    </span>
                  </div>
                </div>
                <div className="orderContent-info">
                  <div className="coin-type">
                    <div className="label">交易币种&emsp;</div>
                    <div className="type">{i.TRADE_CCY}</div>
                  </div>
                  <div className="sell-or-buy">
                    <div className="label">
                      买卖方向&emsp;
                    </div>
                    <div className="sell-buy">
                      {i.BUY_OR_SELL === 'B' ? '买入' : '卖出'}
                    </div>
                  </div>
                  <div className="order-amount">
                    <div className="label">挂单金额&emsp;</div>
                    <div className="amount">{i.TRADE_AMT}</div>
                  </div>
                  <div className="coin-flag">
                    <div className="label">挂单类型&emsp;</div>
                    <div className="flag">{commonTool.transOrdTypeToChinese(i.ORDER_TYPE)}</div>
                  </div>
                </div>
              </li>
            ))
          }
        </ul>
        <div className="loading">{hasMore ? '正在加载数据...' : '已显示全部数据'}</div>
      </IScroll>
    );
  }
  
  render() {
    return (
      this.state.showQueryList ?
        <div id="firmOrderQuery">
          <div className="right-icon" onClick={this.filter}>筛选</div>
          <div id="wrapper">{
            this.state.hisList.length > 0 ?
              this.renderHistoryList()
              :
              <div className="default-nodata-content">
                <img src={noDataBgImg} />
                <div>暂时没有相关数据...</div>
              </div>
          }
          </div>
          {this.state.filterFlag ? <div id="mask" className="wrapperShadow" /> : ''}
          {this.state.filterFlag ?
            <FilterSearch
              okBtnHandle={this.okBtnHandle}
              cancelBtnHandle={this.cancelBtnHandle}
              beginDate={this.state.beginDate}
              endDate={this.state.endDate}
              tradeTypeFlag={false}
              tradeStateFlag={false}
              accountTypeFlag={false}
            /> : ''
          }
          <ModalDiaLog
            visible={this.state.errorFlag}
            onClose={() => {
              this.setState({ errorFlag: false });
            }}
            errMsg={this.state.errorMsg}
          />
        </div> :
        <QueryFirmOrderDetail
          orderLogData={this.state.orderLogData}
          backToList={this.backToList}
        />
    );
  }
}

export default withRouter(QueryFirmOrder);
