import React, { Component } from 'react';
import commonTool from 'utils/commonTool.js';
import { Icon } from 'antd-mobile';

export default class CapitalAccountsDetail extends Component {
  constructor(props) {
    super(props);
    this.detailData = this.props.data;
    console.log(this.detailData);
  }
  back() {
    this.props.backToList();
  }
  renderHtml() {
    if (1) {
      return (
        <div>
          <div className="app_menu">
            <Icon type="left" color="#309fea" size="lg" onClick={this.back.bind(this)} />
            {commonTool.transAccountTypeToChinese(this.detailData.ACCOUNT_IN_TYPE)}详情
          </div>
          <ul>
            <li>
              <label>币种</label>
              <span>{this.detailData.CURRENCY}</span>
            </li>
            <li>
              <label>金额</label>
              <span>{commonTool.formatFloatAmount(this.detailData.NET_AMOUNT, (this.detailData.CURRENCY === 'JPY' ? 0 : 2))}</span>
            </li>
            <li>
              <label>资金账号</label>
              <span>{this.detailData.TRADE_ACCOUNT}</span>
            </li>
            {
              this.detailData.ACCOUNT_IN_TYPE === '1' || this.detailData.ACCOUNT_IN_TYPE === '2' ?
                <li>
                  <label>手续费用</label>
                  <span>{this.detailData.POUNDAGE_AMT}</span>
                </li> : ''
            }
            <li>
              <label>操作日期</label>
              <span>{commonTool.formatDate(this.detailData.TRADE_DATE)}</span>
            </li>
            <li>
              <label>操作时间</label>
              <span>{commonTool.formatTime(this.detailData.TRADE_TIME)}</span>
            </li>
            <li>
              <label>清算日期</label>
              <span>{commonTool.formatDate(this.detailData.CLEAR_DATE)}</span>
            </li>
            {/* <li>
              <label>清算时间</label>
              <span>{commonTool.formatTime(this.detailData.CLEAR_TIME)}</span>
            </li> */}
          </ul>
        </div>
      );
    } else {
      return (
        <div>
          <div className="app_menu">
            <Icon type="left" color="#fff" size="md" onClick={this.goBack.bind(this)} />
            结息详情
          </div>
          <ul>
            <li>
              <label>币种</label>
              <span>USD</span>
            </li>
            <li>
              <label>金额</label>
              <span>+110.00</span>
            </li>
            <li>
              <label>币种类型</label>
              <span>XXXXXXXXXX</span>
            </li>
          </ul>
        </div>
      );
    }
  }
  render() {
    return (
      <div id="CapitalAccountsDetail">
        {this.renderHtml()}
      </div>
    );
  }
}
