import React, { Component } from 'react';
import Header from 'components/Header/Header';
import commonTool from 'utils/commonTool.js';
import { Storage } from 'storage';
import QueryFirmTrade from 'pages/query/firmTrade/QueryFirmTrade';
import QueryFirmOrder from 'pages/query/firmOrder/QueryFirmOrder';
import CapitalAccounts from 'pages/query/capitalAccounts/CapitalAccounts';
import './query.scss';

class TabController extends Component {
  constructor(props) {
    super(props);
    this.state = {
      current: 0,
      showTitle: true,
    };
    this.refreshBackIcon = this.refreshBackIcon.bind(this);
    this.showTitle = this.showTitle.bind(this);
    this.hideTitle = this.hideTitle.bind(this);
  }

  itemNav(index) {
    return index === this.state.current ? 'item-title active' : 'item-title';
  }

  itemContent(index) {
    return index === this.state.current ? 'content active' : 'content';
  }
  queryBurialPoint() {
    if (this.state.current === 0) {
      commonTool.gtjaBurialPoint('293018');
    }
    if (this.state.current === 1) {
      commonTool.gtjaBurialPoint('293019');
    }
    if (this.state.current === 2) {
      commonTool.gtjaBurialPoint('293021');
    }
  }
  refreshBackIcon(flag) {
    this.props.parentRefreshBackIcon(flag);
  }
  hideTitle() {
    this.setState({
      showTitle: false,
    });
  }
  showTitle() {
    this.setState({
      showTitle: true,
    });
  }
  render() {
    return (
      <div>
        {
          this.state.showTitle ?
          <ul className="itemContainer clearfix">
            {
              React.Children.map(this.props.children, (element, index) => (
                <li
                  onClick={() => { this.setState({ current: index }, this.queryBurialPoint); }}
                  className={this.itemNav(index)}
                >
                  {element.props.name}
                </li>
                ))
            }
          </ul> : ''
        }
        <div className={this.state.showTitle ? "itemContent" : "itemContent resetTop"}>
          {this.state.current === 0 ?
            <QueryFirmTrade refreshBackIcon={this.refreshBackIcon} hideTitle={this.hideTitle} showTitle={this.showTitle} /> : ''
          }
          {this.state.current === 1 ?
            <QueryFirmOrder refreshBackIcon={this.refreshBackIcon} hideTitle={this.hideTitle} showTitle={this.showTitle} /> : ''
          }
          {this.state.current === 2 ?
            <CapitalAccounts refreshBackIcon={this.refreshBackIcon} hideTitle={this.hideTitle} showTitle={this.showTitle} /> : ''
          }
        </div>
      </div>
    );
  }
}

export default class QueryIndex extends Component {
  constructor(props) {
    super(props);
    this.state = {
      handleHeaderIconFlag: false,
    };
    this.parentRefreshBackIcon = this.parentRefreshBackIcon.bind(this);
  }
  parentRefreshBackIcon(flag) {
    this.setState({
      handleHeaderIconFlag: flag,
    });
  }
  render() {
    return (
      <div id="tradeQuery">
        <Header backIconFlag={`${!this.state.handleHeaderIconFlag}`}>历史查询</Header>
        <TabController parentRefreshBackIcon={this.parentRefreshBackIcon}>
          <div name="历史成交" />
          <div name="历史挂单" />
          <div name="资金流水" />
        </TabController>
      </div>
    );
  }
}
