import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { Button, Modal, Icon } from 'antd-mobile';
import Ajax from 'ajax';
import ActionConfig from 'config/actionConfig.js';
import commonTool from 'utils/commonTool.js';
import skipConfig from 'config/config.js';
import { Storage } from 'storage';
import Header from 'components/Header/Header';

class QueryFirmOrderDetail extends Component {
  constructor(props) {
    super(props);
    this.alertInstance = {};
    this.state = this.props.orderLogData;
    this.isSureCancleOrder = this.isSureCancleOrder.bind(this);
    this.closeAlert = this.closeAlert.bind(this);
  }
  closeAlert() {
    this.alertInstance.close();
    this.alertInstance = {};
  }
  back(needReload) {
    this.props.backToList(needReload);
  }
  isSureCancleOrder(event) {
    commonTool.gtjaBurialPoint('293016');
    event.preventDefault();
    this.alertInstance = Modal.alert(
      <div><span>提示</span><Icon onClick={this.closeAlert} type="cross" color="#309fea" size="lg" /></div>,
      '请确认是否撤销该笔挂单？',
      [
        {
          text: '取消',
          onPress: () => {
            console.log('cancel');
          },
        },
        {
          text: '确定',
          onPress: () => {
            this.doCancelFxOrder();
            console.log('ok');
          },
        }],
    );
  }
  doCancelFxOrder() {
    const param = {
      CUSTOMER_ID: Storage.getItem('customerId'),
      TRADE_ACCOUNT: Storage.getItem('tradeAccount'),
      CHANNEL: ActionConfig[Storage.getItem('customerType')][0].channel,
      SERIAL_NO: this.state.SERIAL_NO,
    };
    const url = ActionConfig[Storage.getItem('customerType')][0].doCancelFxOrder;
    Ajax(url, param).then((res) => {
      if (res.success) {
        console.log('撤销成功');
        this.back(true);
      }
    });
  }
  render() {
    return (
      <div>
        <div className="app_menu">
          <Icon type="left" color="#309fea" size="lg" onClick={() => this.back(false)} />
          实盘挂单详情
        </div>
        <div id="content" className="detail-content">
          <ul>
            <li>
              <label>挂单流水号</label><span>{this.state.SERIAL_NO}</span>
            </li>
            <li>
              <label>委托时间</label>
              <span>
                {commonTool.formatDate(this.state.ORDER_DATE)}&emsp;
                {commonTool.formatTime(this.state.ORDER_TIME)}
              </span>
            </li>
            <li>
              <label>交易货币对</label><span>{this.state.CURRENCY_PAIR}</span>
            </li>
            <li>
              <label>交易货币</label> <span>{this.state.TRADE_CCY}</span>
            </li>
            <li>
              <label>买卖方向</label><span>{this.state.BUY_OR_SELL === 'B' ? '买入' : '卖出'}</span>
            </li>
            <li>
              <label>挂单方式</label><span>{commonTool.transOrdTypeToChinese(this.state.ORDER_TYPE)}</span>
            </li>
            <li>
              <label>挂单状态</label><span>{commonTool.transOrdStateToChinese(this.state.ORDER_STATUS)}</span>
            </li>
            <li>
              <label>挂单金额</label><span>{this.state.TRADE_AMT}</span>
            </li>
            <li>
              <label>{(this.state.ORDER_TYPE === 'OCO' || this.state.ORDER_TYPE === 'PT') ? '止盈汇率' : '止损汇率'}</label><span>{this.state.ORDER_RATE1.toFixed(this.state.AVAIL_POINT)}</span>
            </li>
            {this.state.ORDER_TYPE === 'OCO' &&
            <li>
              <label>止损汇率</label><span>{this.state.ORDER_RATE2.toFixed(this.state.AVAIL_POINT)}</span>
            </li>}
            {this.state.PREF_POINT ?
              <li>
                <label>优惠点数</label><span>{this.state.PREF_POINT}</span>
              </li> : ''
            }
            <li>
              <label>失效日期</label><span>{commonTool.formatDate(this.state.EXPIRY_DATE)}</span>
            </li>
          </ul>
        </div>
        {
          this.state.ORDER_STATUS === '1' &&
          <Button
            type="primary"
            inline
            activeClassName="default-btn-active"
            className="default"
            onClick={this.isSureCancleOrder}
          >撤销
          </Button>
        }
      </div>
    );
  }
}

const mapStateToProps = (state) => {
  console.log(state);
  const { firmQuotation } = state;
  const selectedInstrument = 'firm';
  const {
    isFetching,
    items: posts,
  } = firmQuotation[selectedInstrument] || {
    isFetching: true,
    items: [],
  };
  return {
    selectedInstrument,
    posts,
    isFetching,
  };
};

export default withRouter(connect(mapStateToProps)(QueryFirmOrderDetail));
// export default withRouter(QueryFirmOrderDetail);
