import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import Header from 'components/Header/Header';
import PriceFormat from 'components/PriceFormat/PriceFormat';
import TimeFormat from 'components/TimeFormat/TimeFormat';
import { fetchQuotation } from 'store/firmQuotationAction';

class PriceItem extends Component {
  constructor(props) {
    super(props);
    console.error('props' + JSON.stringify(props));
    this.item = this.props.price;
  }
  render() {
    let item = this.item;
    return (
      <div className="priceItem">
        <div className="showPrice">
          <div className="coin-cp">
            <span className="cp">{item.objectId}</span>
            <TimeFormat time={item.sendTime} />
          </div>
          <div className="sell-price up">
            <PriceFormat price={item.custCashSellRate} />
          </div>
          <div className="buy-price down">
            <PriceFormat price={item.custCashBuyRate} />
          </div>
        </div>
      </div>
    )
  }
}

export default PriceItem;