import React, { Component } from 'react';
import { Router, Route, Link } from 'react-router-dom';
import Header from 'components/Header/Header';
import USDImage from 'style/images/USD.png';
import AUDImage from 'style/images/AUD.png';
import CADImage from 'style/images/CAD.png';
import CHFImage from 'style/images/CHF.png';
import CNYImage from 'style/images/CNY.png';
import EURImage from 'style/images/EUR.png';
import GBPImage from 'style/images/GBP.png';
import HKDImage from 'style/images/HKD.png';
import JPYImage from 'style/images/JPY.png';
import KRWImage from 'style/images/KRW.png';
import NZDImage from 'style/images/NZD.png';
import ModalDiaLog from 'components/ModalDiaLog/ModalDiaLog';
import errorMsg from 'config/errorConfig.js';
import commonTool from 'utils/commonTool.js';
import { queryAccount } from './queryAccount.js';
import { Storage } from 'storage';
import style from './view.scss';

export default class QueryAccountAmt extends Component {
  constructor(props) {
    super(props);
    this.state = {
      handleFlag: false,
      queryAccountList: [],
    };
    this.handleAccount = this
      .handleAccount
      .bind(this);
  }

  componentWillMount() {
    const self = this;
    queryAccount((res) => {
      if (res.success) { // 请求成功
        self.setState({
          queryAccountList: Storage.getItem('tradeAccountList', true),
        });
      } else { // 请求失败
        this.setState({
          errorFlag: true,
          errorMsg: errorMsg[res.message],
        });
      }
    });
  }
  setImageByCur(cur) {
    let imgUrl;
    switch (cur) {
      case 'USD':
        imgUrl = USDImage;
        break;
      case 'AUD':
        imgUrl = AUDImage;
        break;
      case 'CAD':
        imgUrl = CADImage;
        break;
      case 'CHF':
        imgUrl = CHFImage;
        break;
      case 'CNY':
        imgUrl = CNYImage;
        break;
      case 'EUR':
        imgUrl = EURImage;
        break;
      case 'GBP':
        imgUrl = GBPImage;
        break;
      case 'HKD':
        imgUrl = HKDImage;
        break;
      case 'JPY':
        imgUrl = JPYImage;
        break;
      case 'KRW':
        imgUrl = KRWImage;
        break;
      case 'NZD':
        imgUrl = NZDImage;
        break;
      default:
        imgUrl = '';
        break;
    }
    return imgUrl;
  }
  handleAccount() {
    this.setState({
      handleFlag: !this.state.handleFlag,
    });
  }
  render() {
    return (
      <div id="query-account">
        <Header>余额明细</Header>
        <div className="content-info">
          {
            this.state.queryAccountList.length > 0 && this.state.queryAccountList.map((i, index) => {
              // if (i.EXTRACT_AMT == 0 && i.FREEZE_ACCOUNT == 0 && i.ON_WAYACCOUNT == 0 || i.RIGHT_AMT == 0) {

              // } else {
                return (
                  <div key={index} className="item">
                    <div className="item-show" onClick={this.handleAccount}>
                      <div className="flag">
                        <img src={this.setImageByCur(i.CURRENCY)} alt={i.CURRENCY} />
                        <label>{i.CURRENCY}</label>
                      </div>
                      <div className="title-amount">
                        <span>余额&emsp;</span>
                        <label>{commonTool.formatFloatAmount(i.BALANCE_AMT * 1, (i.CURRENCY === 'JPY' ? 0 : 2))}</label>
                      </div>
                    </div>
                    <div className="item-hidden">
                      <div className="hidden-left width40">
                        <label>客户权益</label>
                        <span>{commonTool.formatFloatAmount(i.AVAIL_AMT * 1, (i.CURRENCY === 'JPY' ? 0 : 2))}</span>
                      </div>
                      <div className="hidden-center width30">
                        <label>应付金额</label>
                        <span>{commonTool.formatFloatAmount(i.FREEZE_ACCOUNT * 1, (i.CURRENCY === 'JPY' ? 0 : 2))}</span>
                      </div>
                      <div className="hidden-right width30">
                        <label>可提金额</label>
                        <span>{commonTool.formatFloatAmount(i.EXTRACT_AMT * 1, (i.CURRENCY === 'JPY' ? 0 : 2))}</span>
                      </div>
                    </div>
                  </div>
                );
              // }
            })
          }
        </div>
        <ModalDiaLog
          visible={this.state.errorFlag}
          onClose={() => {
            this.setState({ errorFlag: false });
          }}
          errMsg={this.state.errorMsg}
        />
      </div>
    );
  }
}
