import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import PriceList from 'components/PriceList/PriceList';
import ModalDiaLog from 'components/ModalDiaLog/ModalDiaLog';
import H5NumberInput from 'components/H5NumberInput/H5NumberInput';
import { Button, Slider, Stepper, DatePicker, List, Modal, Icon, Toast } from 'antd-mobile';
import Ajax from 'ajax';
import ActionConfig from 'config/actionConfig.js';
import errorMsg from 'config/errorConfig.js';
import commonTool from 'utils/commonTool.js';
import { queryAccount } from '../query-account/queryAccount.js';
import skipConfig from 'config/config.js';
import { Storage } from 'storage';
import questionMask from '../../style/iconImage/questionMark.png';
import style from './view.scss';

const QUERY_FAILD = '查询失败';
let isExpireDateUpdate = false;

class FirmOrderIndex extends Component {
  constructor(props) {
    super(props);
    const objectId = this.props.pid.replace('|', '/');
    this.state = {
      objectId,
      code1: objectId.split('/')[0],
      code2: objectId.split('/')[1],
      direct: 'buy',
      currency: objectId.split('/')[0],
      account: '',
      budgetAccount: 0,
      pip: 10,
      expireDate: new Date(Date.now()),
      orderMode: 'PT', // 止盈
      orderRate1: 1,
      orderRate2: 1,
      commonStep: 1 / Math.pow(10, this.props.priceObject[objectId].AVAIL_POINT),
      showInfoMsgFlag: false,
    };
    const mid_rate = this.props.priceObject[objectId].MID_RATE;
    // this.initExpireDate();
    this.INT_LENGTH = String(mid_rate).split('.')[0].length + 1;
    this.AVAIL_POINT = this.props.priceObject[objectId].AVAIL_POINT;
    this.alertInstance = {};
    this.referenceRate = this.state.direct === 'buy' ? this.props.priceObject[this.state.objectId].ASK_RATE : this.props.priceObject[this.state.objectId].OFFER_RATE;
    this.doFirmOrder = this.doFirmOrder.bind(this);
    this.handleOrderMode = this.handleOrderMode.bind(this);
    this.closeAlert = this.closeAlert.bind(this);
    this.showInfoMsg = this.showInfoMsg.bind(this);

    window.backFunc = () => {
      if (document.getElementsByClassName('am-number-keyboard-wrapper-hide').length === 0) {
        document.getElementsByClassName('keyboard-hide')[0].click();
      } else if (Object.keys(this.alertInstance).length !== 0) {
        this.closeAlert();
      } else {
        window.history.go(-1);
      }
    };
  }
  componentWillMount() {
    // 到了交易页面再判断一下走势图是不是没有被移除，如果没有则移除
    // 之所以延迟了 100ms ，是因为那边移除比较慢
    setTimeout(() => {
      const kChartId = Storage.getItem('kChartId');
      console.log(kChartId);
      if (kChartId && window.plus.KlineChartPlugin) {
        console.log('removeKChart');
        window.plus.KlineChartPlugin.dismiss(kChartId);
        Storage.removeItem('kChartId');
      }
    }, 100);
    queryAccount((res) => {
      if (res.success) {
        this.tradeAccountBalance();
      }
    });
  }
  componentDidMount() {
    this.chooseMarginOrderDirectOrMode();
  }

  getCurrency() {
    let cur;
    if (this.state.direct === 'buy') {
      if (this.state.currency === this.state.code1) {
        cur = this.state.code2;
      } else {
        cur = this.state.code1;
      }
    } else {
      cur = this.state.currency;
    }
    return cur;
  }
  getExpireDate(val) {
    console.log(val);// 是个日期对象，使用时必须格式化
    isExpireDateUpdate = true;
    this.setState({ expireDate: val }, () => {
      isExpireDateUpdate = false;
    });
  }
  getOrderRate1(val) {
    console.log(val);
    const valArr = String(val).split('.');
    let lengthError;
    if (valArr.length === 2) {
      lengthError = valArr[0].length > this.INT_LENGTH || valArr[1].length > this.AVAIL_POINT;
    } else {
      lengthError = valArr[0].length > this.INT_LENGTH;
    }
    if (val === undefined) {
      this.setState({ orderRate1: 0 });
    } else if (lengthError || /[a-zA-Z-_]/g.test(val) || String(val).split('.').length > 2) {
      console.log('return false');
      console.log(`当前值: ${this.state.orderRate1}`);
      this.setState({ orderRate1: this.state.orderRate1 });
      return false;
    } else {
      console.log('setState');
      this.setState({ orderRate1: val });
    }
  }
  getOrderRate2(val) {
    // this.setState({ orderRate2: val * 1 });
    const valArr = String(val).split('.');
    let lengthError;
    if (valArr.length === 2) {
      lengthError = valArr[0].length > this.INT_LENGTH || valArr[1].length > this.AVAIL_POINT;
    } else {
      lengthError = valArr[0].length > this.INT_LENGTH;
    }
    if (val === undefined) {
      this.setState({ orderRate2: 0 });
    } else if (lengthError || /[a-zA-Z-_]/g.test(val) || String(val).split('.').length > 2) {
      console.log('return false');
      console.log(`当前值: ${this.state.orderRate2}`);
      this.setState({ orderRate2: this.state.orderRate2 });
      return false;
    } else {
      console.log('setState');
      this.setState({ orderRate2: val });
    }
  }
  setOrderPassiveEvent() {
    document.removeEventListener('touchmove', this.stopOrderDefaultEvent);
    document.addEventListener('touchmove', () => {}, {
      passive: true,
    });
  }
  stopOrderDefaultEvent(event) {
    event.preventDefault();
  }

  initExpireDate() {
    // if (Storage.getItem('customerType') === 'personal') {
    //   const orderExpireDate = Number(Storage.getItem('STATIC_PARAMS', true).orderExpireDate);
    //   const minDate = new Date();
    //   const maxDate = new Date();
    //   this.minDate = minDate;
    //   maxDate.setDate(maxDate.getDate() + orderExpireDate);
    //   maxDate.setHours(23);
    //   maxDate.setMinutes(59);
    //   maxDate.setSeconds(59);
    //   this.maxDate = maxDate;
    //   console.error(this.minDate);
    //   console.error(this.maxDate);
    // }
  }

  closeAlert() {
    this.setOrderPassiveEvent();
    this.alertInstance.close();
    this.alertInstance = {};
  }
  alertOrderMsg(obj) {
    return (
      <div className="confirm-content border-item">
        <div><label>流水号</label><span>{obj.SERIAL_NO}</span></div>
        <div><label>货币对</label><span>{obj.CURRENCY_PAIR}</span></div>
        <div><label>交易货币</label><span>{this.state.currency}</span></div>
        <div><label>买卖方向</label><span>{obj.BUY_OR_SELL === 'B' ? '买入' : '卖出'}</span></div>
        <div><label>交易金额</label><span>{obj.TRADE_AMT}{this.state.currency}</span></div>
        <div><label>委托类型</label><span>{obj.ORDER_TYPE === 'PT' ? '止盈' : (obj.ORDER_TYPE === 'SL' ? '止损' : '二选一')}</span>
        </div>
        <div><label>{this.state.orderMode !== 'SL' ? '止盈汇率' : '止损汇率'}</label><span>{this.state.orderRate1}</span></div>
        {this.state.orderMode === 'OCO' ?
          <div><label>止损汇率</label><span>{this.state.orderRate2}</span></div> : ''
        }
        {obj.PREF_POINT ? <div><label>优惠点数</label><span>{obj.PREF_POINT}</span></div> : ''}
        <div><label>失效日期</label><span>{commonTool.formatDate(obj.EXPIRY_DATE)}</span></div>
      </div>
    );
  }
  doFirmOrder(event) {
    event.preventDefault();
    if (this.props.priceObject[this.state.objectId].PRICE_STATUS === 'N') {
      Toast.info('您选择的产品不在交易状态!', 1);
      return false;
    }
    if (this.state.account === '0' || this.state.account === '') {
      Toast.info('交易金额不能为空！', 1);
      return false;
    }
    if (this.state.tradeAccountBalance === QUERY_FAILD) {
      Toast.info('查询可用余额失败，无法发起交易！', 1);
      return false;
    }
    const preAmount = (this.state.currency === this.state.code1 ? this.state.code2 : this.state.code1);
    if (preAmount === this.getCurrency()) {
      if (Math.abs(this.state.budgetAccount * 1) > this.state.tradeAccountBalance * 1) {
        Toast.info('您的可用余额不足，无法发起交易！', 1);
        return false;
      }
    } else if (this.state.account * 1 > this.state.tradeAccountBalance * 1) {
      Toast.info('您的可用余额不足，无法发起交易！', 1);
      return false;
    }
    // 打开交易加载框
    Toast.loading('交易中...', 0);
    const param = {
      CURRENCY_PAIR: this.state.objectId,
      BUY_OR_SELL: this.state.direct === 'buy' ? 'B' : 'S',
      TRADE_CCY: this.state.currency,
      TRADE_AMT: this.state.account * 1,
      REFERENCE_RATE: this.referenceRate,
      TRADE_TYPE: Storage.getItem('customerType') === 'personal' ? 'FIRM_FOREX' : '1',
      CUSTOMER_ID: Storage.getItem('customerId'),
      TRADE_ACCOUNT: Storage.getItem('tradeAccount'),
      CHANNEL: ActionConfig[Storage.getItem('customerType')][0].channel,
      ORDER_TYPE: this.state.orderMode,
      ORDER_RATE1: this.state.orderRate1 * 1,
      ORDER_RATE2: this.state.orderRate2 * 1,
      EXPIRY_DATE: (commonTool.getFormateDate(this.state.expireDate).replace('-', '').replace('-', '')) * 1,
      // EXPIRY_TIME: Storage.getItem('customerType') === 'personal' ? commonTool.getFormateTime(this.state.expireDate) : 235959,
      DUE_DATE: (commonTool.getFormateDate().replace('-', '').replace('-', '')) * 1,
      BOOKING_ID: skipConfig.bookingId,
      TOLERATE_POINT: this.state.pip,
    };
    const url = ActionConfig[Storage.getItem('customerType')][0].doFxOrder;
    Ajax(url, param).then((res) => {
      Toast.hide();// 成功关闭交易加载框
      if (res.success) {
        this.alertInstance = Modal.alert(
          <div><span>委托成功</span><Icon onClick={this.closeAlert} type="cross" color="#309fea" size="lg" /></div>,
          this.alertOrderMsg(res.data.result),
          [
            {
              text: '返回行情',
              onPress: () => {
                console.log('cancel');
                this.setOrderPassiveEvent();
                commonTool.gtjaBurialPoint('138008');
                window.history.go(-1);
              },
            },
            {
              text: '实盘挂单',
              onPress: () => {
                console.log('ok');
                this.setOrderPassiveEvent();
                commonTool.gtjaBurialPoint('138009');
                const path = {
                  pathname: '/QueryOrderList',
                };
                this.props.history.push(path);
              },
            }],
        );
        document.addEventListener('touchmove', this.stopOrderDefaultEvent, {
          passive: false,
        });
      } else {
        this.setState({
          errorFlag: true,
          errorMsg: commonTool.transformErrMsg(res.message),
        });
      }
    }, (err) => {
      Toast.hide();// 成功关闭交易加载框
      console.error(err);
    });
  }
  handleDirect(buyDirect) {
    this.setState({
      direct: buyDirect,
    }, () => {
      this.caculateCharge();
      this.chooseMarginOrderDirectOrMode();
    });
  }
  handleCurrency(codeCurrency) {
    this.setState({
      currency: codeCurrency,
      account: '',
    }, () => {
      this.caculateCharge();
      this.chooseMarginOrderDirectOrMode();
    });
  }
  handleAccount(val) {
    this.setState({
      account: val,
    });
  }
  caculateCharge() {
    const param = this.state;
    const curPriceObj = this.props.priceObject[param.objectId];
    let result;
    if (param.currency === param.code1) {
      if (param.direct === 'buy') { // 买第一货币
        result = -param.account * curPriceObj.ASK_RATE;
        this.referenceRate = curPriceObj.ASK_RATE;
      } else { // 卖第一货币
        result = param.account * curPriceObj.OFFER_RATE;
        this.referenceRate = curPriceObj.OFFER_RATE;
      }
    } else if (param.direct === 'buy') { // 买第二货币
      result = -param.account / curPriceObj.OFFER_RATE;
      this.referenceRate = curPriceObj.OFFER_RATE;
    } else { // 卖第二货币
      result = param.account / curPriceObj.ASK_RATE;
      this.referenceRate = curPriceObj.ASK_RATE;
    }
    this.setState({
      budgetAccount: result,
    });
    this.tradeAccountBalance();
  }
  handleOrderMode(event) {
    this.setState({ orderMode: event.target.value }, this.chooseMarginOrderDirectOrMode);
  }
  chooseMarginOrderDirectOrMode() {
    const buyDirect = this.state.direct;
    const buy = buyDirect === 'buy';
    const fixed = this.props.priceObject[this.state.objectId].AVAIL_POINT;
    const quote = this.props.priceObject[this.state.objectId];
    const offsetRate = 10;
    const offsetRateMore = offsetRate + 1;
    const fixedPrecent = Math.pow(10, fixed);
    const fixedMore = fixed;
    let defaultRate = '';
    let defaultRate2 = '';
    let accRate;
    switch (this.state.orderMode) {
      case 'PT':// 止盈
        this.refs.mgsRadioCon1.style.display = 'block';
        this.refs.mgsRadioCon2.style.display = 'none';
        if (buy && (this.state.currency === this.state.code1)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        if (buy && (this.state.currency === this.state.code2)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code1)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code2)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        this.setState({ orderRate1: commonTool.roundNumber(defaultRate, fixedMore) });
        break;
      case 'SL':// 止损
        this.refs.mgsRadioCon1.style.display = 'block';
        this.refs.mgsRadioCon2.style.display = 'none';
        if (buy && (this.state.currency === this.state.code1)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        if (buy && (this.state.currency === this.state.code2)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code1)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code2)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        this.setState({ orderRate1: commonTool.roundNumber(defaultRate, fixedMore) });
        break;
      case 'OCO':// 二选一
        this.refs.mgsRadioCon1.style.display = 'block';
        this.refs.mgsRadioCon2.style.display = 'block';
        if (buy && (this.state.currency === this.state.code1)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
          defaultRate2 = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        if (buy && (this.state.currency === this.state.code2)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
          defaultRate2 = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code1)) {
          accRate = quote.OFFER_RATE;
          defaultRate = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
          defaultRate2 = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
        }
        if ((!buy) && (this.state.currency === this.state.code2)) {
          accRate = quote.ASK_RATE;
          defaultRate = commonTool.accSub(accRate, offsetRateMore / fixedPrecent);
          defaultRate2 = commonTool.accAdd(accRate, offsetRateMore / fixedPrecent);
        }
        this.setState({
          orderRate1: commonTool.roundNumber(defaultRate, fixedMore),
          orderRate2: commonTool.roundNumber(defaultRate2, fixedMore),
        });
        break;
      default:
        break;
    }
  }
  handleSlider(name, value) {
    console.log(value);
    this.setState({
      pip: value,
    });
  }
  showInfoMsg() {
    this.setState({
      showInfoMsgFlag: true,
    });
  }
  tradeAccountBalance() {
    const tradeAccountList = Storage.getItem('tradeAccountList', true);
    let currencyAccount = {
      AVAIL_AMT: QUERY_FAILD,
    };
    tradeAccountList && tradeAccountList.map((i, index) => {
      if (i.CURRENCY === this.getCurrency()) {
        currencyAccount = i;
      }
    });
    this.setState({
      tradeAccountBalance: currencyAccount.AVAIL_AMT,
    });
  }
  handleAddOrIncre() {
    let info = '';
    if (this.state.budgetAccount < 0) {
      info = '减少';
    } else if (this.state.budgetAccount > 0) {
      info = '增加';
    } else if (this.state.direct === 'buy') {
      info = '减少';
    } else {
      info = '增加';
    }
    return info;
  }
  render() {
    const {
      objectId,
      currency,
      code1,
      code2,
    } = this.state;
    const currentProduct = [this.props.priceObject[objectId]];
    const notTradeCurrency = currency === code1 ? code2 : code1;
    const fixedDec = notTradeCurrency === 'JPY' ? 0 : '';
    const budgetAccount = commonTool.formatFloatAmount(Math.abs(Number(this.state.budgetAccount)), fixedDec, true);
    const isPersonal = Storage.getItem('customerType') === 'personal';
    return (
      <div id="FirmOrderIndex">
        <div className="app_menu order-header">
          <label onClick={() => {
            history.back();
          }}
          >取消
          </label>
          挂单交易
        </div>
        <PriceList posts={currentProduct} />
        <form className="firm-content">
          <div className="item">
            <label>买卖方向</label>
            <span
              className={this.state.direct === 'buy' ? 'active-span left-item' : 'left-item'}
              onClick={this.handleDirect.bind(this, 'buy')}
            >买入
            </span>
            <span
              className={this.state.direct === 'sell' ? 'active-span' : ''}
              onClick={this.handleDirect.bind(this, 'sell')}
            >卖出
            </span>
          </div>
          <div className="item">
            <label>交易币种</label>
            <span
              className={this.state.currency === this.state.code1 ? 'active-span left-item' : 'left-item'}
              onClick={this.handleCurrency.bind(this, this.state.code1)}
            >{this.state.code1}
            </span>
            <span
              className={this.state.currency === this.state.code2 ? 'active-span' : ''}
              onClick={this.handleCurrency.bind(this, this.state.code2)}
            >{this.state.code2}
            </span>
          </div>
          <div className="item width100">
            <label className="widthAuto">交易金额</label>
            <label
              className="widthAuto"
            >{this.state.currency === this.state.code1 ? this.state.code1 : this.state.code2}
            </label>
            <H5NumberInput
              currency={this.state.currency}
              value={this.state.account}
              itemObj={this.props.priceObject[objectId]}
              getInputValue={this.handleAccount.bind(this)}
              onBlur={this.caculateCharge.bind(this)}
              placeHolder={`可用 ${commonTool.formatFloatAmount(this.state.tradeAccountBalance * 1)} ${this.getCurrency()}`}
            />
          </div>
          <div className="item">
            <label>交付日</label>
            <select disabled>
              <option value="">{commonTool.formatDate(currentProduct[0].VALUE_DATE)}</option>
            </select>
          </div>
          <label className="account-budget-content">
            预计
            <span
              className="reCurrency"
            >{this.state.currency === this.state.code1 ? this.state.code2 : this.state.code1}
            </span>余额{this.handleAddOrIncre()}
            <span
              className="account-budget"
            >{budgetAccount}
            </span>
          </label>
        </form>
        <form className="order-content order-type">
          <div className="form-item">
            <label>
              挂单方式
              <select className="mgsOrdMode" defaultValue="pt" ref="mgsOrdMode" onChange={this.handleOrderMode}>
                <option value="PT">止盈</option>
                <option value="SL">止损</option>
                <option value="OCO">二选一</option>
              </select>
              <Icon type="right" size="md" color="#333" />
            </label>
          </div>
          <div className="form-item" ref="mgsRadioCon1">
            <List>
              <List.Item
                extra={
                  <Stepper
                    style={{
                      width: '55%', position: 'absolute', right: '2%', top: '3px',
                    }}
                    showNumber
                    min={0}
                    defaultValue={0}
                    step={this.state.commonStep}
                    value={this.state.orderRate1}
                    onChange={this.getOrderRate1.bind(this)}
                  />
                }
              >
                {this.state.orderMode !== 'OCO' ? '挂单汇率' : '止盈汇率'}
              </List.Item>
            </List>
          </div>
          <div className="form-item" ref="mgsRadioCon2">
            <List>
              <List.Item
                extra={
                  <Stepper
                    style={{
                      width: '55%', position: 'absolute', right: '2%', top: '3px',
                    }}
                    showNumber
                    min={0}
                    defaultValue={0}
                    step={this.state.commonStep}
                    value={this.state.orderRate2}
                    onChange={this.getOrderRate2.bind(this)}
                  />
                }
              >
                止损汇率
              </List.Item>
            </List>
          </div>
        </form>
        {/* <div className="slider-content">
          <div className="slider-title">
            <label>最大价格容忍点差
              <img className="questionMark" alt="" src={questionMask} onClick={this.showInfoMsg} />
              <ModalDiaLog
                visible={this.state.showInfoMsgFlag}
                onClose={() => {
                  this.setState({
                    showInfoMsgFlag: false,
                  });
                }}
                errMsg="如果客户提交订单的价格与最新报价之间的价格差异超过最大价格容忍点差，则交易不予成交。如果价格差异小于最大价格容忍点差，交易以最新报价成交。"
              />
            </label>
            <label>{this.state.pip}</label>
          </div>
          <Slider
            style={{ marginLeft: 10, marginRight: 10 }}
            defaultValue={10}
            min={0}
            max={100}
            onChange={this.handleSlider.bind(this, 'change')}
            onAfterChange={this.handleSlider.bind(this, 'afterChange')}
            handleStyle={{
              width: '15px',
              height: '15px',
              marginTop: '-7px',
              boxShadow: '0 2px 3px 0 rgba(126,200,248,0.99)',
            }}
          />
          <div className="mark-content">
            <span>0</span>
            <span>25</span>
            <span>50</span>
            <span>75</span>
            <span>100</span>
          </div>
        </div> */}
        <form className="order-content form-margin-top">
          <div className="form-item date-select" ref="msg-order-expireDate">
            <DatePicker
              mode="date"
              title="选择失效日期"
              extra="Optional"
              // minDate={this.minDate}
              // maxDate={this.maxDate}
              // disabled={!isPersonal}
              disabled
              value={this.state.expireDate}
              onChange={this.getExpireDate.bind(this)}
            >
              <List.Item arrow="horizontal">失效日期</List.Item>
            </DatePicker>
          </div>
        </form>
        <Button
          type="primary"
          inline
          activeClassName="default-btn-active"
          className="default"
          onClick={this.doFirmOrder}
        >确定
        </Button>
        <ModalDiaLog
          visible={this.state.errorFlag}
          onClose={() => {
            this.setState({ errorFlag: false });
          }}
          errMsg={this.state.errorMsg}
        />
      </div>
    );
  }
}

// DatePicker.prototype.shouldComponentUpdate = () => isExpireDateUpdate;

const mapStateToProps = (state, ownProps) => {
  console.log(state);
  console.log(ownProps);
  const { firmQuotation } = state;
  const selectedInstrument = 'firm';
  const { pid } = ownProps.match.params;
  const {
    items: quotation,
    priceObject,
  } = firmQuotation[selectedInstrument] || {
    items: [],
    priceObject: {},
  };
  return {
    selectedInstrument,
    quotation,
    priceObject,
    pid,
  };
};

export default withRouter(connect(mapStateToProps)(FirmOrderIndex));
