import React, { Component } from 'react';
import { SortableContainer, SortableHandle, SortableElement, arrayMove } from 'react-sortable-hoc';
import commonTool from 'utils/commonTool.js';
import setTopImg from 'style/iconImage/setTop.png';
import settingImg from 'style/iconImage/setting.png';
import productConfig from 'config/productConfig';
import './view.scss';

export default class SortableVerticalList extends Component {
  onSortEnd({ oldIndex, newIndex }) {
    const newItems = arrayMove(this.props.allCode, oldIndex, newIndex);
    // 排序不变不触发渲染
    if (JSON.stringify(newItems) !== JSON.stringify(this.props.allCode)) {
      this.props.onSortEnd(newItems);
    }
  }

  goTop({ oldIndex, newIndex }) {
    const newItems = arrayMove(this.props.allCode, oldIndex, newIndex);
    // 排序不变不触发渲染
    if (JSON.stringify(newItems) !== JSON.stringify(this.props.allCode)) {
      this.props.onSortEnd(newItems);
    }
  }

  sortableList() {
    const DragHandle = SortableHandle(() => (
      <span className="dragH banner" style={{ width: '15%' }}>
        <img src={settingImg} alt="" />
      </span>
    ));
    const SortableItem = SortableElement(({ value }) => (
      <li>
        <div
          className="banner"
          style={{ color: '#ffffff' }}
          onClick={() => {
            this.props.changeItemDisplay(value.val);
          }}
        >
          <span
            className={this.props.items.includes(value.val) ? 'waitSelIcon selIcon' : 'waitSelIcon'}
            onClick={() => {
              console.log(value.val);
              commonTool.gtjaBurialPoint('293025', value.val);
            }}
          />已选中
        </div>
        <div className="banner code-pair" style={{ width: '45%', textAlign: 'left' }}>
          <div className="">{productConfig[value.val]}</div>
          <div className="pb">{value.val}</div>
        </div>
        {this.props.items.includes(value.val) ?
          <span
            className="goTop banner"
            style={{
              width: '15%',
            }}
            onClick={(e) => {
              this.goTop({ oldIndex: value.index, newIndex: 0 });
              commonTool.gtjaBurialPoint('293026');
              e.stopPropagation();
            }}
          >
            <img src={setTopImg} alt="" />
          </span> : ''}
        {this.props.items.includes(value.val) ? <DragHandle /> : ''}
      </li>));
    let val;
    const SortableList = SortableContainer(({ items }) => (
      <ul className="containerClass">
        {
          items.map((value, index) => {
            val = {};
            val.val = value;
            val.index = index;// 保存当前列表排序
            return (
              <SortableItem
                key={`sortableItem-${value}`}
                index={index}
                value={val}
                collection={this.props.items.includes(value) ? '0' : '1'}
              />
            );
          })
        }
      </ul>
    ));
    return (<SortableList
      items={this.props.allCode}
      onSortEnd={({ oldIndex, newIndex }) => this.onSortEnd({ oldIndex, newIndex })}
      lockToContainerEdges
      lockAxis="y"
      useDragHandle
      helperClass="sortableVerticalListMove"
      pressDelay={200}
    />);
  }

  render() {
    return this.sortableList();
  }
}
