import React, { Component } from 'react';
import { connect } from 'react-redux';
import { Link, withRouter } from 'react-router-dom';
import { Storage } from 'storage';
import commonTool from 'utils/commonTool.js';
import PriceList from 'components/PriceList/PriceList';
// import Ajax from 'ajax';
import { requestPublicPipParams, preparePersonParams  } from 'utils/staticParams.js';
import ActionConfig from 'config/actionConfig.js';
import { nativeLogin , setUserInfo } from 'store/loginLogoutAction';
import { requestInterface } from 'utils/dom.js';
import config from './config.js';
import style from './view.scss';

class FirmIndex extends Component {
  constructor(props) {
    super(props);
  }
  goEditInterestCode() {
    const path = {
      pathname: '/EditInterestCode',
    };
    this.props.history.push(path);
  }
  burialPoint(eventId) {
    commonTool.gtjaBurialPoint(eventId);
  }
  callNativeLogin() {
    const { dispatch } = this.props;
    // dispatch(nativeLogin());

    //富易PC
    var reqInfo = {
      name:'客户响应人查询',
      data:{
        CUST_CODE:'#{{longCustId}}',
        aaa:'123'
      }
    };
    requestInterface(reqInfo).then(function(res){
      console.info(reqInfo.name,res);
    });
    // dispatch(requestInterface(dispatch,reqInfo).then(function(res){
    //   console.info(reqInfo.name, res);
    // }));
    // dispatch(setUserInfo(dispatch));
  }

  componentDidMount() {
    // const url = ActionConfig[Storage.getItem('customerType')][0].querySysParams;
    // Ajax(url, {
    //   channel: ActionConfig[Storage.getItem('customerType')][0].channel,
    // }).then((res) => {
    //   console.log(111);
    //   console.log(res);
    // }).catch();

    // requestPublicPipParams({
    //   APPID: 1,
    //   TRADETYPE: 0,
    //   CURRENCY_PAIR: 'EUR/USD',
    //   CYCODE: 'EUR',
    // }, () => {
    //   console.log(123);
    // });

    // preparePersonParams(() => {
    //   console.log(1111);
    //   console.log(localStorage.getItem('STATIC_PARAMS'));
    // });
  }

  renderMenu() {
    const loginState = this.props.loginState;
    if (loginState === 'logined') {
      return (
        <div>
          <div id="navs" className="mui-content-primary">
            <ul className="quickbtn-box">
              {
                config.navigationsLogin.map(item => (
                  <li key={item.title} onClick={this.burialPoint.bind(this, item.eventId)}>
                    <Link to={item.routerName ? item.routerName : ''} id={item.id} data-options={item} style={{ textDecoration: 'none' }}>
                      <div className={`quickbtn ${item.bgColour}`}>
                        <span className={`quickicon eraytfont ${item.icon}`}>
                          <img src={item.imgPath} />
                        </span>
                      </div>
                      <span className="quick-label">{item.title}</span>
                    </Link>
                  </li>
                ))
              }
            </ul>
          </div>
        </div>
      );
    } else {
      return (
        <div>
          <div className="account-state-notLogin">
            <span onClick={this.callNativeLogin.bind(this)} >请登录外汇资金账号</span>
            {/* <span onClick={() => {
              commonTool.gtjaBurialPoint('293002');
            }}
            >没有账号？请先开户!
            </span> */}
          </div>
          {/* <div id="navs" className="mui-content-primary">
            <ul className="quickbtn-box">
              {
                config.navigationsNotLogin.map(item => (
                  <li key={item.title}>
                    <Link to={item.routerName ? item.routerName : ''} id={item.id} data-options={item} style={{ textDecoration: 'none' }}>
                      <div className={`quickbtn ${item.bgColour}`}>
                        <span className={`quickicon eraytfont ${item.icon}`}>
                          <img src={item.imgPath} />
                        </span>
                      </div>
                      <span className="quick-label">{item.title}</span>
                    </Link>
                  </li>
                ))
              }
            </ul>
          </div> */}
        </div>
      );
    }
  }
  render() {
    const ratecode = Storage.getItem('eraytRateCode', true) != null ? Storage.getItem('eraytRateCode', true).interestCode.split(',') : Object.keys(this.props.priceObject);
    const ratecodeObj = [];
    for (const i in ratecode) {
      if (ratecode.hasOwnProperty(i)) {
        const productId = ratecode[i];
        this.props.priceObject[productId] && ratecodeObj.push(this.props.priceObject[productId]);
      }
    }
    return (
      <div id="FirmIndex">
        {this.renderMenu()}
        <div className="tip-box">
          <label>外汇行情</label>
          <span onClick={this.goEditInterestCode.bind(this)}>编辑</span>
        </div>
        <div id="QuotationMargin">
          <div style={{ opacity: 1 }} className="">
            <div className="price-title">
              <span className="cp">货币对</span>
              <span className="sp">卖出价</span>
              <span className="bp">买入价</span>
            </div>
            <div className="" style={{ marginBottom: '45px', paddingTop: '2px' }}>
              <PriceList posts={Object.values(ratecodeObj)[0] === undefined ? this.props.posts : ratecodeObj} instrument="firm" customerClass="li-border" />
              {/* <Link to="/FirmQuotation" className="query-more-box">
                <label>查看更多</label><Icon type="right" size="lg" color="#bac9d8" />
              </Link> */}
            </div>
          </div>
        </div>
      </div>
    );
  }
}

const mapStateToProps = (state) => {
  const { firmQuotation, loginLogout } = state;
  const selectedInstrument = 'firm';
  const {
    isFetching,
    items: posts,
    priceObject,
  } = firmQuotation[selectedInstrument] || {
    isFetching: true,
    items: [],
    priceObject: {},
  };
  return {
    selectedInstrument,
    posts,
    priceObject,
    isFetching,
    loginState: loginLogout.loginState,
  };
};

export default withRouter(connect(mapStateToProps)(FirmIndex));
