import React, { Component } from 'react';
import commonTool from 'utils/commonTool.js';
import HorKchart from './HorKchart';
import horCloseImg from 'style/iconImage/horClose.png';
import style from './view.scss';

class HorizontalChart extends Component {
  constructor(props) {
    super(props);
    const horData = JSON.parse(localStorage.getItem('horizontalDataObj'));
    this.state = {
      objectId: horData.objectId,
      kType: horData.kType,
      quoteData: horData.quoteData,
    };
    this.goBack = this.goBack.bind(this);
    this.refreshKType = this.refreshKType.bind(this);
  }
  goBack() {
    window.location.href = 'gtjanormal://goback';
  }
  refreshKType(KType) {
    let KTypeStr = '';
    switch (KType * 1) {
      case 0:
        KTypeStr = '1分钟';
        break;
      case 1:
        KTypeStr = '5分钟';
        break;
      case 2:
        KTypeStr = '15分钟';
        break;
      case 3:
        KTypeStr = '30分钟';
        break;
      case 4:
        KTypeStr = '1小时';
        break;
      case 6:
        KTypeStr = '日K';
        break;
      case 7:
        KTypeStr = '周K';
        break;
      case 8:
        KTypeStr = '月K';
        break;
      default:
        break;
    }
    this.setState({
      KTypeStr,
    });
  }
  render() {
    return (
      <div id="HorizontalChart">
        <div id="horHeader" className="hor-header">
          <span>{this.state.objectId}</span>&emsp;
          <span>{this.state.KTypeStr ? this.state.KTypeStr : '1分钟'}</span>
          <div className="quote-info">
            <span>最高：{this.state.quoteData.MAX_RATE}</span>&emsp;
            <span>最低：{this.state.quoteData.MIN_RATE}</span>&emsp;
          </div>
          <img onClick={this.goBack} src={horCloseImg} />
        </div>
        <HorKchart
          id={this.state.objectId}
          name={commonTool.formateLanguage(this.state.objectId)}
          quote={this.state.quoteData}
          refreshKType={this.refreshKType}
          show
        />
      </div>

    );
  }
}

export default HorizontalChart;
