import React, { Component } from 'react';
import ClassName from 'classnames';
import plusReady from 'plugins/plusReady';
import { Icon } from 'antd-mobile';
import { getDom, getDomHeight } from 'utils/dom';
import commonTool from 'utils/commonTool.js';
import { Storage } from 'storage';
import KChart from '../quotation-chart/Kchart/k-chart';
import extendDownImg from 'style/iconImage/extendDown.png';
import style from '../quotation-chart/Kchart/_Kchart.scss';

class HorKchart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      kType: 0,
      productId: this.props.id,
      isShowHchart: false,
      proName: props.name,
      quote: props.quote,
    };
    this.horDataObj = {};
    const bindArr = ['createChart', 'initChart'];
    bindArr.forEach(x => this[x] = this[x].bind(this));
  }
  componentDidMount() {
    this.totalHeight = document.body.clientHeight;
    this.totalWidth = document.body.clientWidth;
    this.topHeight = document.getElementById('chartInfo').offsetHeight + document.getElementById('horHeader').offsetHeight;
    this.baseStyle = {
      increasePillarColor: '#ff4a5a',
      reducePillarColor: '#5ac23b',
      primaryIndicatrixStyle: {
        ma5Color: '#2e8ae6',
        ma10Color: '#ffa622',
        ma20Color: '#CC2996',
      },
      indicatrixStyle: {
        indicMACD_increaseColor: '#ff4a5a',
        indicMACD_decreaseColor: '#5ac23b',
      },
    };
    this.chartBoxHeight = `${this.totalHeight - 45}px`;
    getDom('#chart-box').style.height = this.chartBoxHeight;
    const self = this;
    plusReady(() => {
      self.initChart();
    });

    this.horDataObj = {
      objectId: this.state.productId,
      quoteData: this.state.quote,
      kType: this.state.kType,
    };
    localStorage.setItem('horizontalDataObj', JSON.stringify(this.horDataObj));
  }
  componentWillReceiveProps(nextProps) {
    // const idbool = nextProps.id !== this.state.productId;
    // if (idbool || nextProps.quote !== this.state.quote) {
    //   this.setState({ productId: nextProps.id, quote: nextProps.quote, proName: nextProps.name }, () => { idbool && this.createChart(); });
    // } else if (window.plus && this.kchart) {
    //   nextProps.show ? this.kchart.show('', () => {}) : this.kchart.hide();
    // }
  }
  shouldComponentUpdate(nextProps, nextState) {
    const state = this.state;
    return state.kType !== nextState.kType || state.productId !== nextState.productId || state.isShowHchart !== nextState.isShowHchart;
  }
  componentWillUnmount() {
    this.kchart && this.kchart.disMiss();
  }
  setHStyle() {
    const screenHeight = this.totalHeight;

    this.KchartStyle = Object.assign({
      left: 10,
      top: this.topHeight,
      width: (this.totalWidth - 20),
      height: (this.totalHeight - this.topHeight),
    }, this.baseStyle);
  }
  initChart() {
    const state = this.state;
    this.setHStyle();
    console.error(this.KchartStyle);
    this.kchart = new KChart(this.KchartStyle, this.state.quote);
    this.kchart.create(state.productId, state.kType);
  }
  createChart() {
    const state = this.state;
    this.kchart.create(state.productId, state.kType);
  }
  changeChart() {
    const kType = this.state.kType;
    this.props.refreshKType(this.state.kType);
    this.setState({
      kType: kType * 1,
    }, this.createChart);
  }
  handleChartType(chartType, imgId) {
    commonTool.gtjaBurialPoint('138010', this.state.productId, imgId);
    this.setState({
      kType: chartType,
      selectValue: '',
    }, this.changeChart);
  }
  render() {
    const state = this.state;
    const quote = state.quote;
    return (
      !state.isShowHchart ?
        <div id="chart-content">
          <div id="chartInfo" className="chart-info">
            <span className={this.state.kType !== 0 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 0, 4)}>1分钟</span>
            <span className={this.state.kType !== 1 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 1, 5)}>5分钟</span>
            <span className={this.state.kType !== 2 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 2, 6)}>15分钟</span>
            <span className={this.state.kType !== 3 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 3, 7)}>30分钟</span>
            <span className={this.state.kType !== 4 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 4, 8)}>1小时</span>
            <span className={this.state.kType !== 6 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 6, 1)}>日K</span>
            <span className={this.state.kType !== 7 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 7, 2)}>周K</span>
            <span className={this.state.kType !== 8 ? '' : 'active-chart-info'} onClick={this.handleChartType.bind(this, 8, 3)}>月K</span>
          </div>
          <div id="chart-box" />
        </div> :
        ''
    );
  }
}

export default HorKchart;
