import React, { Component } from "react";
import { Radio,DatePicker,Table,Select ,Modal  } from 'antd';
import moment from 'moment';
import 'moment/locale/zh-cn';
import locale from 'antd/lib/date-picker/locale/zh_CN';
moment.locale('zh-cn');
const RadioGroup = Radio.Group;
const Option = Select.Option;
export default class SelectOption extends Component{
    constructor(props){
        super(props);
        const edate = new Date(new Date() - 86400000);
		const sdate = new Date(new Date() - (86400000 * 30));
        this.state={
        	contentArr:['货币对','交易类型','交易状态','挂单状态','资金类型'],     //选择框名称
        	productIdArr:['全部','EUR/USD','EUR/HKD','USD/HKD','USD/JPY','EUR/JPY'],          //货币对
		    tradeTypeArr:['全部','市价','挂单'],         //交易类型
		    tradeStateArr:['全部','成功','失败','审批中'],         //交易状态
		    orderStatusArr:['全部','已成交','待成交','已撤销','已失效','交易无效'],         //挂单状态
		    accountTypeArr:['全部','入金','出金扣账','扣账','入账','结息','红冲','蓝补','冻结','冻结取消','解冻','解冻取消','资金禁取','司法冻结','司法冻结取消','司法扣划'], //资金类型
		    beginDate:new Date(sdate),               //开始日期
      		endDate:edate,                 //结束日期
		    currencyPair: '', //货币对选择框值
		    tradeType: '',    //交易类型选择框值
		    tradeState: '',   //交易状态选择框值
		    orderStatus: '',  //挂单状态选择框值
		    accountType: '',  //资金类型选择框值
        }
    }
    //转换时间格式
    convertToDateObject(str) {
	    const date = new Date(str);
	    return date;
	}
	//日期格式
	dateFormat(date, fmt) {
	    const o = {
	      'm+': date.getMonth() + 1,
	      'd+': date.getDate(),
	      'h+': date.getHours(),
	      'i+': date.getMinutes(),
	      's+': date.getSeconds(),
	      'q+': Math.floor((date.getMonth() + 3) / 3),
	      't': date.getMilliseconds(),
	    };
	    if (/(y+)/.test(fmt)) {
	      fmt = fmt.replace(RegExp.$1, (`${date.getFullYear()}`).substr(4 - RegExp.$1.length));
	    }
	    for (const k in o) {
	      if (new RegExp(`(${k})`).test(fmt)) {
	        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : ((`00${o[k]}`).substr((`${o[k]}`).length)));
	      }
	    }
	    return fmt;
	}
	//检测开始时间与结束时间
	checkDate(value, flag) {
	    if (flag === 1) {
	      let days = this.state.endDate.getTime() - value.getTime();
	      days = parseInt(days / (1000 * 60 * 60 * 24), 10);
	      if (days > 30) {
	      	Modal.warning({
		        okText:'知道了',
		        title: '时间选择错误',
		        content: '查询时间跨度不能超过30天'
		    });
	        return true;
	      }
	      const endDate = this.dateFormat(this.state.endDate, 'yyyy-mm-dd').replace(/-/g, '');
	      value = this.dateFormat(value, 'yyyy-mm-dd').replace(/-/g, '');
	      if (value > endDate) {
	      	Modal.warning({
		        okText:'知道了',
		        title: '时间选择错误',
		        content: '开始日期不能大于结束日期'
		    });
	        return true;
	      }
	    } else {
	      let days = value.getTime() - this.state.beginDate.getTime();
	      days = parseInt(days / (1000 * 60 * 60 * 24), 10);
	      if (days > 30) {
	      	Modal.warning({
		        okText:'知道了',
		        title: '时间选择错误',
		        content: '查询时间跨度不能超过30天'
		    });
	        
	        return true;
	      }
	      const beginDate = this.dateFormat(this.state.beginDate, 'yyyy-mm-dd').replace(/-/g, '');
	      value = this.dateFormat(value, 'yyyy-mm-dd').replace(/-/g, '');
	      if (value < beginDate) {
	      	Modal.warning({
		        okText:'知道了',
		        title: '时间选择错误',
		        content: '开始日期不能大于结束日期'
		    });
	        return true;
	      }
	    }
	  }
	changeBeginDate(value) {
	    console.log(this.convertToDateObject(value));
	    this.setState({
	      beginDate: this.convertToDateObject(value),
	    });
	}
	changeEndDate(value) {
	    console.log(value);
	    this.setState({
	      endDate: this.convertToDateObject(value),
	    });
	}
    currencyPairValue(value){
    	this.setState({
    		currencyPair:value,
    	})
    }
    tradeTypeValue(value){
    	console.log(value)
    	this.setState({
    		tradeType:value,
    	})
    }
    tradeStateValue(value){
    	console.log(value)
    	this.setState({
    		tradeState:value,
    	})
    }
    orderStatusValue(value){
    	console.log(value)
    	this.setState({
    		orderStatus:value,
    	})
    }
    accountTypeValue(value){
    	console.log(value)
    	this.setState({
    		accountType:value,
    	})
    }
    okBtnHandle(e){
    	e.stopPropagation();
		e.preventDefault();//阻止冒泡
    	if(this.props.selectIndexArr[5]){
    		if (this.checkDate(this.state.beginDate, 1)) {
		      	return false;
		    }
		    if (this.checkDate(this.state.endDate, 2)) {
		      	return false;
		    }
    	}
	    const filterObj = {
		      	beginDate: this.state.beginDate,
		      	endDate: this.state.endDate,
		      	currencyPair: this.state.currencyPair,
		      	tradeTypeValue: this.state.tradeType,
		      	tradeStateValue: this.state.tradeState,
		      	orderStatusValue: this.state.orderStatus,
		      	accountTypeValue: this.state.accountType,
	    };
    	console.log(filterObj);
    	this.props.okBtnHandle(filterObj);
    }
    //日期选择器
	disabledDate(current) {
	    // Can not select days after today and today
	    return  current > moment().add(-1, 'days');
	}
    render(){
    	let selectIndexArr = this.props.selectIndexArr;
    	let {contentArr,productIdArr,tradeTypeArr ,tradeStateArr,orderStatusArr,accountTypeArr}= this.state;
    	const edate = new Date(new Date() - 86400000);
		const sdate = new Date(new Date() - (86400000 * 30));
        return(
            <label>
            	{selectIndexArr[5]?
	                <label key='date-picker'>
	                    开始日期：
	                    <DatePicker 
	                    	format="YYYY-MM-DD"
		                  	allowClear={false}  
		                  	disabledDate={this.disabledDate} 
		                  	locale={locale} placeholder='' 
		                  	onChange={this.changeBeginDate.bind(this)}
		                  	defaultValue={moment(this.dateFormat(sdate,'yyyy-mm-dd'), 'YYYY-MM-DD')}
		                  	defaultPickerValue={moment(this.dateFormat(sdate,'yyyy-mm-dd'), 'YYYY-MM-DD')}
		                  	// showToday={false}
	                    />

	                    结束日期：
	                    <DatePicker  
	                    	format="YYYY-MM-DD"
		                  	allowClear={false}  
		                  	disabledDate={this.disabledDate} 
		                  	locale={locale} placeholder='' 
		                  	onChange={this.changeEndDate.bind(this)}
		                  	defaultValue={moment(this.dateFormat(edate,'yyyy-mm-dd'), 'YYYY-MM-DD')}
		                  	defaultPickerValue={moment(this.dateFormat(edate,'yyyy-mm-dd'), 'YYYY-MM-DD')}
		                  	// showToday={false}
	                  	/>
	                </label>
	                :''
	             }
            	{selectIndexArr[0]?
            		<label>
	            		<span>{contentArr[0]}： </span>
	            		<Select name="" id="" value = {this.state.currencyPair} onChange={this.currencyPairValue.bind(this)}>
	            			<Option  value="" >{productIdArr[0]}</Option>
	            			<Option  value={productIdArr[1]} >{productIdArr[1]}</Option>
	            			<Option  value={productIdArr[2]} >{productIdArr[2]}</Option>
	            			<Option  value={productIdArr[3]} >{productIdArr[3]}</Option>
	            			<Option  value={productIdArr[4]} >{productIdArr[4]}</Option>
	            			<Option  value={productIdArr[5] }>{productIdArr[5]}</Option>
	                	</Select>
	                </label>
                	:''
            	} 
            	{selectIndexArr[1]?
            		<label>
	            		<span>{contentArr[1]}： </span>
	            		<Select name="" id="" value = {this.state.tradeType} onChange={this.tradeTypeValue.bind(this)}>
	            			<Option value="">{tradeTypeArr[0]}</Option>
				            <Option value="1">{tradeTypeArr[1]}</Option>
				            <Option value="3">{tradeTypeArr[2]}</Option>
	                	</Select>
	                </label>
                	:''
            	} 
            	{selectIndexArr[2]?
            		<label>
	            		<span>{contentArr[2]}： </span>
	            		<Select name="" id="" value = {this.state.tradeState} onChange={this.tradeStateValue.bind(this)}>
				            <Option value="">{tradeStateArr[0]}</Option>
				            <Option value="1">{tradeStateArr[1]}</Option>
				            <Option value="2">{tradeStateArr[2]}</Option>
				            <Option value="0">{tradeStateArr[3]}</Option>
	                	</Select>
	                </label>
                	:''
            	} 
            	{selectIndexArr[3]?
            		<label>
	            		<span>{contentArr[3]}： </span>
	            		<Select name="" id="" value = {this.state.orderStatus} onChange={this.orderStatusValue.bind(this)}>
	            			<Option value="">全部</Option>
				            <Option value="2">已成交</Option>
				            <Option value="1">待成交</Option>
				            <Option value="3">已撤销</Option>
				            <Option value="4">已失效</Option>
				            <Option value="5">交易无效</Option>
	                	</Select>
	                </label>
                	:''
            	} 
            	{selectIndexArr[4]?
            		<label>
	            		<span>{contentArr[4]}： </span>
	            		<Select name="" id="" value = {this.state.accountType} onChange={this.accountTypeValue.bind(this)}>
				            <Option value="">全部</Option>
				            <Option value="1">入金</Option>
				            <Option value="2">出金扣账</Option>
				            <Option value="3">扣账</Option>
				            <Option value="4">入账</Option>
				            <Option value="5">结息</Option>
				            <Option value="6">红冲</Option>
				            <Option value="7">蓝补</Option>
				            <Option value="8">冻结</Option>
				            <Option value="9">冻结取消</Option>
				            <Option value="10">解冻</Option>
				            <Option value="11">解冻取消</Option>
				            <Option value="12">资金禁取</Option>
				            <Option value="13">司法冻结</Option>
				            <Option value="14">司法冻结取消</Option>
				            <Option value="17">司法扣划</Option>
	                	</Select>
	                </label>
                	:''
            	}             
                <span className='orders-type-confirm' onClick={(e)=>this.okBtnHandle(e)}>确认</span>
            </label>
        )
    }
}