import React,{Component} from 'react'
import { Tooltip } from 'antd';
import './Tool.scss'
import commonTool from './../../utils/commonTool.js';
export default class Tool extends Component{
    constructor(props){
        super(props)
        this.state={
        }
    }
    processDate(){
      var props = this.props;
      if(props.data.length>0){//本次搜索结果
        var th = '';
        props.list.map((itemtd)=>{
          th += `<th>${itemtd}</th>`
        }) 
        var table = document.getElementById('table-list');
        var str = table.getElementsByClassName('ant-table-tbody')[0].innerHTML;
      }
      var userInfo = this.props.userInfo;
      str = `<table>
              <tr><td colspan="5">营业部名称：国泰君安证券 ${userInfo.yybname} </td></tr>
              <tr><td colspan="3">用户名：${userInfo.userName} </td></tr>
              <tr><td colspan="3">资金账号：${userInfo.busiId} </td></tr>
              <tr><td colspan="3">查询日期：${userInfo.ftime} </td></tr>
              </table>
              <table style='text-align:center'>
              <tr>${th?th:''}</tr>
              ${str?str:''}
              </table>`;
      return str
    }
    // 点击“导出”
    tableToExcel() {
      var ths = this;    
      var uri = 'data:application/vnd.ms-excel;base64,',
        template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel"><meta http-equiv="Content-Type" charset=utf-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
        base64 = function (s) {
          return window.btoa(unescape(encodeURIComponent(s)))
        },
        format = function (s, c) {
          return s.replace(/{(\w+)}/g,
            function (m, p) {
              return c[p];
            })
        }
        var ctx = {worksheet: name || 'Worksheet', table: ths.processDate()};
        var link = document.createElement("a");
        link.href = uri + base64(format(template, ctx));
        //对下载的文件命名
        link.download = '富易-'+ ths.props.title +'.xls';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    }
    //打印
    printExcel(){
      //将旧的页面储存起来，当打印完成后返给给页面。
      var oldContent = document.body.innerHTML;
      //赋值给body
      document.body.innerHTML = this.processDate()// newContent;
      //执行window.print打印功能
      window.print();
      // 重新加载页面，以刷新数据。以防打印完之后，页面不能操作的问题
      window.location.reload();
      document.body.innerHTML = oldContent;
      return false;
    }
    render(){
        return(
            <div className='title'>
              <span className='orders-type'>{this.props.title}</span>
              <span className='queryResult'>查询结果: 共[{this.props.queryResultNum}]笔 记录</span> 
              <ul className='tools'>  
                <Tooltip onClick={()=>this.printExcel()} overlayClassName='tooltip' placement="bottom" title='打印'>
                  <li></li>
                </Tooltip>
                <Tooltip onClick={()=>this.tableToExcel()} overlayClassName='tooltip' placement="bottom" title='导出'>
                  <li></li>
                </Tooltip>
                <Tooltip onClick={()=>this.props.refresh()} overlayClassName='tooltip' placement="bottom" title='刷新'>
                  <li></li>
                </Tooltip>
              </ul>
            </div>
        )
    }
    
} 
