import React, { Component } from 'react';
import './TimeFormat.scss';

const TimeFormat = (props) => {
  const time = props.time;
  let fullTime = time;
  if (time < 10) {
    fullTime = `00000${time}`;
  } else if (time < 100) {
    fullTime = `0000${time}`;
  } else if (time < 1000) {
    fullTime = `000${time}`;
  } else if (time < 10000) {
    fullTime = `00${time}`;
  } else if (time < 100000) {
    fullTime = `0${time}`;
  }
  fullTime = fullTime.toString();
  const regex = /^(\d\d)(\d\d)(\d\d)$/;
  const group = fullTime.match(regex);
  if (group) {
    const formatTime = `${group[1]}:${group[2]}:${group[3]}`;
    return <span id="TimeFormat" className="time">{formatTime}</span>;
  }
  return <span id="TimeFormat" className="time">{fullTime}</span>;
};
export default TimeFormat;
