import React, { Component } from 'react';
import { Link } from 'react-router-dom';
import { withRouter } from 'react-router-dom';
import commonTool from 'utils/commonTool.js';
import PriceFormat from 'components/PriceFormat/PriceFormat';
import TimeFormat from 'components/TimeFormat/TimeFormat';
import './PriceList.scss';

class PriceList extends Component {
  constructor(props) {
    super(props);
  }
  shouldComponentUpdate(nextProps, nextState) {
    const props = this.props;
    return props.posts !== nextProps.posts;
  }
  toQuotationChart(obj) {
    commonTool.gtjaBurialPoint('293003');
    if (obj.PRICE_STATUS === 'N') {
      return false;
    }
    const path = {
      pathname: `/QuotationChart/${this.props.instrument}/${obj.productIdWithoutSlash}`,
    };
    this.props.instrument && this.props.history.push(path);
  }
  render() {
    return (
      <ul id="PriceList" className="price-list">
        {this.props.posts.length > 0 && this.props.posts.map((post, i) => (
          post.PRICE_SHOW_STATE === '1' && <li key={post.CURRENCY_PAIR} className={this.props.customerClass || ''} onClick={this.toQuotationChart.bind(this, post)}>
              <div className="coin-cp">
                <span className="chineseName">{commonTool.formateLanguage(post.CURRENCY_PAIR)}</span>
                <span className="englishName">{post.CURRENCY_PAIR}</span>
                {/* <TimeFormat time={post.PRICE_TIME} /> */}
              </div>
              <div className={commonTool.priceColorByStatus(post, 'sell')}>
                <PriceFormat price={post.OFFER_RATE.toFixed(post.AVAIL_POINT)} />
              </div>
              <div className={commonTool.priceColorByStatus(post, 'buy')}>
                <PriceFormat price={post.ASK_RATE.toFixed(post.AVAIL_POINT)} />
              </div>
            </li>
          ))}
      </ul>
    );
  }
}
export default withRouter(PriceList);
