import React, { Component } from 'react';
import Style from './PriceFormat.scss';

const PriceFormat = (props) => {
  let priceStr = Number(props.price).toFixed(props.priceObj.AVAIL_POINT)
  priceStr = priceStr.toString();
  if (priceStr.length >= 2) {
    const length = priceStr.length;
    const e = priceStr.substr(-1);
    const m = priceStr.substring(length - 3, length - 1);
    const b = priceStr.substring(0, length - 3);
    return (
      <span className={props.className?"price-format"+' '+props.className:'price-format'}>
        <span className="small">{b}</span>
        <span className="big">{m}</span>
        <span className="small">{e}</span>
      </span>
    );
  }
  return <span className="">{props.price}</span>;
};


export default PriceFormat;
