import React, { Component } from 'react';
import { List, InputItem } from 'antd-mobile';

class AmountInput extends Component {
  constructor(props) {
    super(props);
    this.teReg1 = /^(([1-9]\d*)|0)(\.\d{0,2}?)?$/;
    this.teReg2 = /^(([1-9]\d*)|0)?$/;
    this.state = {
      type: 'money',
      reg: this.props.currency !== 'JPY' ? this.teReg1 : this.teReg2,
    };
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.currency === 'JPY') {
      this.setState({
        reg: this.teReg2,
      });
    } else {
      this.setState({
        reg: this.teReg1,
      });
    }
  }
  handleInputChange(value) {
    const reg = this.state.reg;
    let inAmount = value;
    if (/^0[1-9]$/.test(inAmount)) {
      inAmount = Number(inAmount);
    }
    if (inAmount && !reg.test(inAmount)) {
      if (inAmount === '.') {
        inAmount = '0.';
      } else {
        inAmount = this.props.value;
      }
    }
    this.props.getInputValue(inAmount);
  }
  render() {
    const { type } = this.state;
    return (
      <div className="amount-input">
        <InputItem
          type={type}
          value={this.props.value}
          placeholder="请输入转账金额"
          clear
          moneyKeyboardAlign="left"
          onChange={value => this.handleInputChange(value)}
          onBlur={this.props.onBlur}
        />
      </div>
    );
  }
}

export default AmountInput;
